/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package ext.domain.nhin.adapter.policyengine;

import java.util.*;
import java.util.logging.*;

import javax.ejb.*;

import gov.hhs.fha.nhinc.common.nhinccommonadapter.*;
import oasis.names.tc.xacml._2_0.context.schema.os.*;

/**
 *
 * @author David Vazquez
 *
 * inputs checkPolicyRequest
 *
 * returns boolean
 *      true authorized       =>  DecisionType.PERMIT
 *      false not authorized  =>  DecisionType.DENY
 *
 * if the passed in ICN from the request is found in the OPTEDIN patient list then they are authorized
 *
 *
 */
/*
@WebService(serviceName = "AdapterPolicyEngine",
            portName = "AdapterPolicyEngineNoOpPortSoap",
            endpointInterface = "gov.hhs.fha.nhinc.adapterpolicyengine.AdapterPolicyEnginePortType",
            targetNamespace = "urn:gov:hhs:fha:nhinc:adapterpolicyengine",
            wsdlLocation = "META-INF/wsdl/AdapterPolicyEngine.wsdl")
*/
@Stateless(name = "AdapterPolicyEnginePermit")
public class AdapterPolicyEnginePermit implements AdapterPolicyEnginePortTypeLocal
{
    static private Logger logger = Logger.getLogger(AdapterPolicyEnginePermit.class.getName());

    public CheckPolicyResponseType checkPolicy(CheckPolicyRequestType checkPolicyRequest)
    {
        logger.entering(getClass().getName(), "checkPolicy", checkPolicyRequest);

        gov.hhs.fha.nhinc.common.nhinccommonadapter.ObjectFactory objFactory
            = new gov.hhs.fha.nhinc.common.nhinccommonadapter.ObjectFactory();

        CheckPolicyResponseType checkPolicyResponse = objFactory.createCheckPolicyResponseType();
        ResponseType response = new ResponseType();
        checkPolicyResponse.setResponse(response);
        List<ResultType> results = response.getResult();
        ResultType result = new ResultType();
        result.setDecision(DecisionType.PERMIT);
        results.add(result);

        logger.exiting(getClass().getName(), "checkPolicy", checkPolicyResponse);

        return checkPolicyResponse;
    }
}
