/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package ext.domain.nhin.adapter.policyengine;

import java.io.*;
import java.net.*;
import java.util.*;
import java.util.logging.*;

import javax.ejb.*;
import javax.jws.*;

import gov.hhs.fha.nhinc.common.nhinccommonadapter.*;
import gov.hhs.fha.nhinc.common.nhinccommon.*;
import oasis.names.tc.xacml._2_0.context.schema.os.*;
import oasis.names.tc.xacml._2_0.context.schema.os.ActionType;
import oasis.names.tc.xacml._2_0.context.schema.os.ResponseType;

import ext.domain.nhin.adapter.datamanager.*;
import ext.domain.nhin.adapter.datamanager.ejb.*;
import ext.domain.nhin.adapter.documentrepository.*;
import ext.domain.nhin.adapter.documentrepository.Document;
import ext.domain.nhin.adapter.propertylookup.*;
import ext.domain.nhin.adapter.utils.NullChecker;
import ext.domain.nhin.adapter.audit.*;
import ext.domain.nhin.adapter.facilitymanager.*;
import ext.domain.nhin.adapter.policyengine.pdpproxy.*;

/**
 *
 * @author David Vazquez
 *
 * inputs checkPolicyRequest
 *
 * returns boolean
 *      true authorized       =>  DecisionType.PERMIT
 *      false not authorized  =>  DecisionType.DENY
 *
 * if the passed in ICN from the request is found in the OPTEDIN patient list then they are authorized
 *
 *
 */
@WebService(serviceName = "AdapterPolicyEngine",
            portName = "AdapterPolicyEnginePortSoap",
            endpointInterface = "gov.hhs.fha.nhinc.adapterpolicyengine.AdapterPolicyEnginePortType",
            targetNamespace = "urn:gov:hhs:fha:nhinc:adapterpolicyengine",
            wsdlLocation = "META-INF/wsdl/AdapterPolicyEngine.wsdl")
@Stateless(name = "AdapterPolicyEngine")
public class AdapterPolicyEngine implements AdapterPolicyEnginePortTypeLocal
{
    static private Logger logger = Logger.getLogger(AdapterPolicyEngine.class.getName());

    static private final String XDS_POLICY_CHECK_ASSIGNING_AUTHORITY = "urn:gov:hhs:fha:nhinc:assigning-authority-id";
    static private final String XDS_POLICY_CHECK_RESOURCE_ID = "urn:oasis:names:tc:xacml:1.0:resource:resource-id";
    static private String SUBJECT_STRUCTURED_ROLE_NS = "urn:oasis:names:tc:xacml:2.0:subject:role";
    static private String SUBJECT_FUNCTIONAL_ROLE_NS = "urn:oasis:names:tc:xspa:1.0:subject:functional_role";

    static private final String ACTION_ATTRIBUTE_ID = "urn:oasis:names:tc:xacml:1.0:action:action-id";
    static private final String SUBJECT_HOME_COMMUNITY_ATTRIBUTE_ID = "urn:gov:hhs:fha:nhinc:home-community-id";
    static private final String SUBJECT_PURPOSE_FOR_USE_ATTRIBUTE_ID = "urn:gov:hhs:fha:nhinc:purpose-for-use";
    static private final String SUBJECT_SUBJECT_ID_ATTRIBUTE_ID = "urn:oasis:names:tc:xacml:1.0:subject:subject-id";
    static private final String RESOURCE_ATTRIBUTE_ID = "urn:oasis:names:tc:xacml:1.0:resource:resource-id";
    static private final String RESOURCE_DOCUMENT_ATTRIBUTE_ID = "urn:gov:hhs:fha:nhinc:document-id";
    static private final String RESOURCE_HOME_COMMUNITY_ATTRIBUTE_ID = "urn:gov:hhs:fha:nhinc:home-community-id";
    static private final String RESOURCE_SUBJECT_ID_ATTRIBUTE_ID = "urn:oasis:names:tc:xacml:1.0:subject:subject-id";
    
    private PropertyLookup propertyLookup;
    private DocumentRepository documentRepository;
    private AuditManager auditManager;
    private FacilityManager facilityManager;
    private PDPProxy pdpProxy;
    private DataManager dataManager;
    
    @EJB(beanInterface = DocumentRepositoryLocal.class, beanName = "DocumentRepository")
    public void setDocumentRepository(DocumentRepository documentRepository)
    {
        this.documentRepository = documentRepository;
    }

    @EJB(beanInterface = PropertyLookupLocal.class, beanName = "PropertyLookup")
    public void setPropertyLookup(PropertyLookup propertyLookup)
    {
        this.propertyLookup = propertyLookup;
    }

    @EJB(beanInterface = FacilityManagerLocal.class, beanName = "FacilityManager")
    public void setFacilityManager(FacilityManager facilityManager) {
        this.facilityManager = facilityManager;
    }

    @EJB(beanInterface = AuditManagerLocal.class, beanName = "AuditManager")
    public void setAuditManager(AuditManager auditManager) {
        this.auditManager = auditManager;
    }

    @EJB(beanInterface = PDPProxyLocal.class, beanName = "PDPProxyVAP")
    public void setPdpProxy(PDPProxy pdpProxy)
    {
        this.pdpProxy = pdpProxy;
    }

    @EJB(beanInterface = DataManagerLocal.class, beanName = "DataManager")
    public void setDataManager(DataManager dataManager)
    {
        this.dataManager = dataManager;
    }
    
    public CheckPolicyResponseType checkPolicy(CheckPolicyRequestType checkPolicyRequest) {
        logger.entering(getClass().getName(), "checkPolicy", checkPolicyRequest);

        RequestType requestType = checkPolicyRequest.getRequest();
        String action = extractValueFromAction(requestType.getAction(), ACTION_ATTRIBUTE_ID);

        if (action.equalsIgnoreCase("DocumentRetrieveIn")) {
            fixResources(requestType);
        }

        ResponseType response = pdpProxy.checkPolicy(requestType);

        gov.hhs.fha.nhinc.common.nhinccommonadapter.ObjectFactory objFactory =
                new gov.hhs.fha.nhinc.common.nhinccommonadapter.ObjectFactory();

        CheckPolicyResponseType checkPolicyResponse = objFactory.createCheckPolicyResponseType();
        checkPolicyResponse.setResponse(response);
// PD Audit Report - Begin
        if (action.equalsIgnoreCase("PatientDiscoveryOut") || action.equalsIgnoreCase("PatientDiscoveryIn")) {
            DataQuery query = dataManager.getQuery("Composite.findDemographics");
            query.setParameter("icn", extractValueFromResource(requestType.getResource().get(0), RESOURCE_ATTRIBUTE_ID));
            Map result = (Map)query.getResults().get(0);
            Map demographics = (Map)result.get("demographics");            
            
            Audit audit = new Audit();
            audit.setAction("CheckPolicy");
            audit.setAuditTime(new Date());
            audit.setPatientId(extractValueFromResource(requestType.getResource().get(0), RESOURCE_ATTRIBUTE_ID).substring(0, 17));
            audit.setPatientLastName((String)demographics.get("nameFamily"));
            audit.setPatientGivenName((String)((List)demographics.get("nameGiven")).get(0));
            audit.setPatientSSN((String)demographics.get("SSN"));
            audit.setPatientFacilityNumber((String)result.get("patientPreferredFacilityNumber"));
            audit.setPatientFacilityName((String)result.get("patientPreferredFacilityName"));
            
            String organization = null;
            String demographicDetails = "icn=" + extractValueFromResource(requestType.getResource().get(0), RESOURCE_ATTRIBUTE_ID) + ", ";

            AssertionType assertion = checkPolicyRequest.getAssertion();
            if (assertion != null) {

                if (assertion.getHomeCommunity() != null
                        && !NullChecker.isNullOrEmpty(assertion.getHomeCommunity().getHomeCommunityId())) {
                    organization = assertion.getHomeCommunity().getHomeCommunityId();
                }

                /* Commented out for now due to lack of data
                if (!NullChecker.isNullOrEmpty(assertion.getSSN())) {
                    demographicDetails += "ssn=" + assertion.getSSN();
                    demographicDetails += ", ";
                } else {
                    demographicDetails += "ssn=, ";
                }

                if (assertion.getPersonName() != null
                        && !NullChecker.isNullOrEmpty(assertion.getPersonName().getFamilyName())) {
                    demographicDetails += "lastName=" + assertion.getPersonName().getFamilyName();
                    demographicDetails += ", ";
                } else {
                    demographicDetails += "lastName=, ";
                }
                if (assertion.getPersonName() != null
                        && !NullChecker.isNullOrEmpty(assertion.getPersonName().getGivenName())) {
                    demographicDetails += "firstName=" + assertion.getPersonName().getGivenName();
                    demographicDetails += ", ";
                } else {
                    demographicDetails += "firstName=, ";
                }
                if (!NullChecker.isNullOrEmpty(assertion.getDateOfBirth())) {
                    demographicDetails += "dob=" + assertion.getDateOfBirth();
                    demographicDetails += ", ";
                } else {
                    demographicDetails += "dob=, ";
                }
                 */

                audit.setUserId(assertion.getUserInfo().getUserName());
                audit.setUserRole(assertion.getUserInfo().getRoleCoded().getCode());
                audit.setPurposeForUse(assertion.getPurposeOfDisclosureCoded().getCode());
                audit.setUserFacilityNumber(assertion.getUserInfo().getOrg().getHomeCommunityId());
                audit.setUserFacilityName(assertion.getUserInfo().getOrg().getName());
                if (assertion.getUserInfo().getPersonName() != null) {
                    PersonNameType personName = assertion.getUserInfo().getPersonName();
                    if (!NullChecker.isNullOrEmpty(personName.getFullName())) {
                        audit.setUserName(personName.getFullName());
                    }
                    else {
                        StringBuilder userName = new StringBuilder();

                        if (NullChecker.isNotNullOrEmpty(personName.getGivenName())) {
                            userName.append(personName.getGivenName());
                        }

                        if (NullChecker.isNotNullOrEmpty(personName.getFamilyName())) {
                            if (userName.length() > 0) {
                                userName.append(' ');
                            }

                            userName.append(personName.getFamilyName());
                        }

                        audit.setUserName(userName.toString());
                    }
                }
            }

            // If Assertion Organization is empty, assume VA
            if (NullChecker.isNullOrEmpty(organization)) {
                organization = facilityManager.getFacilityByFacilityNumber("VA").getFullHomeCommunityId();
            }
            audit.setOrganizationId(organization);

            // PD Out External Org
            String externalOrganization = null;
            if (action.equalsIgnoreCase("PatientDiscoveryOut")) {
                externalOrganization = "urn:oid:" + extractValueFromResource(requestType.getResource().get(0), RESOURCE_HOME_COMMUNITY_ATTRIBUTE_ID);
            }
            else {
                externalOrganization = facilityManager.getFacilityByFacilityNumber("VA").getFullHomeCommunityId();
            }
            audit.setRemoteOrganizationId(externalOrganization);
            
            // Get CheckPolicy Decision
            String responseValue = null;
            if (checkPolicyResponse != null
                    && checkPolicyResponse.getResponse() != null
                    && checkPolicyResponse.getResponse().getResult() != null
                    && checkPolicyResponse.getResponse().getResult().get(0) != null
                    && checkPolicyResponse.getResponse().getResult().get(0).getDecision() != null
                    && !NullChecker.isNullOrEmpty(checkPolicyResponse.getResponse().getResult().get(0).getDecision().value())) {
                responseValue = checkPolicyResponse.getResponse().getResult().get(0).getDecision().value();
            }

            // Build Details Field
            String details = "";
            if (!NullChecker.isNullOrEmpty(responseValue)) {
                details += responseValue + " ";
            }

            if (!NullChecker.isNullOrEmpty(action)) {
                details += action + " ";
            }

            if (!NullChecker.isNullOrEmpty(externalOrganization)) {
                details += "Remote Facility=" + externalOrganization + " ";
            }

            if (!NullChecker.isNullOrEmpty(demographicDetails)) {
                details += demographicDetails + " ";
            }

            audit.setDetails(details);

            auditManager.storeAudit(audit);
        }

// PD Audit Report - End
        logger.exiting(getClass().getName(), "checkPolicy", checkPolicyResponse);

        return checkPolicyResponse;
    }

    private void fixResources(RequestType requestType)
    {
        for (ResourceType resourceType : requestType.getResource()) {
            String patientId = extractValueFromResource(resourceType, RESOURCE_ATTRIBUTE_ID);

            if (NullChecker.isNullOrEmpty(patientId)) {
                String documentId = extractValueFromResource(resourceType, RESOURCE_DOCUMENT_ATTRIBUTE_ID);
                if (!NullChecker.isNullOrEmpty(documentId)) {
                    Document document = documentRepository.getDocumentByDocumentUniqueId(documentId);
                    if (document != null) {
                        AttributeType attribute = new AttributeType();
                        attribute.setAttributeId(RESOURCE_ATTRIBUTE_ID);

                        AttributeValueType attributeValue = new AttributeValueType();
                        attributeValue.getContent().add(qualifyPatientId(document.getPatientId()));
                        attribute.getAttributeValue().add(attributeValue);

                        resourceType.getAttribute().add(attribute);
                    }
                }
            }
        }
    }

    private String extractValueFromAction(ActionType actionType, String key)
    {
        return extractValueFromAttributes(actionType.getAttribute(), key);
    }

    private String extractValueFromSubject(SubjectType subjectType, String key)
    {
        return extractValueFromAttributes(subjectType.getAttribute(), key);
    }

    private String extractValueFromResource(ResourceType resourceType, String key)
    {
        return extractValueFromAttributes(resourceType.getAttribute(), key);
    }

    private String extractValueFromAttributes(List<AttributeType> attributes, String key)
    {
        String ret = null;

        for (AttributeType attribute : attributes) {
            if (attribute != null
                && attribute.getAttributeId() != null
                && attribute.getAttributeId().equalsIgnoreCase(key)
                && !NullChecker.isNullOrEmpty(attribute.getAttributeValue())
                && !NullChecker.isNullOrEmpty(attribute.getAttributeValue().get(0))
                && !NullChecker.isNullOrEmpty(attribute.getAttributeValue().get(0).getContent())) {
                ret = attribute.getAttributeValue().get(0).getContent().get(0).toString();
                break;
            }
        }

        return ret;
    }

    private String qualifyPatientId(String icn)
    {
        return "'" + icn + "^^^&" + propertyLookup.getProperty("HomeCommunityId") + "&ISO'";
    }
}
