/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package ext.domain.nhin.adapter.patientdiscovery;

import java.util.logging.*;

import javax.ejb.*;
import javax.jws.*;
import javax.xml.ws.*;

import gov.hhs.fha.nhinc.adapterpatientdiscovery.*;
import gov.hhs.fha.nhinc.adapterpolicyengine.*;
import gov.hhs.fha.nhinc.common.eventcommon.*;
import gov.hhs.fha.nhinc.common.nhinccommon.*;
import gov.hhs.fha.nhinc.common.nhinccommonadapter.*;
import gov.hhs.fha.nhinc.nhinccomponentpatientcorrelation.*;
import gov.hhs.fha.nhinc.nhinclib.NhincConstants;
import gov.hhs.fha.nhinc.transform.policy.*;
import gov.hhs.fha.nhinc.transform.subdisc.*;
import org.hl7.v3.*;
import oasis.names.tc.xacml._2_0.context.schema.os.*;

import ext.domain.nhin.adapter.adaptermpi.*;
import ext.domain.nhin.adapter.facilitymanager.*;
import ext.domain.nhin.adapter.mpi.*;
import ext.domain.nhin.adapter.mpi.hl7parsers.*;
import ext.domain.nhin.adapter.patientcorrelation.*;
import ext.domain.nhin.adapter.policyengine.*;
import ext.domain.nhin.adapter.propertylookup.*;
import ext.domain.nhin.adapter.utils.*;

/**
 *
 * @author VHAISBVAZQUD
 */
@WebService(serviceName = "AdapterPatientDiscovery",
            wsdlLocation = "META-INF/wsdl/AdapterPatientDiscovery.wsdl",
            portName = "AdapterPatientDiscoveryPortSoap",
            endpointInterface = "gov.hhs.fha.nhinc.adapterpatientdiscovery.AdapterPatientDiscoveryPortType",
            targetNamespace = "urn:gov:hhs:fha:nhinc:adapterpatientdiscovery")
@BindingType(value = javax.xml.ws.soap.SOAPBinding.SOAP12HTTP_BINDING)
@Stateless
public class AdapterPatientDiscovery implements AdapterPatientDiscoveryPortType
{
    static private final Logger logger = Logger.getLogger(AdapterPatientDiscovery.class.getName());
    
    private AdapterMpiPortType adapterMpi;
    private PatientCorrelationPortType adapterPatientCorrelation;
    private AdapterPolicyEnginePortType adapterPolicyEngine;
    private FacilityManager facilityManager;
    private PropertyLookup propertyLookup;
    
    @EJB(beanInterface = AdapterMpiPortTypeLocal.class, beanName = "AdapterMPI")
    public void setAdapterMpi(AdapterMpiPortType adapterMpi)
    {
        this.adapterMpi = adapterMpi;
    }

    @EJB(beanInterface = PatientCorrelationPortTypeLocal.class, beanName = "AdapterPatientCorrelation")
    public void setAdapterPatientCorrelation(PatientCorrelationPortType adapterPatientCorrelation)
    {
        this.adapterPatientCorrelation = adapterPatientCorrelation;
    }

    @EJB(beanInterface = AdapterPolicyEnginePortTypeLocal.class, beanName = "AdapterPolicyEngine")
    public void setAdapterPolicyEngine(AdapterPolicyEnginePortType adapterPolicyEngine)
    {
        this.adapterPolicyEngine = adapterPolicyEngine;
    }

    @EJB(beanInterface = FacilityManagerLocal.class, beanName = "FacilityManager")
    public void setFacilityManager(FacilityManager facilityManager)
    {
        this.facilityManager = facilityManager;
    }

    @EJB(beanInterface = PropertyLookupLocal.class, beanName = "PropertyLookup")
    public void setPropertyLookup(PropertyLookup propertyLookup)
    {
        this.propertyLookup = propertyLookup;
    }
    
    public PRPAIN201306UV02 respondingGatewayPRPAIN201305UV02(RespondingGatewayPRPAIN201305UV02RequestType request)
    {
        logger.entering(getClass().getName(), "respondingGatewayPRPAIN201305UV02");
        
        PRPAIN201306UV02 ret;

        try {
            if (checkPolicyNHINIn(request)
                && (ret = findCandidates(request)) != null
                && isMatch(request, ret)
                && checkPolicyPatientDiscoveryIn(request, ret)) {
                if (requestHasPatientId(request)) {
                    addPatientCorrelation(request, ret);
                }
            }
            else {
                ret = createPatientNotFoundResponse(request, getHomeCommunityId(), getAssigningAuthorityId());
            }
        }
        catch (Throwable t) {
            String hcid;
            String hcidName;
            if (request.getAssertion() != null
                && request.getAssertion().getHomeCommunity() != null) {
                hcid = request.getAssertion().getHomeCommunity().getHomeCommunityId();
                hcidName = request.getAssertion().getHomeCommunity().getName();
            }
            else {
                hcid = "N/A";
                hcidName = "Not Available";
            }
            logger.log(Level.WARNING, "Error processing PatientDiscovery from {0} {1} - {2}", new Object[]{hcid, hcidName, t.getMessage()});
            logger.log(Level.WARNING, "Stack trace", t);
            ret = createErrorResponse(request, getHomeCommunityId(), getAssigningAuthorityId());
        }
        
        logger.exiting(getClass().getName(), "respondingGatewayPRPAIN201305UV02");
        
        return ret;
    }

    private boolean checkPolicyNHINIn(RespondingGatewayPRPAIN201305UV02RequestType request)
    {
        String senderOID = getSenderOID(request.getPRPAIN201305UV02());
        
        return !NullChecker.isNullOrEmpty(senderOID)
               && !senderOID.equals(propertyLookup.getProperty("HomeCommunityId"))
               && facilityManager.getFacilityByHomeCommunityId(senderOID) != null;
    }

    private PRPAIN201306UV02 findCandidates(RespondingGatewayPRPAIN201305UV02RequestType request)
    {
        return adapterMpi.findCandidates(request);
    }

    private boolean isMatch(RespondingGatewayPRPAIN201305UV02RequestType request, PRPAIN201306UV02 response)
    {
        return response != null && response.getControlActProcess() != null && !NullChecker.isNullOrEmpty(response.getControlActProcess().getSubject());
    }

    private boolean checkPolicyPatientDiscoveryIn(RespondingGatewayPRPAIN201305UV02RequestType request, PRPAIN201306UV02 response)
    {
        String roid = null;
        String soid = null;

        if (response != null
            && !NullChecker.isNullOrEmpty(response.getReceiver())
            && response.getReceiver().get(0) != null
            && response.getReceiver().get(0).getDevice() != null
            && response.getReceiver().get(0).getDevice().getAsAgent() != null
            && response.getReceiver().get(0).getDevice().getAsAgent().getValue() != null
            && response.getReceiver().get(0).getDevice().getAsAgent().getValue().getRepresentedOrganization() != null
            && response.getReceiver().get(0).getDevice().getAsAgent().getValue().getRepresentedOrganization().getValue() != null
            && !NullChecker.isNullOrEmpty(response.getReceiver().get(0).getDevice().getAsAgent().getValue().getRepresentedOrganization().getValue().getId())
            && response.getReceiver().get(0).getDevice().getAsAgent().getValue().getRepresentedOrganization().getValue().getId().get(0) != null
            && !NullChecker.isNullOrEmpty(response.getReceiver().get(0).getDevice().getAsAgent().getValue().getRepresentedOrganization().getValue().getId().get(0).getRoot())) {
            roid = response.getReceiver().get(0).getDevice().getAsAgent().getValue().getRepresentedOrganization().getValue().getId().get(0).getRoot();
        }

        if (response != null
            && response.getSender() != null
            && response.getSender().getDevice() != null
            && response.getSender().getDevice().getAsAgent() != null
            && response.getSender().getDevice().getAsAgent().getValue() != null
            && response.getSender().getDevice().getAsAgent().getValue().getRepresentedOrganization() != null
            && response.getSender().getDevice().getAsAgent().getValue().getRepresentedOrganization().getValue() != null
            && !NullChecker.isNullOrEmpty(response.getSender().getDevice().getAsAgent().getValue().getRepresentedOrganization().getValue().getId())
            && response.getSender().getDevice().getAsAgent().getValue().getRepresentedOrganization().getValue().getId().get(0) != null
            && !NullChecker.isNullOrEmpty(response.getSender().getDevice().getAsAgent().getValue().getRepresentedOrganization().getValue().getId().get(0).getRoot())) {
            soid = response.getSender().getDevice().getAsAgent().getValue().getRepresentedOrganization().getValue().getId().get(0).getRoot();
        }

        PatDiscReqEventType policyCheckReq = new PatDiscReqEventType();
        policyCheckReq.setDirection(NhincConstants.POLICYENGINE_INBOUND_DIRECTION);

        policyCheckReq.setPRPAIN201306UV02(response);
        policyCheckReq.setAssertion(request.getAssertion());
        HomeCommunityType senderHC = new HomeCommunityType();
        senderHC.setHomeCommunityId(roid);
        policyCheckReq.setSendingHomeCommunity(senderHC);
        HomeCommunityType receiverHC = new HomeCommunityType();
        receiverHC.setHomeCommunityId(soid);
        policyCheckReq.setReceivingHomeCommunity(receiverHC);

        PolicyEngineTransformer policyEngineTransformer = new PolicyEngineTransformer();
        CheckPolicyRequestType checkPolicyRequest = policyEngineTransformer.transformPatDiscReqToCheckPolicy(policyCheckReq);

        CheckPolicyResponseType checkPolicyResponse = adapterPolicyEngine.checkPolicy(checkPolicyRequest);

        return checkPolicyResponse.getResponse().getResult().get(0).getDecision() == DecisionType.PERMIT;
    }

    private boolean requestHasPatientId(RespondingGatewayPRPAIN201305UV02RequestType request)
    {
        return extractPatientIdFrom201305(request.getPRPAIN201305UV02()) != null;
    }

    public II extractPatientIdFrom201305(PRPAIN201305UV02 request)
    {
        II patId = null;
        String aaId = null;

        if (request != null
            && request.getControlActProcess() != null) {

            aaId = getAAOID(request);

            if (!NullChecker.isNullOrEmpty(aaId)) {
                if (request.getControlActProcess().getQueryByParameter() != null
                    && request.getControlActProcess().getQueryByParameter().getValue() != null
                    && request.getControlActProcess().getQueryByParameter().getValue().getParameterList() != null
                    && !NullChecker.isNullOrEmpty(request.getControlActProcess().getQueryByParameter().getValue().getParameterList().getLivingSubjectId())) {
                    for (PRPAMT201306UV02LivingSubjectId livingSubId : request.getControlActProcess().getQueryByParameter().getValue().getParameterList().getLivingSubjectId()) {
                        for (II id : livingSubId.getValue()) {
                            if (id != null
                                && !NullChecker.isNullOrEmpty(id.getRoot())
                                && !NullChecker.isNullOrEmpty(id.getExtension())
                                && aaId.contentEquals(id.getRoot())) {
                                patId = new II();
                                patId.setRoot(id.getRoot());
                                patId.setExtension(id.getExtension());

                                // break out of inner loop
                                break;
                            }
                        }

                        // If the patient id was found then break out of outer loop
                        if (patId != null) {
                            break;
                        }
                    }
                }
            }
        }

        return patId;
    }

    private void addPatientCorrelation(RespondingGatewayPRPAIN201305UV02RequestType request, PRPAIN201306UV02 response)
    {
        PRPAIN201301UV02 prpain201301UV02 = HL7PRPA201301Transforms.createPRPA201301(request.getPRPAIN201305UV02(), getHomeCommunityId());
        II localPatientId = response.getControlActProcess().getSubject().get(0).getRegistrationEvent().getSubject1().getPatient().getId().get(0);
        prpain201301UV02.getControlActProcess().getSubject().get(0).getRegistrationEvent().getSubject1().getPatient().getId().add(localPatientId);
        AddPatientCorrelationRequestType r = new AddPatientCorrelationRequestType();
        r.setPRPAIN201301UV02(prpain201301UV02);
        r.setAssertion(request.getAssertion());
        adapterPatientCorrelation.addPatientCorrelation(r);
    }

    private PRPAIN201306UV02 createPatientNotFoundResponse(RespondingGatewayPRPAIN201305UV02RequestType request, String homeCommunityId, String assigningAuthorityId)
    {
        return HL7DbParser201306.BuildMessageFromMpiPatients(null, request.getPRPAIN201305UV02(), homeCommunityId, assigningAuthorityId);
    }
    
    private PRPAIN201306UV02 createErrorResponse(RespondingGatewayPRPAIN201305UV02RequestType request, String homeCommunityId, String assigningAuthorityId)
    {
        PRPAIN201306UV02 ret = HL7DbParser201306.BuildMessageFromMpiPatients(null, request.getPRPAIN201305UV02(), homeCommunityId, assigningAuthorityId);
        ret.getControlActProcess().getQueryAck().getQueryResponseCode().setCode("QE");
        return ret;
    }
    
    private String getSenderOID(PRPAIN201305UV02 request)
    {
        String ret = null;
        
        if (request.getSender() != null
            && request.getSender().getDevice() != null
            && request.getSender().getDevice().getAsAgent() != null
            && request.getSender().getDevice().getAsAgent().getValue() != null
            && request.getSender().getDevice().getAsAgent().getValue().getRepresentedOrganization() != null
            && request.getSender().getDevice().getAsAgent().getValue().getRepresentedOrganization().getValue() != null
            && request.getSender().getDevice().getAsAgent().getValue().getRepresentedOrganization().getValue().getId() != null
            && !NullChecker.isNullOrEmpty(request.getSender().getDevice().getAsAgent().getValue().getRepresentedOrganization().getValue().getId())) {
            ret = request.getSender().getDevice().getAsAgent().getValue().getRepresentedOrganization().getValue().getId().get(0).getRoot();
        }        
        
        return ret;
    }
    
    private String getAAOID(PRPAIN201305UV02 request)
    {
        String oid = null;

        if (request != null
            && request.getControlActProcess() != null
            && !NullChecker.isNullOrEmpty(request.getControlActProcess().getAuthorOrPerformer())
            && request.getControlActProcess().getAuthorOrPerformer().get(0) != null
            && request.getControlActProcess().getAuthorOrPerformer().get(0).getAssignedDevice() != null
            && request.getControlActProcess().getAuthorOrPerformer().get(0).getAssignedDevice().getValue() != null
            && !NullChecker.isNullOrEmpty(request.getControlActProcess().getAuthorOrPerformer().get(0).getAssignedDevice().getValue().getId())
            && request.getControlActProcess().getAuthorOrPerformer().get(0).getAssignedDevice().getValue().getId().get(0) != null
            && !NullChecker.isNullOrEmpty(request.getControlActProcess().getAuthorOrPerformer().get(0).getAssignedDevice().getValue().getId().get(0).getRoot())) {
            oid = request.getControlActProcess().getAuthorOrPerformer().get(0).getAssignedDevice().getValue().getId().get(0).getRoot();
        }

        return oid;
    }
    
    private String getReceiverOID(PRPAIN201305UV02 request)
    {
        String ret = null;
        
        if (request != null
            && !NullChecker.isNullOrEmpty(request.getReceiver())
            && request.getReceiver().get(0) != null
            && request.getReceiver().get(0).getDevice() != null
            && request.getReceiver().get(0).getDevice().getAsAgent() != null
            && request.getReceiver().get(0).getDevice().getAsAgent().getValue() != null
            && request.getReceiver().get(0).getDevice().getAsAgent().getValue().getRepresentedOrganization() != null
            && request.getReceiver().get(0).getDevice().getAsAgent().getValue().getRepresentedOrganization().getValue() != null
            && !NullChecker.isNullOrEmpty(request.getReceiver().get(0).getDevice().getAsAgent().getValue().getRepresentedOrganization().getValue().getId())
            && request.getReceiver().get(0).getDevice().getAsAgent().getValue().getRepresentedOrganization().getValue().getId().get(0) != null
            && !NullChecker.isNullOrEmpty(request.getReceiver().get(0).getDevice().getAsAgent().getValue().getRepresentedOrganization().getValue().getId().get(0).getRoot())) {
            ret = request.getReceiver().get(0).getDevice().getAsAgent().getValue().getRepresentedOrganization().getValue().getId().get(0).getRoot();
        }
        
        return ret;
    }
    
    private String getHomeCommunityId()
    {
        String ret = null;
        Facility facility = facilityManager.getFacilityByFacilityNumber("VA");
        if (facility != null) {
            ret = facility.getHomeCommunityId();
        }
        return ret;
    }
    
    private String getAssigningAuthorityId()
    {
        return propertyLookup.getProperty("AssigningAuthority");
    }
}
