/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package ext.domain.nhin.adapter.docretrieve;

import java.util.*;
import java.util.logging.*;

import javax.ejb.*;
import javax.jws.*;

import gov.hhs.fha.nhinc.adapterdocretrieve.*;
import gov.hhs.fha.nhinc.common.nhinccommon.*;
import gov.hhs.fha.nhinc.common.nhinccommonadapter.*;
import ihe.iti.xds_b._2007.*;
import ihe.iti.xds_b._2007.RetrieveDocumentSetRequestType.*;
import ihe.iti.xds_b._2007.RetrieveDocumentSetResponseType.*;
import oasis.names.tc.ebxml_regrep.xsd.rs._3.*;

import ext.domain.nhin.adapter.audit.*;
import ext.domain.nhin.adapter.datamanager.*;
import ext.domain.nhin.adapter.datamanager.ejb.*;
import ext.domain.nhin.adapter.documentrepository.*;
import ext.domain.nhin.adapter.documentrepository.Document;
import ext.domain.nhin.adapter.facilitymanager.*;
import ext.domain.nhin.adapter.facilitymanager.Facility;
import ext.domain.nhin.adapter.propertylookup.*;
import ext.domain.nhin.adapter.utils.NullChecker;

/**
 *
 * @author David Vazquez
 */
@WebService(serviceName = "AdapterDocRetrieve",
            portName = "AdapterDocRetrievePortSoap11",
            endpointInterface = "gov.hhs.fha.nhinc.adapterdocretrieve.AdapterDocRetrievePortType",
            targetNamespace = "urn:gov:hhs:fha:nhinc:adapterdocretrieve",
            wsdlLocation = "META-INF/wsdl/AdapterDocRetrieve.wsdl")
@Stateless(name = "DocRetrieve")
public class DocRetrieve implements AdapterDocRetrievePortTypeLocal
{
    static public final Logger logger = Logger.getLogger(DocRetrieve.class.getName());
    
    static public final String XDS_RETRIEVE_RESPONSE_STATUS_FAILURE = "urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:Failure";
    static public final String XDS_RETRIEVE_RESPONSE_STATUS_SUCCESS = "urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:Success";
    static private final String REPOSITORY_UNIQUE_ID = "1";
    
    static private final String ERROR_XDS_REPOSITORY_ERROR = "XDSRepositoryError";
    static private final String ERROR_DESC_XDS_REPOSITORY_ERROR = "Internal Registry/Repository Error";
    static private final String ERROR_XDS_DOCUMENT_UNIQUE_ID_ERROR = "XDSDocumentUniqueIdError";
    static private final String ERROR_DESC_XDS_DOCUMENT_UNIQUE_ID_ERROR = "Document is not Available";
    static private final String ERROR_XDS_MISSING_HOME_COMMUNITY_ID = "XDSMissingHomeCommunityId";
    static private final String ERROR_DESC_XDS_MISSING_HOME_COMMUNITY_ID = "A value for the homeCommunityId is required and has not been specified";
    static private final String ERROR_XDS_UNKNOWN_COMMUNITY = "XDSUnknownCommunity";
    static private final String ERROR_DESC_XDS_UNKNOWN_COMMUNITY = "A value for the homeCommunityId is not recognized";
    static private final String ERROR_XDS_UNKNOWN_REPOSITORY_ID = "XDSUnknownRepositoryId";
    static private final String ERROR_DESC_XDS_UNKNOWN_REPOSITORY_ID = "A value for repositoryUniqueId is not recognized";
    
    private PropertyLookup propertyLookup;
    private AuditManager auditManager;
    private FacilityManager facilityManager;
    private DocumentRepository documentRepository;
    private DataManager dataManager;
    
    @EJB(beanInterface = PropertyLookupLocal.class, beanName = "PropertyLookup")
    public void setPropertyLookup(PropertyLookup propertyLookup)
    {
        this.propertyLookup = propertyLookup;
    }

    @EJB(beanInterface = AuditManagerLocal.class, beanName = "AuditManager")
    public void setAuditManager(AuditManager auditManager)
    {
        this.auditManager = auditManager;
    }

    @EJB(beanInterface = FacilityManagerLocal.class, beanName = "FacilityManager")
    public void setFacilityManager(FacilityManager facilityManager)
    {
        this.facilityManager = facilityManager;
    }

    @EJB(beanInterface = DocumentRepositoryLocal.class, beanName = "DocumentRepository")
    public void setDocumentRepository(DocumentRepository documentRepository)
    {
        this.documentRepository = documentRepository;
    }

    @EJB(beanInterface = DataManagerLocal.class, beanName = "DataManager")
    public void setDataManager(DataManager dataManager)
    {
        this.dataManager = dataManager;
    }

    public RetrieveDocumentSetResponseType respondingGatewayCrossGatewayRetrieve(RespondingGatewayCrossGatewayRetrieveRequestType respondingGatewayCrossGatewayRetrieveRequest)
    {
        logger.entering(getClass().getName(), "respondingGatewayCrossGatewayRetrieve");

        RetrieveDocumentSetRequestType body = respondingGatewayCrossGatewayRetrieveRequest.getRetrieveDocumentSetRequest();
        RetrieveDocumentSetResponseType ret = createRetrieveDocumentSetResponse();

        try {
            Facility homeFacility = facilityManager.getFacilityByFacilityNumber("VA");
            
            for (DocumentRequest dr : body.getDocumentRequest()) {
                Document doc = null;
                
                if (NullChecker.isNullOrEmpty(dr.getHomeCommunityId())) {
                    addErrorToRetrieveDocumentSetResponse(ret, ERROR_XDS_MISSING_HOME_COMMUNITY_ID, ERROR_DESC_XDS_MISSING_HOME_COMMUNITY_ID);
                }
                else if (!dr.getHomeCommunityId().equals(homeFacility.getFullHomeCommunityId())) {
                    addErrorToRetrieveDocumentSetResponse(ret, ERROR_XDS_UNKNOWN_COMMUNITY, ERROR_DESC_XDS_UNKNOWN_COMMUNITY);
                }
                else if (NullChecker.isNullOrEmpty(dr.getRepositoryUniqueId())
                         ||!(dr.getRepositoryUniqueId().equals(REPOSITORY_UNIQUE_ID)
                         || dr.getRepositoryUniqueId().equals(homeFacility.getHomeCommunityId() + "." + REPOSITORY_UNIQUE_ID))) {
                    addErrorToRetrieveDocumentSetResponse(ret, ERROR_XDS_UNKNOWN_REPOSITORY_ID, ERROR_DESC_XDS_UNKNOWN_REPOSITORY_ID);
                }
                else if (NullChecker.isNullOrEmpty(dr.getDocumentUniqueId())
                         || (doc = documentRepository.getDocumentByDocumentUniqueId(dr.getDocumentUniqueId())) == null) {
                    addErrorToRetrieveDocumentSetResponse(ret, ERROR_XDS_DOCUMENT_UNIQUE_ID_ERROR, ERROR_DESC_XDS_DOCUMENT_UNIQUE_ID_ERROR);
                }
                else {
                    if (doc.getRawData() == null) {
                        generateDocument(doc);
                    }
                    
                    doc.setLastAccessedTime(new Date());
                    documentRepository.storeDocument(doc);
                    
                    addDocumentToRetrieveDocumentSetResponse(ret, doc, dr);
                    auditRetrieve(doc, respondingGatewayCrossGatewayRetrieveRequest.getAssertion());
                }
            }
            
            setRegistryResponseStatus(ret);
        }
        catch (Throwable t) {
            String hcid;
            String hcidName;
            if (respondingGatewayCrossGatewayRetrieveRequest.getAssertion() != null
                && respondingGatewayCrossGatewayRetrieveRequest.getAssertion().getHomeCommunity() != null) {
                hcid = respondingGatewayCrossGatewayRetrieveRequest.getAssertion().getHomeCommunity().getHomeCommunityId();
                hcidName = respondingGatewayCrossGatewayRetrieveRequest.getAssertion().getHomeCommunity().getName();
            }
            else {
                hcid = "N/A";
                hcidName = "Not Available";
            }
            logger.log(Level.WARNING, "Error processing DocRetrieve from {0} {1} - {2}", new Object[]{hcid, hcidName, t.getMessage()});
            logger.log(Level.WARNING, "Stack trace", t);
            addErrorToRetrieveDocumentSetResponse(ret, ERROR_XDS_REPOSITORY_ERROR, ERROR_DESC_XDS_REPOSITORY_ERROR);
        }
        finally {
            logger.exiting(getClass().getName(), "respondingGatewayCrossGatewayRetrieve");
        }

        return ret;
    }

    private void generateDocument(Document document)
        throws Exception
    {
        DataQuery dataQuery = dataManager.getQuery(document.getDocGenQueryName());

        for (String param : document.getDocGenQueryParams().split(",")) {
            String[] p = param.split("=");
            dataQuery.setParameter(p[0], p[1]);
        }

        List<Document> results = dataQuery.getResults(Document.class);

        if (!NullChecker.isNullOrEmpty(results)) {
            Document resultDoc = results.get(0);
            document.setRawData(resultDoc.getRawData());
            document.setHash(resultDoc.getHash());
            document.setSize(resultDoc.getSize());
            document.setAvailabilityStatus(resultDoc.getAvailabilityStatus());
        }
        else {
            throw new Exception("There was an error generating the document.");
        }
    }

    private RetrieveDocumentSetResponseType createRetrieveDocumentSetResponse()
    {
        ihe.iti.xds_b._2007.ObjectFactory retObjFactory = new ihe.iti.xds_b._2007.ObjectFactory();
        RetrieveDocumentSetResponseType ret = retObjFactory.createRetrieveDocumentSetResponseType();

        ret.setRegistryResponse(createRegistryResponse());

        return ret;
    }
    
    private RegistryResponseType createRegistryResponse()
    {
        oasis.names.tc.ebxml_regrep.xsd.rs._3.ObjectFactory retObjFactory = new oasis.names.tc.ebxml_regrep.xsd.rs._3.ObjectFactory();
        RegistryResponseType ret = retObjFactory.createRegistryResponseType();
        return ret;
    }

    private void addDocumentToRetrieveDocumentSetResponse(RetrieveDocumentSetResponseType ret, Document doc, DocumentRequest dr)
    {
        DocumentResponse documentResponse = new DocumentResponse();

        documentResponse.setHomeCommunityId(dr.getHomeCommunityId());
        documentResponse.setRepositoryUniqueId(dr.getRepositoryUniqueId());
        documentResponse.setDocumentUniqueId(doc.getDocumentUniqueId());
        documentResponse.setMimeType(doc.getMimeType());
        documentResponse.setDocument(doc.getRawData());
        
        ret.getDocumentResponse().add(documentResponse);
    }
    
    private void addErrorToRetrieveDocumentSetResponse(RetrieveDocumentSetResponseType ret, String errorCode, String codeContext)
    {
        RegistryError registryError = createRegistryError(errorCode, codeContext);
        
        if (ret.getRegistryResponse().getRegistryErrorList() == null) {
            ret.getRegistryResponse().setRegistryErrorList(createRegistryErrorList());
        }
        
        ret.getRegistryResponse().getRegistryErrorList().getRegistryError().add(registryError);
    }

    private RegistryErrorList createRegistryErrorList()
    {
        oasis.names.tc.ebxml_regrep.xsd.rs._3.ObjectFactory retObjFactory = new oasis.names.tc.ebxml_regrep.xsd.rs._3.ObjectFactory();
        RegistryErrorList ret = retObjFactory.createRegistryErrorList();
        ret.setHighestSeverity("urn:oasis:names:tc:ebxml-regrep:ErrorSeverityType:Error");
        return ret;
    }

    private RegistryError createRegistryError(String errorCode, String codeContext)
    {
        oasis.names.tc.ebxml_regrep.xsd.rs._3.ObjectFactory retObjFactory = new oasis.names.tc.ebxml_regrep.xsd.rs._3.ObjectFactory();
        RegistryError ret = retObjFactory.createRegistryError();
        ret.setSeverity("urn:oasis:names:tc:ebxml-regrep:ErrorSeverityType:Error");
        ret.setErrorCode(errorCode);
        ret.setCodeContext(codeContext);
        ret.setLocation(getHomeFacility().getFullHomeCommunityId());
        return ret;
    }

    private void auditRetrieve(Document doc, AssertionType assertion)
    {
        Audit audit = new Audit();
        audit.setAction("Retrieve Document");
        audit.setAuditTime(new Date());
        audit.setDocumentId(doc.getDocumentUniqueId());
        audit.setPatientId(doc.getPatientId());
        audit.setPatientSSN(doc.getPatientSSN());
        audit.setPatientLastName(doc.getPatientLastName());
        audit.setPatientGivenName(doc.getPatientGivenName());
        audit.setPatientFacilityNumber(doc.getPatientPreferredFacilityNumber());
        audit.setPatientFacilityName(doc.getPatientPreferredFacilityName());
        audit.setOrganizationId(assertion.getHomeCommunity().getHomeCommunityId());
        audit.setPurposeForUse(assertion.getPurposeOfDisclosureCoded().getCode());
        audit.setUserId(assertion.getUserInfo().getUserName());
        audit.setUserRole(assertion.getUserInfo().getRoleCoded().getCode());
        audit.setUserFacilityNumber(assertion.getUserInfo().getOrg().getHomeCommunityId());
        audit.setUserFacilityName(assertion.getUserInfo().getOrg().getName());
        if (assertion.getUserInfo().getPersonName() != null) {
            PersonNameType personName = assertion.getUserInfo().getPersonName();
            if (!NullChecker.isNullOrEmpty(personName.getFullName())) {
                audit.setUserName(personName.getFullName());
            }
            else {
                audit.setUserName(personName.getGivenName() + " " + personName.getFamilyName());
            }
        }
        auditManager.storeAudit(audit);
    }

    void setRegistryResponseStatus(RetrieveDocumentSetResponseType ret)
    {
        if (ret.getRegistryResponse().getRegistryErrorList() != null) {
            ret.getRegistryResponse().setStatus(XDS_RETRIEVE_RESPONSE_STATUS_FAILURE);
        }
        else {
            ret.getRegistryResponse().setStatus(XDS_RETRIEVE_RESPONSE_STATUS_SUCCESS);
        }
    }
    
    private Facility getHomeFacility()
    {
        return facilityManager.getFacilityByFacilityNumber("VA");
    }
}
