/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package ext.domain.nhin.adapter.docretrieve;

/**
 *
 * @author VHAISBVAZQUD
 */
import java.util.logging.*;
import java.util.*;

import javax.ejb.*;
import javax.jws.*;
import javax.xml.ws.*;

import gov.hhs.fha.nhinc.adapterdocretrieve.*;
import gov.hhs.fha.nhinc.adapterpolicyengine.*;
import gov.hhs.fha.nhinc.common.eventcommon.*;
import gov.hhs.fha.nhinc.common.nhinccommonadapter.*;
import gov.hhs.fha.nhinc.nhinclib.NhincConstants;
import gov.hhs.fha.nhinc.transform.policy.*;
import ihe.iti.xds_b._2007.*;
import oasis.names.tc.ebxml_regrep.xsd.rs._3.*;
import oasis.names.tc.xacml._2_0.context.schema.os.*;

import ext.domain.nhin.adapter.facilitymanager.*;
import ext.domain.nhin.adapter.policyengine.*;
import ext.domain.nhin.adapter.utils.*;

/**
 *
 * @author David Vazquez
 */
@WebService(serviceName = "AdapterDocRetrieveSoap12",
            portName = "AdapterDocRetrievePortSoap",
            endpointInterface = "gov.hhs.fha.nhinc.adapterdocretrieve.AdapterDocRetrievePortType",
            targetNamespace = "urn:gov:hhs:fha:nhinc:adapterdocretrieve",
            wsdlLocation = "META-INF/wsdl/AdapterDocRetrieveSoap12.wsdl")
@BindingType(value = javax.xml.ws.soap.SOAPBinding.SOAP12HTTP_BINDING)
@Stateless(name = "AdapterDocRetrieve")
public class AdapterDocRetrieve implements AdapterDocRetrievePortTypeLocal
{
    static private final Logger logger = Logger.getLogger(AdapterDocRetrieve.class.getName());
    
    static private final String ERROR_XDS_REPOSITORY_ERROR = "XDSRepositoryError";
    static private final String ERROR_DESC_XDS_REPOSITORY_ERROR = "Internal Registry/Repository Error";
    static private final String ERROR_XDS_DOCUMENT_UNIQUE_ID_ERROR = "XDSDocumentUniqueIdError";
    static private final String ERROR_DESC_XDS_DOCUMENT_UNIQUE_ID_ERROR = "Document is not Available";
    
    private AdapterDocRetrievePortType docRetrieve;
    private AdapterPolicyEnginePortType policyEngine;
    private FacilityManager facilityManager;
    
    @EJB(beanInterface = AdapterDocRetrievePortTypeLocal.class, beanName = "DocRetrieve")
    public void setDocRetrieve(AdapterDocRetrievePortType docRetrieve)
    {
        this.docRetrieve = docRetrieve;
    }

    @EJB(beanInterface = AdapterPolicyEnginePortTypeLocal.class, beanName = "AdapterPolicyEngine")
    public void setPolicyEngine(AdapterPolicyEnginePortType policyEngine)
    {
        this.policyEngine = policyEngine;
    }

    @EJB(beanInterface = FacilityManagerLocal.class, beanName = "FacilityManager")
    public void setFacilityManager(FacilityManager facilityManager)
    {
        this.facilityManager = facilityManager;
    }

    public RetrieveDocumentSetResponseType respondingGatewayCrossGatewayRetrieve(RespondingGatewayCrossGatewayRetrieveRequestType respondingGatewayCrossGatewayRetrieveRequest)
    {
        logger.entering(getClass().getName(), "respondingGatewayCrossGatewayRetrieve");

        RetrieveDocumentSetResponseType ret = null;

        try {
            if (checkPolicy(respondingGatewayCrossGatewayRetrieveRequest)) {
                ret = docRetrieve.respondingGatewayCrossGatewayRetrieve(respondingGatewayCrossGatewayRetrieveRequest);
            }
            else {
                ret = createRetrieveDocumentSetResponseError(ERROR_XDS_DOCUMENT_UNIQUE_ID_ERROR, ERROR_DESC_XDS_DOCUMENT_UNIQUE_ID_ERROR);
            }
        }
        catch (Throwable t) {
            String hcid;
            String hcidName;
            if (respondingGatewayCrossGatewayRetrieveRequest.getAssertion() != null
                && respondingGatewayCrossGatewayRetrieveRequest.getAssertion().getHomeCommunity() != null) {
                hcid = respondingGatewayCrossGatewayRetrieveRequest.getAssertion().getHomeCommunity().getHomeCommunityId();
                hcidName = respondingGatewayCrossGatewayRetrieveRequest.getAssertion().getHomeCommunity().getName();
            }
            else {
                hcid = "N/A";
                hcidName = "Not Available";
            }
            logger.log(Level.WARNING, "Error processing DocRetrieve from {0} {1} - {2}", new Object[]{hcid, hcidName, t.getMessage()});
            logger.log(Level.WARNING, "Stack trace", t);
            ret = createRetrieveDocumentSetResponseError(ERROR_XDS_REPOSITORY_ERROR, ERROR_DESC_XDS_REPOSITORY_ERROR);
        }
        finally {
            logger.exiting(getClass().getName(), "respondingGatewayCrossGatewayRetrieve");
        }
        
        return ret;
    }

    private boolean checkPolicy(RespondingGatewayCrossGatewayRetrieveRequestType respondingGatewayCrossGatewayRetrieveRequest)
    {
        DocRetrieveMessageType docRetrieveMessage = new DocRetrieveMessageType();
        docRetrieveMessage.setAssertion(respondingGatewayCrossGatewayRetrieveRequest.getAssertion());
        docRetrieveMessage.setRetrieveDocumentSetRequest(respondingGatewayCrossGatewayRetrieveRequest.getRetrieveDocumentSetRequest());
        
        DocRetrieveEventType docRetrieveEvent = new gov.hhs.fha.nhinc.common.eventcommon.DocRetrieveEventType();
        docRetrieveEvent.setMessage(docRetrieveMessage);
        docRetrieveEvent.setDirection(NhincConstants.POLICYENGINE_INBOUND_DIRECTION);

        PolicyEngineTransformer policyEngineTransformer = new PolicyEngineTransformer();
        CheckPolicyRequestType checkPolicyRequest = policyEngineTransformer.transformDocRetrieveToCheckPolicy(docRetrieveEvent);

        CheckPolicyResponseType checkPolicyResponse = policyEngine.checkPolicy(checkPolicyRequest);

        return checkPolicyResponse != null
               && checkPolicyResponse.getResponse() != null
               && NullChecker.isNotNullOrEmpty(checkPolicyResponse.getResponse().getResult())
               && checkPolicyResponse.getResponse().getResult().get(0).getDecision() == DecisionType.PERMIT;
    }
    
    private RetrieveDocumentSetResponseType createRetrieveDocumentSetResponseError(String errorCode, String codeContext)
    {
        ihe.iti.xds_b._2007.ObjectFactory objFactory = new ihe.iti.xds_b._2007.ObjectFactory();
        RetrieveDocumentSetResponseType ret = objFactory.createRetrieveDocumentSetResponseType();
        ret.setRegistryResponse(createRegistryResponseError(errorCode, codeContext));
        return ret;
    }

    private RegistryResponseType createRegistryResponseError(String errorCode, String codeContext)
    {
        RegistryResponseType ret = new RegistryResponseType();
        ret.setStatus("urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:Failure");
        ret.setRegistryErrorList(createRegistryErrorList(errorCode, codeContext));
        return ret;
    }

    private RegistryErrorList createRegistryErrorList(String errorCode, String codeContext)
    {
        RegistryErrorList ret = new RegistryErrorList();
        ret.getRegistryError().add(createRegistryError(errorCode, codeContext));
        ret.setHighestSeverity("urn:oasis:names:tc:ebxml-regrep:ErrorSeverityType:Error");
        return ret;
    }

    private RegistryError createRegistryError(String errorCode, String codeContext)
    {
        RegistryError ret = new RegistryError();
        ret.setErrorCode(errorCode);
        ret.setCodeContext(codeContext);
        ret.setSeverity("urn:oasis:names:tc:ebxml-regrep:ErrorSeverityType:Error");
        ret.setLocation(getHomeFacility().getFullHomeCommunityId());
        return ret;
    }
    
    private Facility getHomeFacility()
    {
        return facilityManager.getFacilityByFacilityNumber("VA");
    }
}
