/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package ext.domain.nhin.adapter.adaptergateway.patientdiscovery;

import java.util.*;
import java.util.concurrent.*;
import java.util.logging.*;

import javax.ejb.*;
import javax.jws.*;

import oasis.names.tc.xacml._2_0.context.schema.os.*;
import org.hl7.v3.*;

import gov.hhs.fha.nhinc.adapterpolicyengine.*;
import gov.hhs.fha.nhinc.common.connectionmanagerinfo.*;
import gov.hhs.fha.nhinc.common.nhinccommon.*;
import gov.hhs.fha.nhinc.common.nhinccommonadapter.*;
import gov.hhs.fha.nhinc.nhinclib.NhincConstants;
import gov.hhs.fha.nhinc.nhinccomponentconnectionmanager.*;
import gov.hhs.fha.nhinc.transform.subdisc.*;
import gov.hhs.fha.nhinc.nhinccomponentpatientcorrelation.*;
import gov.hhs.fha.nhinc.transform.policy.*;

import ext.domain.nhin.adapter.adaptergateway.docquery.*;
import ext.domain.nhin.adapter.adaptermpi.*;
import ext.domain.nhin.adapter.connectionmanager.*;
import ext.domain.nhin.adapter.policyengine.*;
import ext.domain.nhin.adapter.facilitymanager.*;
import ext.domain.nhin.adapter.facilitymanager.Facility;
import ext.domain.nhin.adapter.mpi.*;
import ext.domain.nhin.adapter.mpi.hl7parsers.*;
import ext.domain.nhin.adapter.patientcorrelation.*;
import ext.domain.nhin.adapter.utils.*;

/**
 *
 * @author David Vazquez
 */
@WebService(serviceName = "EntityPatientDiscovery",
            portName = "EntityPatientDiscoveryPortSoap",
            endpointInterface = "gov.hhs.fha.nhinc.entitypatientdiscovery.EntityPatientDiscoveryPortType",
            targetNamespace = "urn:gov:hhs:fha:nhinc:entitypatientdiscovery",
            wsdlLocation = "META-INF/wsdl/EntityPatientDiscovery.wsdl")
@Stateless(name = "AdapterGatewayPatientDiscovery")
public class AdapterGatewayPatientDiscovery implements EntityPatientDiscoveryPortTypeLocal
{
    private class SendRequestResponse
    {
        public PRPAIN201306UV02 prpain201306UV02;
        public String remoteHomeCommunityId;
    }
    
    private class SendRequestException extends Exception
    {
        public PRPAIN201305UV02 prpain201305UV02;
        public String remoteHomeCommunityId;
    }
    
    private class SendRequestCallable implements Callable<SendRequestResponse>
    {
        private final PRPAIN201305UV02 prpain201305UV02;
        private final AssertionType assertion;
        private final String remoteHomeCommunityId;
        
        public SendRequestCallable(PRPAIN201305UV02 prpain201305UV02,
                                   AssertionType assertion,
                                   String remoteHomeCommunityId)
        {
            this.prpain201305UV02 = prpain201305UV02;
            this.assertion = assertion;
            this.remoteHomeCommunityId = remoteHomeCommunityId;
        }
        
        public SendRequestResponse call() throws Exception
        {
            return sendRequest(prpain201305UV02, assertion, remoteHomeCommunityId);
        }
    }
    
    static private final Logger logger = Logger.getLogger(AdapterGatewayPatientDiscovery.class.getName());
    private PatientCorrelationPortType adapterPatientCorrelation;
    private AdapterPolicyEnginePortType adapterPolicyEngine;
    private FacilityManager facilityManager;
    private AdapterMpiPortType adapterMpi;
    private NHINPatientDiscoverySender nhinPatientDiscoverySender;
    private ExecutorService executorService;
    private NhincComponentConnectionManagerPortType connectionManager;
    
    @EJB(beanInterface = FacilityManagerLocal.class, beanName = "FacilityManager")
    public void setFacilityManager(FacilityManager facilityManager)
    {
        this.facilityManager = facilityManager;
    }

    @EJB(beanInterface = AdapterPolicyEnginePortTypeLocal.class, beanName = "AdapterPolicyEngine")
    public void setAdapterPolicyEngine(AdapterPolicyEnginePortType adapterPolicyEngine)
    {
        this.adapterPolicyEngine = adapterPolicyEngine;
    }
    
    @EJB(beanInterface = AdapterMpiPortTypeLocal.class, beanName = "AdapterMPI")
    public void setAdapterMpi(AdapterMpiPortType adapterMpi)
    {
        this.adapterMpi = adapterMpi;
    }
    
    @EJB(beanInterface = PatientCorrelationPortTypeLocal.class, beanName = "AdapterPatientCorrelation")
    public void setAdapterPatientCorrelation(PatientCorrelationPortType adapterPatientCorrelation)
    {
        this.adapterPatientCorrelation = adapterPatientCorrelation;
    }

    @EJB(beanInterface = NHINPatientDiscoverySender.class, beanName = "NhincProxyNHINPatientDiscoverySender")
    public void setNhinPatientDiscoverySender(NHINPatientDiscoverySender nhinPatientDiscoverySender)
    {
        this.nhinPatientDiscoverySender = nhinPatientDiscoverySender;
    }

    @EJB(beanInterface = WorkManagerExecutorServiceLocal.class, beanName = "WorkManagerExecutorService")
    public void setExecutorService(ExecutorService executorService)
    {
        this.executorService = executorService;
    }

    @EJB(beanInterface = NhincComponentConnectionManagerPortTypeLocal.class, beanName = "NhincComponentConnectionManagerWS")
    public void setConnectionManager(NhincComponentConnectionManagerPortType connectionManager)
    {
        this.connectionManager = connectionManager;
    }
    
    public RespondingGatewayPRPAIN201306UV02ResponseType respondingGatewayPRPAIN201305UV02(RespondingGatewayPRPAIN201305UV02RequestType respondingGatewayPRPAIN201305UV02Request)
    {
        logger.entering(getClass().getName(), "respondingGatewayPRPAIN201305UV02");

        RespondingGatewayPRPAIN201306UV02ResponseType ret = new RespondingGatewayPRPAIN201306UV02ResponseType();
        ExecutorCompletionService<SendRequestResponse> completionService = new ExecutorCompletionService<SendRequestResponse>(executorService);
        
        try {
            int numSubmitted = 0;
            II localPatientId = getLocalPatientId(respondingGatewayPRPAIN201305UV02Request.getPRPAIN201305UV02());
            AssertionType assertion = respondingGatewayPRPAIN201305UV02Request.getAssertion();
            for (ConnectionInfoType connectionInfo : getAllConnectionInfos(respondingGatewayPRPAIN201305UV02Request.getNhinTargetCommunities()).getConnectionInfo()) {
                String remoteHomeCommunityId = connectionInfo.getHomeCommunity().getHomeCommunityId();
                if (!remoteHomeCommunityId.equals(getHomeCommunityId())) {
                    PRPAIN201305UV02 prpain201305UV02 = createPRPAIN201305UV02(respondingGatewayPRPAIN201305UV02Request.getPRPAIN201305UV02(), remoteHomeCommunityId);
                    if (checkPolicy(prpain201305UV02, respondingGatewayPRPAIN201305UV02Request.getAssertion(), remoteHomeCommunityId)) {
                        SendRequestCallable callable = new SendRequestCallable(prpain201305UV02, respondingGatewayPRPAIN201305UV02Request.getAssertion(), remoteHomeCommunityId);
                        completionService.submit(callable);
                        ++numSubmitted;
                    }
                    else {
                        addResultToResponse(ret, createErrorResponse(prpain201305UV02, remoteHomeCommunityId, remoteHomeCommunityId));
                    }
                }
            }
            
            for (int i = 0;  i < numSubmitted;  ++i) {
                try {
                    SendRequestResponse response = completionService.take().get();
                    processResult(response.prpain201306UV02, localPatientId, response.remoteHomeCommunityId, assertion);
                    addResultToResponse(ret, response.prpain201306UV02);
                }
                catch (ExecutionException ee) {
                    SendRequestException sre = (SendRequestException)ee.getCause();
                    addResultToResponse(ret, createErrorResponse(sre.prpain201305UV02, sre.remoteHomeCommunityId, sre.remoteHomeCommunityId));
                    logger.log(Level.WARNING, "Error sending PatientDiscovery to {0} - {1}", new Object[]{sre.remoteHomeCommunityId, sre.getCause().getMessage()});
                    logger.log(Level.WARNING, "Stack trace", sre.getCause());
                }
                catch (InterruptedException ie) {
                    break;
                }
            }
        }
        finally {
            logger.exiting(getClass().getName(), "respondingGatewayPRPAIN201305UV02");
        }

        return ret;
    }

    private ConnectionInfosType getAllConnectionInfos(NhinTargetCommunitiesType nhinTargetCommunities)
    {
        ConnectionInfosType ret;
        
        if (nhinTargetCommunities != null) {
            ret = new ConnectionInfosType();
            
            for (NhinTargetCommunityType nhinTargetCommunity : nhinTargetCommunities.getNhinTargetCommunity()) {
                ConnectionInfoType connectionInfo = new ConnectionInfoType();
                connectionInfo.setHomeCommunity(nhinTargetCommunity.getHomeCommunity());
                ret.getConnectionInfo().add(connectionInfo);
            }
        }
        else {
            GetAllConnectionInfoSetByServiceNameRequestType request = new GetAllConnectionInfoSetByServiceNameRequestType();
            request.setServiceName(NhincConstants.PATIENT_DISCOVERY_SERVICE_NAME);
            ret = connectionManager.getAllConnectionInfoSetByServiceName(request);
        }
        
        return ret;
    }

    private boolean checkPolicy(PRPAIN201305UV02 prpain201305UV02, AssertionType assertion, String remoteHomeCommunityId)
    {
        HomeCommunityType homeCommunity = new HomeCommunityType();
        homeCommunity.setHomeCommunityId(remoteHomeCommunityId);
        
        NhinTargetCommunityType nhinTargetCommunity = new NhinTargetCommunityType();
        nhinTargetCommunity.setHomeCommunity(homeCommunity);;
        
        NhinTargetCommunitiesType nhinTargetCommunities = new NhinTargetCommunitiesType();
        nhinTargetCommunities.getNhinTargetCommunity().add(nhinTargetCommunity);
        
        RespondingGatewayPRPAIN201305UV02RequestType respondingGatewayPRPAIN201305UV02Request = new RespondingGatewayPRPAIN201305UV02RequestType();
        respondingGatewayPRPAIN201305UV02Request.setPRPAIN201305UV02(prpain201305UV02);
        respondingGatewayPRPAIN201305UV02Request.setAssertion(assertion);
        respondingGatewayPRPAIN201305UV02Request.setNhinTargetCommunities(nhinTargetCommunities);        
        
        PatientDiscoveryPolicyTransformHelper patientDiscoveryPolicyTransformHelper = new PatientDiscoveryPolicyTransformHelper();
        CheckPolicyRequestType checkPolicyRequest = patientDiscoveryPolicyTransformHelper.transformPatientDiscoveryEntityToCheckPolicy(respondingGatewayPRPAIN201305UV02Request);
        
        CheckPolicyResponseType checkPolicyResponse = adapterPolicyEngine.checkPolicy(checkPolicyRequest);
        
        return checkPolicyResponse != null
               && checkPolicyResponse.getResponse() != null
               && NullChecker.isNotNullOrEmpty(checkPolicyResponse.getResponse().getResult())
               && checkPolicyResponse.getResponse().getResult().get(0).getDecision() == DecisionType.PERMIT;
    }

    private II getLocalPatientId(PRPAIN201305UV02 request)
    {
        II ret = null;
        List<II> patientIds = request.getControlActProcess().getQueryByParameter().getValue().getParameterList().getLivingSubjectId().get(0).getValue();
        String aa = getAAOID(request);
        for (II patientId : patientIds) {
            if (aa.equals(patientId.getRoot())) {
                ret = patientId;
                break;
            }
        }
        return ret;
    }
    
    private String getAAOID(PRPAIN201305UV02 request)
    {
        String oid = null;

        if (request != null
            && request.getControlActProcess() != null
            && !NullChecker.isNullOrEmpty(request.getControlActProcess().getAuthorOrPerformer())
            && request.getControlActProcess().getAuthorOrPerformer().get(0) != null
            && request.getControlActProcess().getAuthorOrPerformer().get(0).getAssignedDevice() != null
            && request.getControlActProcess().getAuthorOrPerformer().get(0).getAssignedDevice().getValue() != null
            && !NullChecker.isNullOrEmpty(request.getControlActProcess().getAuthorOrPerformer().get(0).getAssignedDevice().getValue().getId())
            && request.getControlActProcess().getAuthorOrPerformer().get(0).getAssignedDevice().getValue().getId().get(0) != null
            && !NullChecker.isNullOrEmpty(request.getControlActProcess().getAuthorOrPerformer().get(0).getAssignedDevice().getValue().getId().get(0).getRoot())) {
            oid = request.getControlActProcess().getAuthorOrPerformer().get(0).getAssignedDevice().getValue().getId().get(0).getRoot();
        }

        return oid;
    }
    
    private SendRequestResponse sendRequest(PRPAIN201305UV02 prpain201305UV02, AssertionType assertion, String remoteHomeCommunityId)
        throws SendRequestException
    {
        SendRequestResponse ret = new SendRequestResponse();
        
        try {
            ret.prpain201306UV02 = nhinPatientDiscoverySender.sendRequest(prpain201305UV02, assertion, remoteHomeCommunityId);
            ret.remoteHomeCommunityId = remoteHomeCommunityId;
            return ret;
        }
        catch (Exception e) {
            SendRequestException sre = new SendRequestException();
            sre.prpain201305UV02 = prpain201305UV02;
            sre.remoteHomeCommunityId = remoteHomeCommunityId;
            sre.initCause(e);
            throw sre;
        }
    }

    private PRPAIN201305UV02 createPRPAIN201305UV02(PRPAIN201305UV02 fromRequest, String homeCommunityId)
    {
        PRPAIN201305UV02 ret = new PRPAIN201305UV02();
        ret.setAcceptAckCode(fromRequest.getAcceptAckCode());
        ret.setControlActProcess(fromRequest.getControlActProcess());
        ret.setCreationTime(fromRequest.getCreationTime());
        ret.setITSVersion(fromRequest.getITSVersion());
        ret.setId(fromRequest.getId());
        ret.setInteractionId(fromRequest.getInteractionId());
        ret.setProcessingCode(fromRequest.getProcessingCode());
        ret.setProcessingModeCode(fromRequest.getProcessingModeCode());
        ret.setSecurityText(fromRequest.getSecurityText());
        ret.setSender(fromRequest.getSender());
        ret.setSequenceNumber(fromRequest.getSequenceNumber());
        ret.setTypeId(fromRequest.getTypeId());
        ret.setVersionCode(fromRequest.getVersionCode());
        
        if (NullChecker.isNotNullOrEmpty(fromRequest.getAttachmentText())) {
            ret.getAttachmentText().addAll(fromRequest.getAttachmentText());
        }
        
        if (NullChecker.isNotNullOrEmpty(fromRequest.getAttentionLine())) {
            ret.getAttentionLine().addAll(fromRequest.getAttentionLine());
        }
        
        if (NullChecker.isNotNullOrEmpty(fromRequest.getNullFlavor())) {
            ret.getNullFlavor().addAll(fromRequest.getNullFlavor());
        }
        
        if (NullChecker.isNotNullOrEmpty(fromRequest.getProfileId())) {
            ret.getProfileId().addAll(fromRequest.getProfileId());
        }
        
        if (NullChecker.isNotNullOrEmpty(fromRequest.getRealmCode())) {
            ret.getRealmCode().addAll(fromRequest.getRealmCode());
        }
        
        ret.getReceiver().add(createNewReceiver(homeCommunityId));
        
        if (NullChecker.isNotNullOrEmpty(fromRequest.getRespondTo())) {
            ret.getRespondTo().addAll(fromRequest.getRespondTo());
        }
        
        if (NullChecker.isNotNullOrEmpty(fromRequest.getTemplateId())) {
            ret.getTemplateId().addAll(fromRequest.getTemplateId());
        }
        
        return ret;
    }

    private MCCIMT000100UV01Receiver createNewReceiver(String homeCommunityId)
    {
        return HL7ReceiverTransforms.createMCCIMT000100UV01Receiver(homeCommunityId);
    }

    private void processResult(PRPAIN201306UV02 result, II localPatientId, String homeCommunityId, AssertionType assertion)
    {
        if (result.getControlActProcess() != null
            && !NullChecker.isNullOrEmpty(result.getControlActProcess().getSubject())) {
            for (Iterator<PRPAIN201306UV02MFMIMT700711UV01Subject1> it = result.getControlActProcess().getSubject().iterator();
                 it.hasNext();) {
                PRPAIN201306UV02MFMIMT700711UV01Subject1 subject = it.next();
                if (!(subject.getRegistrationEvent() != null
                      && subject.getRegistrationEvent().getSubject1() != null
                      && subject.getRegistrationEvent().getSubject1().getPatient() != null
                      && processPatient(subject.getRegistrationEvent().getSubject1().getPatient(), localPatientId, homeCommunityId, assertion))) {
                    it.remove();
                }
            }
        }
    }

    private boolean processPatient(PRPAMT201310UV02Patient prpamt201310UV02Patient, II localPatientId, String remoteHomeCommunityId, AssertionType assertion)
    {
        boolean ret = false;
        if (findMatch(prpamt201310UV02Patient, localPatientId, remoteHomeCommunityId, assertion)) {
            ret = true;
            storeCorrelation(prpamt201310UV02Patient, localPatientId, remoteHomeCommunityId, assertion);
        }
        return ret;
    }

    private boolean findMatch(PRPAMT201310UV02Patient prpamt201310UV02Patient, II localPatientId, String remoteHomeCommunityId, AssertionType assertion)
    {
        boolean ret;
        PRPAMT201301UV02Patient prpamt201301UV02Patient = HL7PatientTransforms.createPRPAMT201301UVPatient(prpamt201310UV02Patient);
        String localHomeCommunityId = getHomeCommunityId();
        PRPAIN201305UV02 prpain201305UV02 = HL7PRPA201305Transforms.createPRPA201305(prpamt201301UV02Patient, remoteHomeCommunityId, localHomeCommunityId, localHomeCommunityId);
        RespondingGatewayPRPAIN201305UV02RequestType request = new RespondingGatewayPRPAIN201305UV02RequestType();
        request.setPRPAIN201305UV02(prpain201305UV02);
        request.setAssertion(assertion);
        PRPAIN201306UV02 result = adapterMpi.findCandidates(request);
        if (result == null
            || result.getControlActProcess() == null
            || NullChecker.isNullOrEmpty(result.getControlActProcess().getSubject())
            || result.getControlActProcess().getSubject().get(0).getRegistrationEvent() == null
            || result.getControlActProcess().getSubject().get(0).getRegistrationEvent().getSubject1() == null
            || result.getControlActProcess().getSubject().get(0).getRegistrationEvent().getSubject1().getPatient() == null
            || result.getControlActProcess().getSubject().get(0).getRegistrationEvent().getSubject1().getPatient().getId() == null
            || !doIDsMatch(localPatientId, result.getControlActProcess().getSubject().get(0).getRegistrationEvent().getSubject1().getPatient().getId())) {
            ret = false;
        }
        else {
            ret = true;
        }
        return ret;
    }

    private String getHomeCommunityId()
    {
        String ret = null;
        Facility facility = facilityManager.getFacilityByFacilityNumber("VA");
        if (facility != null) {
            ret = facility.getHomeCommunityId();
        }
        return ret;
    }

    private boolean doIDsMatch(II localPatientId, List<II> ids)
    {
        boolean ret = false;

        for (II id : ids) {
            if (localPatientId.getRoot().equals(id.getRoot())
                && localPatientId.getExtension().equals(id.getExtension())) {
                ret = true;
                break;
            }
        }

        return ret;
    }

    private void storeCorrelation(PRPAMT201310UV02Patient prpamt201310UV02Patient, II localPatientId, String remoteHomeCommunityId, AssertionType assertion)
    {
        PRPAMT201301UV02Patient prpamt201301UV02Patient = HL7PatientTransforms.createPRPAMT201301UVPatient(prpamt201310UV02Patient);
        String localHomeCommunityId = getHomeCommunityId();
        PRPAIN201301UV02 prpain201301UV02 = HL7PRPA201301Transforms.createPRPA201301(prpamt201301UV02Patient, localHomeCommunityId, remoteHomeCommunityId, localHomeCommunityId);
        prpain201301UV02.getControlActProcess().getSubject().get(0).getRegistrationEvent().getSubject1().getPatient().getId().add(localPatientId);
        AddPatientCorrelationRequestType request = new AddPatientCorrelationRequestType();
        request.setPRPAIN201301UV02(prpain201301UV02);
        request.setAssertion(assertion);
        adapterPatientCorrelation.addPatientCorrelation(request);
    }

    private void addResultToResponse(RespondingGatewayPRPAIN201306UV02ResponseType response, PRPAIN201306UV02 result)
    {
        CommunityPRPAIN201306UV02ResponseType communityResponse = new CommunityPRPAIN201306UV02ResponseType();
        communityResponse.setPRPAIN201306UV02(result);
        response.getCommunityResponse().add(communityResponse);
    }
    
    private PRPAIN201306UV02 createErrorResponse(PRPAIN201305UV02 prpain201305UV02, String homeCommunityId, String assigningAuthorityId)
    {
        PRPAIN201306UV02 ret = HL7DbParser201306.BuildMessageFromMpiPatients(null, prpain201305UV02, homeCommunityId, assigningAuthorityId);
        ret.getControlActProcess().getQueryAck().getQueryResponseCode().setCode("QE");
        return ret;
    }
}
