package ext.domain.nhin.adapter.adaptergateway.docretrieve;

/**
 *
 * @author vhaisbwelchr
 */
import java.net.URL;
import java.net.*;
import java.util.logging.*;

import javax.ejb.*;
import javax.xml.namespace.*;

import gov.hhs.fha.nhinc.common.nhinccommon.*;

import gov.hhs.fha.nhinc.nhincproxydocretrieve.NhincProxyDocRetrieve;
import gov.hhs.fha.nhinc.nhincproxydocretrieve.NhincProxyDocRetrievePortType;
import ext.domain.nhin.adapter.propertylookup.*;
import ihe.iti.xds_b._2007.RetrieveDocumentSetRequestType;
import ihe.iti.xds_b._2007.RetrieveDocumentSetResponseType;

/**
 *
 * @author David Vazquez
 */
@Stateless(name = "NhincProxyNHINDocRetrieveRequestSender")
public class NhincProxyNHINDocRetrieveRequestSender implements NHINDocRetrieveRequestSender
{
    static private final Logger logger = Logger.getLogger(NhincProxyNHINDocRetrieveRequestSender.class.getName());

    private NhincProxyDocRetrieve docRetrieve;
    private PropertyLookup propertyLookup;
    
    @EJB(beanInterface = PropertyLookupLocal.class, beanName = "PropertyLookup")
    public void setPropertyLookup(PropertyLookup propertyLookup)
    {
        this.propertyLookup = propertyLookup;
    }
   
    public RetrieveDocumentSetResponseType sendRequest(RetrieveDocumentSetRequestType docRetrieveRequest, AssertionType assertion, String remoteHomeCommunityId)
        throws Exception
    {
        gov.hhs.fha.nhinc.common.nhinccommonproxy.RespondingGatewayCrossGatewayRetrieveRequestType request =
            new gov.hhs.fha.nhinc.common.nhinccommonproxy.RespondingGatewayCrossGatewayRetrieveRequestType();
        request.setRetrieveDocumentSetRequest(docRetrieveRequest);
        request.setAssertion(assertion);
        request.setNhinTargetSystem(createNhinTarget(remoteHomeCommunityId));
        return getDocRetrievePort().respondingGatewayCrossGatewayRetrieve(request);
    }

    private NhinTargetSystemType createNhinTarget(String homeCommunityId)
    {
        HomeCommunityType homeCommunity = new HomeCommunityType();
        homeCommunity.setHomeCommunityId(homeCommunityId);
        NhinTargetSystemType ret = new NhinTargetSystemType();
        ret.setHomeCommunity(homeCommunity);
        return ret;
    }

    private NhincProxyDocRetrievePortType getDocRetrievePort()
        throws MalformedURLException
    {
        if (docRetrieve == null) {
            docRetrieve = new NhincProxyDocRetrieve(new URL(propertyLookup.getProperty("DocRetrieveProxyWSDL")),
                                                    new QName("urn:gov:hhs:fha:nhinc:nhincproxydocretrieve", "NhincProxyDocRetrieve"));
        }

        return docRetrieve.getNhincProxyDocRetrievePortSoap();
    }
}
