/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package ext.domain.nhin.adapter.adaptergateway.docquery;

import java.net.*;
import java.text.*;
import java.util.*;
import java.util.logging.*;

import javax.ejb.*;
import javax.jws.*;
import javax.xml.bind.*;

import gov.hhs.fha.nhinc.adapterpolicyengine.*;
import gov.hhs.fha.nhinc.common.nhinccommon.*;
import gov.hhs.fha.nhinc.common.nhinccommon.PersonNameType;
import gov.hhs.fha.nhinc.common.nhinccommon.UserType;
import gov.hhs.fha.nhinc.common.nhinccommonadapter.CheckPolicyRequestType;
import gov.hhs.fha.nhinc.common.nhinccommonadapter.CheckPolicyResponseType;
import gov.hhs.fha.nhinc.common.nhinccommonentity.*;
import gov.hhs.fha.nhinc.common.nhinccommonentity.RespondingGatewayCrossGatewayQueryRequestType;
import gov.hhs.fha.nhinc.entitydocquery.*;
import ihe.iti.xds_b._2007.RetrieveDocumentSetRequestType.*;
import oasis.names.tc.ebxml_regrep.xsd.query._3.*;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.*;
import oasis.names.tc.ebxml_regrep.xsd.rs._3.*;
import oasis.names.tc.xacml._2_0.context.schema.os.*;

import ext.domain.nhin.adapter.datamanager.*;
import ext.domain.nhin.adapter.datamanager.ejb.*;
import ext.domain.nhin.adapter.documentrepository.*;
import ext.domain.nhin.adapter.facilitymanager.*;
import ext.domain.nhin.adapter.policyengine.*;
import ext.domain.nhin.adapter.propertylookup.*;
import ext.domain.nhin.adapter.utils.*;
import java.math.BigInteger;

/**
 *
 * @author spawaradmin
 */
@WebService(serviceName = "EntityDocQuery",
            portName = "EntityDocQueryPortSoap11",
            endpointInterface = "gov.hhs.fha.nhinc.entitydocquery.EntityDocQueryPortType",
            targetNamespace = "urn:gov:hhs:fha:nhinc:entitydocquery",
            wsdlLocation = "META-INF/wsdl/EntityDocQuery.wsdl")
@Stateless
public class EntityDocQueryBean implements EntityDocQueryPortType
{
    static private final Logger logger = Logger.getLogger(EntityDocQueryBean.class.getName());

    static private final String PARAM_PATIENT_ID = "patientId";
    static private final String PARAM_CLASS_CODES = "classCodes";
    static private final String PARAM_CLASS_CODE_SCHEME = "classCodeScheme";
    static private final String PARAM_CREATION_TIME_FROM = "creationTimeFrom";
    static private final String PARAM_CREATION_TIME_TO = "creationTimeTo";
    static private final String PARAM_SERVICE_START_TIME_FROM = "serviceStartTimeFrom";
    static private final String PARAM_SERVICE_START_TIME_TO = "serviceStartTimeTo";
    static private final String PARAM_SERVICE_STOP_TIME_FROM = "serviceStopTimeFrom";
    static private final String PARAM_SERVICE_STOP_TIME_TO = "serviceStopTimeTo";
    static private final String PARAM_STATUS_CODES = "statusCodes";
    static private final String PARAM_DOCUMENT_IDS = "documentIds";
    static private final String PARAM_REPOSITORY_ID = "repositoryId";
    private static final String EBXML_DOCENTRY_PATIENT_ID = "$XDSDocumentEntryPatientId";
    private static final String EBXML_DOCENTRY_CLASS_CODE = "$XDSDocumentEntryClassCode";
    private static final String EBXML_DOCENTRY_CLASS_CODE_SCHEME = "$XDSDocumentEntryClassCodeScheme";
    private static final String EBXML_DOCENTRY_CREATION_TIME_FROM = "$XDSDocumentEntryCreationTimeFrom";
    private static final String EBXML_DOCENTRY_CREATION_TIME_TO = "$XDSDocumentEntryCreationTimeTo";
    private static final String EBXML_DOCENTRY_SERVICE_START_TIME_FROM = "$XDSDocumentEntryServiceStartTimeFrom";
    private static final String EBXML_DOCENTRY_SERVICE_START_TIME_TO = "$XDSDocumentEntryServiceStartTimeTo";
    private static final String EBXML_DOCENTRY_SERVICE_STOP_TIME_FROM = "$XDSDocumentEntryServiceStopTimeFrom";
    private static final String EBXML_DOCENTRY_SERVICE_STOP_TIME_TO = "$XDSDocumentEntryServiceStopTimeTo";
    private static final String EBXML_DOCENTRY_STATUS = "$XDSDocumentEntryStatus";
    private static final String EBXML_DOCENTRY_FORMAT_CODE = "$XDSDocumentEntryFormatCode";

    // We need to be able to do a search using AdhocQueryRequest parameters, but
    // XDS.b does not have a search parameter slot name defined for repository ID
    // and document ID.  So we had to create our own custom ones.
    //----------------------------------------------------------------------------
    private static final String NHINC_CUSTOM_REPOSITORY_ID = "$NHINCRepositoryId";
    private static final String NHINC_CUSTOM_DOCUMENT_ID = "$NHINCDocumentId";
    private static final String EBXML_RESPONSE_REPOSITORY_UNIQUE_ID_SLOTNAME = "repositoryUniqueId";
    private static final String EBXML_RESPONSE_DOCID_IDENTIFICATION_SCHEME = "urn:uuid:2e82c1f6-a085-4c72-9da3-8640a32e42ab";
    private static final String EBXML_RESPONSE_DOCID_NAME = "XDSDocumentEntry.uniqueId";
    private static final String EBXML_RESPONSE_PATIENTID_IDENTIFICATION_SCHEME = "urn:uuid:58a6f841-87b3-4a3e-92fd-a8ffeff98427";
    private static final String EBXML_RESPONSE_PATIENTID_NAME = "XDSDocumentEntry.patientId";
    private static final String EBXML_RESPONSE_AUTHOR_CLASS_SCHEME = "urn:uuid:93606bcf-9494-43ec-9b4e-a7748d1a838d";
    private static final String EBXML_RESPONSE_AUTHOR_PERSON_SLOTNAME = "authorPerson";
    private static final String EBXML_RESPONSE_AUTHOR_INSTITUTION_SLOTNAME = "authorInstitution";
    private static final String EBXML_RESPONSE_AUTHOR_ROLE_SLOTNAME = "authorRole";
    private static final String EBXML_RESPONSE_AUTHOR_SPECIALTY_SLOTNAME = "authorSpecialty";
    private static final String EBXML_RESPONSE_CLASSCODE_CLASS_SCHEME = "urn:uuid:41a5887f-8865-4c09-adf7-e362475b143a";
    private static final String EBXML_RESPONSE_CONFIDENTIALITYCODE_CLASS_SCHEME = "urn:uuid:f4f85eac-e6cb-4883-b524-f2705394840f";
    private static final String EBXML_RESPONSE_EVENTCODE_CLASS_SCHEME = "urn:uuid:2c6b8cb7-8b2a-4051-b291-b1ae6a575ef4";
    private static final String EBXML_RESPONSE_FORMATCODE_CLASS_SCHEME = "urn:uuid:a09d5840-386c-46f2-b5ad-9c3699a4309d";
    private static final String EBXML_RESPONSE_HEALTHCAREFACILITYTYPE_CLASS_SCHEME = "urn:uuid:f33fb8ac-18af-42cc-ae0e-ed0b0bdb91e1";
    private static final String EBXML_RESPONSE_PRACTICESETTING_CLASS_SCHEME = "urn:uuid:cccf5598-8b07-4b77-a05e-ae952c785ead";
    private static final String EBXML_RESPONSE_TYPECODE_CLASS_SCHEME = "urn:uuid:f0306f51-975f-434e-a61c-c59651d33983";
    private static final String EBXML_RESPONSE_CODE_CODESCHEME_SLOTNAME = "codingScheme";
    private static final String EBXML_RESPONSE_CREATIONTIME_SLOTNAME = "creationTime";
    private static final String EBXML_RESPONSE_HASH_SLOTNAME = "hash";
    private static final String EBXML_RESPONSE_INTENDEDRECIPIENTS_SLOTNAME = "intendedRecipient";
    private static final String EBXML_RESPONSE_LANGUAGECODE_SLOTNAME = "languageCode";
    private static final String EBXML_RESPONSE_LEGALAUTHENTICATOR_SLOTNAME = "legalAuthenticator";
    private static final String EBXML_RESPONSE_SERVICESTARTTIME_SLOTNAME = "serviceStartTime";
    private static final String EBXML_RESPONSE_SERVICESTOPTIME_SLOTNAME = "serviceStopTime";
    private static final String EBXML_RESPONSE_SIZE_SLOTNAME = "size";
    private static final String EBXML_RESPONSE_SOURCEPATIENTID_SLOTNAME = "sourcePatientId";
    private static final String EBXML_RESPONSE_SOURCEPATIENTINFO_SLOTNAME = "sourcePatientInfo";
    private static final String EBXML_RESPONSE_URI_SLOTNAME = "URI";
    private static final int EBXML_RESPONSE_URI_LINE_LENGTH = 128;
    private static final String XDS_QUERY_RESPONSE_STATUS_SUCCESS = "urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:Success";
    private static final String XDS_QUERY_RESPONSE_STATUS_FAILURE = "urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:Failure";
    private static final String XDS_QUERY_RESPONSE_OPTION_RETURN_TYPE_OBJECT_REF = "ObjectRef";
    private static final String XDS_QUERY_RESPONSE_OPTION_RETURN_TYPE_LEAF_CLASS = "LeafClass";
    private static final String XDS_QUERY_RESPONSE_EXTRINSIC_OBJCECT_OBJECT_TYPE = "urn:uuid:7edca82f-054d-47f2-a032-9b2a5b5186c1";
    private static final String DATE_FORMAT_FULL = "yyyyMMddhhmmssZ";
    private static final String DATE_FORMAT_CREATION = DATE_FORMAT_FULL;
    private static final String DATE_FORMAT_SERVICE = "yyyyMMdd";
    private static final String REPOSITORY_UNIQUE_ID = "1";

    // Properties file keys
    private static final String PROPERTY_FILE_NAME_GATEWAY = "gateway";
    private static final String PROPERTY_FILE_KEY_HOME_COMMUNITY = "localHomeCommunityId";

    private PropertyLookup propertyLookup;
    private FacilityManager facilityManager;
    private AdapterPolicyEnginePortType adapterPolicyEngine;
    private DocumentRepository documentRepository;
    private DataManager dataManager;
    private EntityDocQueryPortType entityDocQuery;
    
    @EJB(beanInterface = PropertyLookupLocal.class, beanName = "PropertyLookup")
    public void setPropertyLookup(PropertyLookup propertyLookup)
    {
        this.propertyLookup = propertyLookup;
    }

    @EJB(beanInterface = FacilityManagerLocal.class, beanName = "FacilityManager")
    public void setFacilityManager(FacilityManager facilityManager)
    {
        this.facilityManager = facilityManager;
    }

    @EJB(beanInterface = DocumentRepositoryLocal.class, beanName = "DocumentRepository")
    public void setDocumentRepository(DocumentRepository documentRepository)
    {
        this.documentRepository = documentRepository;
    }

    @EJB(beanInterface = AdapterPolicyEnginePortTypeLocal.class, beanName = "AdapterPolicyEngine")
    public void setAdapterPolicyEngine(AdapterPolicyEnginePortType adapterPolicyEngine)
    {
        this.adapterPolicyEngine = adapterPolicyEngine;
    }
    
    @EJB(beanInterface = EntityDocQueryPortTypeLocal.class, beanName = "EntityDocQueryOrch")
    public void setEntityDocQuery(EntityDocQueryPortType entityDocQuery)
    {
        this.entityDocQuery = entityDocQuery;
    }

    @EJB(beanInterface = DataManagerLocal.class, beanName = "DataManager")
    public void setDataManager(DataManager dataManager)
    {
        this.dataManager = dataManager;
    }
    
    public AdhocQueryResponse respondingGatewayCrossGatewayQuery(RespondingGatewayCrossGatewayQueryRequestType respondingGatewayCrossGatewayQueryRequest)
    {
        logger.entering(getClass().getName(), "respondingGatewayCrossGatewayQuery");

        AdhocQueryResponse ret;
        AdhocQueryRequest body = respondingGatewayCrossGatewayQueryRequest.getAdhocQueryRequest();
        AssertionType assertion = respondingGatewayCrossGatewayQueryRequest.getAssertion();

        try {
            if (checkPolicy(assertion)) {
                gov.hhs.fha.nhinc.common.nhinccommonentity.ObjectFactory objFactory = new gov.hhs.fha.nhinc.common.nhinccommonentity.ObjectFactory();
                RespondingGatewayCrossGatewayQueryRequestType request = objFactory.createRespondingGatewayCrossGatewayQueryRequestType();
                Map<String, List<String>> slotMap = getMapFromSlots(body.getAdhocQuery().getSlot());
                String patientId = slotMap.get(EBXML_DOCENTRY_PATIENT_ID).get(0);
                request.setAdhocQueryRequest(createAdhocQueryRequest(slotMap));
                request.setAssertion(createAssertion(assertion, patientId));

                AdhocQueryResponse result = entityDocQuery.respondingGatewayCrossGatewayQuery(request);

                ret = createAdhocQueryResponse(body, result, patientId);
            }
            else {
                ret = createAdhocQueryResponseError(body);
            }
        }
        catch (Throwable t) {
            logger.throwing(getClass().getName(), "respondingGatewayCrossGatewayQuery", t);
            ret = createAdhocQueryResponseError(body);
        }
        finally {
            logger.exiting(getClass().getName(), "respondingGatewayCrossGatewayQuery");
        }

        return ret;
    }

    private AdhocQueryRequest createAdhocQueryRequest(Map<String, List<String>> params)
    {
        AdhocQueryRequest ret = new AdhocQueryRequest();
        ret.setFederated(false);
        ret.setStartIndex(BigInteger.valueOf(0));
        ret.setMaxResults(BigInteger.valueOf(-1));
        ret.setAdhocQuery(createAdhocQuery(params));
        ret.setResponseOption(createResponseOption());
        return ret;
    }

    private AdhocQueryType createAdhocQuery(Map<String, List<String>> params)
    {
        AdhocQueryType ret = new AdhocQueryType();
        ret.setHome("urn:oid:" + propertyLookup.getProperty("HomeCommunityId"));
        ret.setId("urn:uuid:14d4debf-8f97-4251-9a74-a90016b0af0d");
        ret.getSlot().addAll(createSlots(params));
        return ret;
    }

    private List<SlotType1> createSlots(Map<String, List<String>> params)
    {
        ArrayList<SlotType1> ret = new ArrayList<SlotType1>();

        String patientId = params.get(EBXML_DOCENTRY_PATIENT_ID).get(0);
        SlotType1 xdsEntryPatientId = new SlotType1();
        xdsEntryPatientId.setName(EBXML_DOCENTRY_PATIENT_ID);
        xdsEntryPatientId.setValueList(createValueList("'" + patientId + "'"));
        ret.add(xdsEntryPatientId);

        List<String> classCodes = params.get(EBXML_DOCENTRY_CLASS_CODE);
        SlotType1 xdsEntryClassCode = new SlotType1();
        xdsEntryClassCode.setName(EBXML_DOCENTRY_CLASS_CODE);
        xdsEntryClassCode.setValueList(createValueList(qualifyClassCodes(classCodes)));
        ret.add(xdsEntryClassCode);

        if (params.get(EBXML_DOCENTRY_SERVICE_START_TIME_FROM) != null) {
            String startTime = params.get(EBXML_DOCENTRY_SERVICE_START_TIME_FROM).get(0);
            SlotType1 xdsEntryServiceStartTimeFrom = new SlotType1();
            xdsEntryServiceStartTimeFrom.setName(EBXML_DOCENTRY_SERVICE_START_TIME_FROM);
            xdsEntryServiceStartTimeFrom.setValueList(createValueList(startTime));
            ret.add(xdsEntryServiceStartTimeFrom);
        }

        if (params.get(EBXML_DOCENTRY_SERVICE_START_TIME_TO) != null) {
            String endTime = params.get(EBXML_DOCENTRY_SERVICE_START_TIME_TO).get(0);
            SlotType1 xdsEntryServiceStopTimeTo = new SlotType1();
            xdsEntryServiceStopTimeTo.setName(EBXML_DOCENTRY_SERVICE_START_TIME_TO);
            xdsEntryServiceStopTimeTo.setValueList(createValueList(endTime));
            ret.add(xdsEntryServiceStopTimeTo);
        }

        if (params.get(EBXML_DOCENTRY_SERVICE_STOP_TIME_FROM) != null) {
            String startTime = params.get(EBXML_DOCENTRY_SERVICE_STOP_TIME_FROM).get(0);
            SlotType1 xdsEntryServiceStartTimeFrom = new SlotType1();
            xdsEntryServiceStartTimeFrom.setName(EBXML_DOCENTRY_SERVICE_STOP_TIME_FROM);
            xdsEntryServiceStartTimeFrom.setValueList(createValueList(startTime));
            ret.add(xdsEntryServiceStartTimeFrom);
        }
        
        if (params.get(EBXML_DOCENTRY_SERVICE_STOP_TIME_TO) != null) {
            String endTime = params.get(EBXML_DOCENTRY_SERVICE_STOP_TIME_TO).get(0);
            SlotType1 xdsEntryServiceStopTimeTo = new SlotType1();
            xdsEntryServiceStopTimeTo.setName(EBXML_DOCENTRY_SERVICE_STOP_TIME_TO);
            xdsEntryServiceStopTimeTo.setValueList(createValueList(endTime));
            ret.add(xdsEntryServiceStopTimeTo);
        }
        
        if (params.get(EBXML_DOCENTRY_FORMAT_CODE) != null) {
            List<String> formatCode = params.get(EBXML_DOCENTRY_FORMAT_CODE);
            SlotType1 xdsEntryFormatCode = new SlotType1();
            xdsEntryFormatCode.setName(EBXML_DOCENTRY_FORMAT_CODE);
            xdsEntryFormatCode.setValueList(createValueList(qualifyFormatCodes(formatCode)));
            ret.add(xdsEntryFormatCode);
        }
        
        SlotType1 xdsDocEntryStatus = new SlotType1();
        xdsDocEntryStatus.setName(EBXML_DOCENTRY_STATUS);
        xdsDocEntryStatus.setValueList(createValueList("('urn:oasis:names:tc:ebxml-regrep:StatusType:Approved','urn:ihe:iti:2010:StatusType:DeferredCreation')"));
        ret.add(xdsDocEntryStatus);

        return ret;
    }

    private ValueListType createValueList(String fromString)
    {
        ValueListType ret = new ValueListType();
        ret.getValue().add(fromString);
        return ret;
    }

    private ValueListType createValueList(List<String> fromStrings)
    {
        ValueListType ret = new ValueListType();
        StringBuffer storeString = new StringBuffer();
        for (String s : fromStrings) {
            if (storeString.length() != 0) {
                storeString.append(',');
            }
            storeString.append(s);
        }
        ret.getValue().add("(" + storeString.toString() + ")");
        return ret;
    }

    private List<String> qualifyClassCodes(List<String> classCodes)
    {
        List<String> ret = new ArrayList<String>();
        String docQueryClassCodeScheme = propertyLookup.getProperty("docQueryClassCodeScheme");
        for (String classCode : classCodes) {
            if (!NullChecker.isNullOrEmpty(docQueryClassCodeScheme)
                && !classCode.endsWith("^^" + docQueryClassCodeScheme)) {
                ret.add("'" + classCode + "^^" + docQueryClassCodeScheme + "'");
            }
            else {
                ret.add("'" + classCode + "'");
            }
        }
        return ret;
    }

    private List<String> qualifyFormatCodes(List<String> formatCodes)
    {
        List<String> ret = new ArrayList<String>();
        String docQueryFormatCodeScheme = propertyLookup.getProperty("docQueryFormatCodeScheme");
        for (String formatCode : formatCodes) {
            if (!NullChecker.isNullOrEmpty(docQueryFormatCodeScheme)
                && !formatCode.endsWith("^^" + docQueryFormatCodeScheme)) {
                ret.add("'" + formatCode + "^^" + docQueryFormatCodeScheme + "'");
            }
            else {
                ret.add("'" + formatCode + "'");
            }
        }
        return ret;
    }
    
    private ResponseOptionType createResponseOption()
    {
        ResponseOptionType ret = new ResponseOptionType();
        ret.setReturnComposedObjects(true);
        ret.setReturnType("LeafClass");
        return ret;
    }
    
    private AssertionType createAssertion(AssertionType fromAssertion, String patientId)
    {
        AssertionType ret = new AssertionType();
        Facility homeFacility = getHomeFacility();
        
        ret.setAuthorized(true);
        
        HomeCommunityType homeCommunity = new HomeCommunityType();
        homeCommunity.setHomeCommunityId(homeFacility.getFullHomeCommunityId());
        homeCommunity.setName(homeFacility.getFacilityName());
        ret.setHomeCommunity(homeCommunity);

        UserType user = new UserType();
        CeType roleCoded = new CeType();
        roleCoded.setCode("224608005");
        if (fromAssertion.getUserInfo() != null) {
            user.setUserName(fromAssertion.getUserInfo().getUserName());
            user.setPersonName(fromAssertion.getUserInfo().getPersonName());
            user.setOrg(fromAssertion.getUserInfo().getOrg());
            if (fromAssertion.getUserInfo().getRoleCoded() != null) {
                roleCoded.setCode(fromAssertion.getUserInfo().getRoleCoded().getCode());
            }
        }
        else {
            user.setUserName("VA_USER");
            PersonNameType personName = new PersonNameType();
            personName.setGivenName("VA");
            personName.setFamilyName("User");
            user.setPersonName(personName);
        }

        if (user.getPersonName() != null
            && (NullChecker.isNotNullOrEmpty(user.getPersonName().getFamilyName())
                || NullChecker.isNotNullOrEmpty(user.getPersonName().getSecondNameOrInitials())
                || NullChecker.isNotNullOrEmpty(user.getPersonName().getGivenName()))) {
            user.setUserName(user.getUserName() + ", CN=" + createFullName(user.getPersonName()) + ", O=" + homeFacility.getFacilityName());
        }
        else {
            user.setUserName(user.getUserName() + ", CN=" + user.getUserName() + ", O=" + homeFacility.getFacilityName());
        }
        
        roleCoded.setCodeSystem("2.16.840.1.113883.6.96");
        roleCoded.setCodeSystemName("SNOMED_CT");
        DataQuery query = dataManager.getQuery("STS.lookupSNOMED");
        query.setParameter("code", roleCoded.getCode());
        List<Map> results = query.getResults();
        roleCoded.setDisplayName((String)results.get(0).get("name"));
        user.setRoleCoded(roleCoded);
        //if (user.getOrg() == null) {
            user.setOrg(homeCommunity);
        //}
        ret.setUserInfo(user);

        ret.getUniquePatientId().add(patientId);

        CeType p = new CeType();
        p.setCodeSystem("2.16.840.1.113883.3.18.7.1");
        p.setCodeSystemName("nhin-purpose");
        p.setDisplayName("Treatment");
        if (fromAssertion.getPurposeOfDisclosureCoded() != null) {
            p.setCode(fromAssertion.getPurposeOfDisclosureCoded().getCode());
        }
        else {
            p.setCode("TREATMENT");
        }
        ret.setPurposeOfDisclosureCoded(p);

        SamlIssuerType sit = new SamlIssuerType();
        sit.setIssuer(propertyLookup.getProperty("AssertionIssuer"));
        sit.setIssuerFormat(propertyLookup.getProperty("AssertionIssuerFormat"));
        ret.setSamlIssuer(sit);

        ret.setMessageId("urn:uuid:" + UUID.randomUUID().toString());

        return ret;
    }

    private Map<String, List<String>> getMapFromSlots(List<SlotType1> slots)
    {
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();

        for (SlotType1 slot : slots) {
            if (!NullChecker.isNullOrEmpty(slot.getName())
                && !NullChecker.isNullOrEmpty(slot.getValueList())
                && !NullChecker.isNullOrEmpty(slot.getValueList().getValue())) {
                List<String> values = ret.get(slot.getName());
                if (values == null) {
                    values = new ArrayList<String>();
                    ret.put(slot.getName(), values);
                }
                values.addAll(parseParamFormattedStrings(slot.getValueList().getValue()));
            }
        }

        return ret;
    }

    private AdhocQueryResponse createAdhocQueryResponse(AdhocQueryRequest fromAdhocQueryRequest,
                                                        AdhocQueryResponse fromAdhocQueryResponse,
                                                        String patientId)
    {
        oasis.names.tc.ebxml_regrep.xsd.query._3.ObjectFactory objFactory = new oasis.names.tc.ebxml_regrep.xsd.query._3.ObjectFactory();
        AdhocQueryResponse ret = objFactory.createAdhocQueryResponse();
        ret.setRequestId(fromAdhocQueryRequest.getId());
        ret.setStatus(fromAdhocQueryResponse.getStatus());
        ret.setRegistryErrorList(fromAdhocQueryResponse.getRegistryErrorList());
        ret.setResponseSlotList(fromAdhocQueryResponse.getResponseSlotList());
        ret.setStartIndex(fromAdhocQueryResponse.getStartIndex());
        ret.setTotalResultCount(fromAdhocQueryResponse.getTotalResultCount());
        ret.setRegistryObjectList(createRegistryObjectList(fromAdhocQueryResponse.getRegistryObjectList(), patientId));
        ret.setRegistryErrorList(createRegistryErrorList(fromAdhocQueryResponse.getRegistryErrorList()));
        return ret;
    }

    private RegistryObjectListType createRegistryObjectList(RegistryObjectListType fromRegistryObjectList, String patientId)
    {
        RegistryObjectListType ret = null;

        if (fromRegistryObjectList != null) {
            ret = new RegistryObjectListType();
            ret.getIdentifiable().addAll(createIdentifiables(fromRegistryObjectList.getIdentifiable(), patientId));
        }

        return ret;
    }

    private List<JAXBElement<? extends IdentifiableType>> createIdentifiables(List<JAXBElement<? extends IdentifiableType>> fromIdentifiables,
                                                                              String patientId)
    {
        List<JAXBElement<? extends IdentifiableType>> ret = new ArrayList<JAXBElement<? extends IdentifiableType>>();

        for (JAXBElement<? extends IdentifiableType> identifiable : fromIdentifiables) {
            if (identifiable.getValue() instanceof ExtrinsicObjectType) {
                ret.add(createExtrinsicObject((ExtrinsicObjectType)identifiable.getValue(), patientId));
            }
            else {
                ret.add(identifiable);
            }
        }

        return ret;
    }

    private JAXBElement<? extends IdentifiableType> createExtrinsicObject(ExtrinsicObjectType fromExtrinsicObject,
                                                                          String patientId)
    {
        oasis.names.tc.ebxml_regrep.xsd.rim._3.ObjectFactory objFactory = new oasis.names.tc.ebxml_regrep.xsd.rim._3.ObjectFactory();
        ExtrinsicObjectType ret = new ExtrinsicObjectType();
        ret.setContentVersionInfo(fromExtrinsicObject.getContentVersionInfo());
        ret.setDescription(fromExtrinsicObject.getDescription());
        ret.setHome(fromExtrinsicObject.getHome());
        ret.setId(fromExtrinsicObject.getId());
        ret.setIsOpaque(fromExtrinsicObject.isIsOpaque());
        ret.setLid(fromExtrinsicObject.getLid());
        ret.setMimeType(fromExtrinsicObject.getMimeType());
        ret.setName(fromExtrinsicObject.getName());
        ret.setObjectType(fromExtrinsicObject.getObjectType());
        ret.setStatus(fromExtrinsicObject.getStatus());
        ret.setVersionInfo(fromExtrinsicObject.getVersionInfo());
        ret.getClassification().addAll(fromExtrinsicObject.getClassification());
        ret.getSlot().addAll(fromExtrinsicObject.getSlot());
        Document doc = createDocument(fromExtrinsicObject, patientId);
        ret.getExternalIdentifier().addAll(createExternalIdentifiers(fromExtrinsicObject.getExternalIdentifier(), doc));
        return objFactory.createExtrinsicObject(ret);
    }

    private Document createDocument(ExtrinsicObjectType fromExtrinsicObject, String patientId)
    {
        Document ret = new Document();
        Map<String, List<String>> slots = getMapFromSlots(fromExtrinsicObject.getSlot());

        DataQuery query = dataManager.getQuery("Composite.findDemographics");
        query.setParameter("icn", patientId);
        List<Map> results = query.getResults();
        if (!NullChecker.isNullOrEmpty(results)) {
            Map result = results.get(0);
            Map demographics = (Map)result.get("demographics");
            ret.setPatientLastName((String)demographics.get("nameFamily"));
            ret.setPatientGivenName((String)((List)demographics.get("nameGiven")).get(0));
            ret.setPatientSSN((String)demographics.get("SSN"));
            ret.setPatientPreferredFacilityNumber((String)result.get("patientPreferredFacilityNumber"));
            ret.setPatientPreferredFacilityName((String)result.get("patientPreferredFacilityName"));
        }
        
        ret.setPatientId(patientId.substring(0, 17));
        ret.setSourcePatientId(getExternalIdentifier(fromExtrinsicObject.getExternalIdentifier(), EBXML_RESPONSE_PATIENTID_IDENTIFICATION_SCHEME).getValue());
        
        if (!NullChecker.isNullOrEmpty(slots.get(EBXML_RESPONSE_SIZE_SLOTNAME))) {
            ret.setSize(Integer.parseInt(slots.get(EBXML_RESPONSE_SIZE_SLOTNAME).get(0)));
        }

        if (!NullChecker.isNullOrEmpty(slots.get(EBXML_RESPONSE_HASH_SLOTNAME))) {
            ret.setHash(slots.get(EBXML_RESPONSE_HASH_SLOTNAME).get(0));
        }

        if (!NullChecker.isNullOrEmpty(slots.get(EBXML_RESPONSE_SERVICESTARTTIME_SLOTNAME))) {
            ret.setBeginDate(parseDate(slots.get(EBXML_RESPONSE_SERVICESTARTTIME_SLOTNAME).get(0), DATE_FORMAT_SERVICE));
        }

        if (!NullChecker.isNullOrEmpty(slots.get(EBXML_RESPONSE_SERVICESTOPTIME_SLOTNAME))) {
            ret.setEndDate(parseDate(slots.get(EBXML_RESPONSE_SERVICESTOPTIME_SLOTNAME).get(0), DATE_FORMAT_SERVICE));
        }

        if (!NullChecker.isNullOrEmpty(slots.get(EBXML_RESPONSE_CREATIONTIME_SLOTNAME))) {
            ret.setCreationTime(new Date());
        }

        ret.setMimeType(fromExtrinsicObject.getMimeType());
        ret.setAvailabilityStatus("urn:ihe:iti:2010:StatusType:DeferredCreation");
        
        if (fromExtrinsicObject.getName() != null
            && !NullChecker.isNullOrEmpty(fromExtrinsicObject.getName().getLocalizedString())) {
            ret.setTitle(fromExtrinsicObject.getName().getLocalizedString().get(0).getValue());
        }

        ret.setDocumentUniqueId(UUID.randomUUID().toString());

        ClassificationType classification = getClassification(fromExtrinsicObject.getClassification(), EBXML_RESPONSE_CLASSCODE_CLASS_SCHEME);
        if (classification != null) {
            ret.setClassCode(classification.getNodeRepresentation());
            ret.setClassCodeScheme(getMapFromSlots(classification.getSlot()).get("codingScheme").get(0));
            ret.setClassCodeDisplayName(classification.getName().getLocalizedString().get(0).getValue());
        }

        classification = getClassification(fromExtrinsicObject.getClassification(), EBXML_RESPONSE_FORMATCODE_CLASS_SCHEME);
        if (classification != null) {
            ret.setFormatCode(classification.getNodeRepresentation());
            ret.setFormatCodeScheme(getMapFromSlots(classification.getSlot()).get("codingScheme").get(0));
            ret.setFormatCodeDisplayName(classification.getName().getLocalizedString().get(0).getValue());
        }
        
        String homeCommunityId = fromExtrinsicObject.getHome();
        String documentRepositoryId = slots.get(EBXML_RESPONSE_REPOSITORY_UNIQUE_ID_SLOTNAME).get(0);
        String documentUniqueId = getExternalIdentifier(fromExtrinsicObject.getExternalIdentifier(), EBXML_RESPONSE_DOCID_IDENTIFICATION_SCHEME).getValue();
        ret.setDocGenQueryName("Remote");
        ret.setDocGenQueryParams("homeCommunityId=" + homeCommunityId + ",documentRepositoryId=" + documentRepositoryId + ",documentUniqueId=" + documentUniqueId);

        documentRepository.storeDocument(ret);
        
        return ret;
    }

    private Date parseDate(String dateString, String formatString)
    {
        Date ret = null;
        SimpleDateFormat formatter = (SimpleDateFormat)DateFormat.getDateTimeInstance();
        formatter.applyPattern(formatString);
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            /*ret =*/ formatter.parse(dateString);
        }
        catch (ParseException pe) {
            ret = null;
        }

        return ret;
    }

    private ExternalIdentifierType getExternalIdentifier(List<ExternalIdentifierType> externalIdentifiers, String identificationScheme)
    {
        ExternalIdentifierType ret = null;

        for (ExternalIdentifierType id : externalIdentifiers) {
            if (id.getIdentificationScheme().equals(identificationScheme)) {
                ret = id;
                break;
            }
        }

        return ret;
    }

    private List<ExternalIdentifierType> createExternalIdentifiers(List<ExternalIdentifierType> fromExternalIdentifiers,
                                                                   Document document)
    {
        List<ExternalIdentifierType> ret = new ArrayList<ExternalIdentifierType>();
        for (ExternalIdentifierType id : fromExternalIdentifiers) {
            for (LocalizedStringType name : id.getName().getLocalizedString()) {
                if (name.getValue().equals(EBXML_RESPONSE_DOCID_NAME)) {
                    ret.add(createExternalIdentifier(id, document));
                }
                else {
                    ret.add(id);
                }
            }
        }

        return ret;
    }

    private ClassificationType getClassification(List<ClassificationType> fromClassifications, String classScheme)
    {
        ClassificationType ret = null;

        for (ClassificationType cls : fromClassifications) {
            if (cls.getClassificationScheme().equals(classScheme)) {
                ret = cls;
                break;
            }
        }

        return ret;
    }

    private ExternalIdentifierType createExternalIdentifier(ExternalIdentifierType fromId,
                                                            Document document)
    {
        ExternalIdentifierType ret = new ExternalIdentifierType();
        ret.setDescription(fromId.getDescription());
        ret.setHome(fromId.getHome());
        ret.setId(fromId.getId());
        ret.setIdentificationScheme(fromId.getIdentificationScheme());
        ret.setLid(fromId.getLid());
        ret.setName(fromId.getName());
        ret.setObjectType(fromId.getObjectType());
        ret.setRegistryObject(fromId.getRegistryObject());
        ret.setStatus(fromId.getStatus());
        ret.setValue(document.getDocumentUniqueId());
        ret.setVersionInfo(fromId.getVersionInfo());
        return ret;
    }

    private RegistryErrorList createRegistryErrorList(RegistryErrorList fromRegistryErrorList)
    {
        RegistryErrorList ret = null;

        if (fromRegistryErrorList != null) {
            ret = new RegistryErrorList();
            ret.setHighestSeverity(fromRegistryErrorList.getHighestSeverity());
            ret.getRegistryError().addAll(createRegistryErrors(fromRegistryErrorList.getRegistryError()));
        }

        return ret;
    }

    private List<RegistryError> createRegistryErrors(List<RegistryError> fromRegistryErrors)
    {
        List<RegistryError> ret = new ArrayList<RegistryError>();

        for (RegistryError registryError : fromRegistryErrors) {
            ret.add(createRegistryError(registryError));
        }

        return ret;
    }

    private RegistryError createRegistryError(RegistryError fromRegistryError)
    {
        RegistryError ret = new RegistryError();
        ret.setCodeContext(fromRegistryError.getCodeContext());
        ret.setErrorCode(fromRegistryError.getErrorCode());
        ret.setLocation(fromRegistryError.getLocation());
        ret.setSeverity(fromRegistryError.getSeverity());
        ret.setValue(fromRegistryError.getValue());
        return ret;
    }

    private AdhocQueryResponse createAdhocQueryResponseError(AdhocQueryRequest fromAdhocQueryRequest)
    {
        oasis.names.tc.ebxml_regrep.xsd.query._3.ObjectFactory objFactory = new oasis.names.tc.ebxml_regrep.xsd.query._3.ObjectFactory();
        AdhocQueryResponse ret = objFactory.createAdhocQueryResponse();
        ret.setStatus("urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:Failure");
        ret.setRegistryErrorList(createDefaultRegistryErrorList());
        ret.setRequestId(fromAdhocQueryRequest.getId());
        return ret;
    }

    private RegistryErrorList createDefaultRegistryErrorList()
    {
        RegistryErrorList ret = new RegistryErrorList();
        ret.getRegistryError().add(createDefaultRegistryError());
        ret.setHighestSeverity("urn:oasis:names:tc:ebxml-regrep:ErrorSeverityType:Error");
        return ret;
    }

    private RegistryError createDefaultRegistryError()
    {
        RegistryError ret = new RegistryError();
        ret.setErrorCode("XDSRegistryError");
        ret.setCodeContext("Internal Registry/Repository Error");
        ret.setSeverity("urn:oasis:names:tc:ebxml-regrep:ErrorSeverityType:Error");
        return ret;
    }

    public List<String> parseParamFormattedStrings(List<String> paramFormattedStrings)
    {
        List<String> ret = new ArrayList<String>();

        for (String paramFormattedString : paramFormattedStrings) {
            parseParamFormattedString(paramFormattedString, ret);
        }

        return ret;
    }

    public void parseParamFormattedString(String paramFormattedString, List<String> resultCollection)
    {
        if ((paramFormattedString != null) && (resultCollection != null)) {
            String working = paramFormattedString;
            if (paramFormattedString.startsWith("(")) {
                working = paramFormattedString.substring(1);
                int endIndex = working.indexOf(")");
                if (endIndex != -1) {
                    working = working.substring(0, endIndex);
                }
            }
            String[] multiValueString = working.split(",");
            if (multiValueString != null) {
                for (int i = 0; i < multiValueString.length; i++) {
                    String singleValue = multiValueString[i];
                    if (singleValue != null) {
                        singleValue = singleValue.trim();
                    }
                    if (singleValue.startsWith("'")) {
                        singleValue = singleValue.substring(1);
                        int endTickIndex = singleValue.indexOf("'");
                        if (endTickIndex != -1) {
                            singleValue = singleValue.substring(0, endTickIndex);
                        }
                    }
                    resultCollection.add(singleValue);
                }
            }
        }
    }

    private boolean checkPolicy(AssertionType assertion)
    {
        boolean ret = false;

        if (assertion.getUserInfo() != null
            && !NullChecker.isNullOrEmpty(assertion.getUserInfo().getUserName())) {
            RequestType request =
                    CheckPolicyRequestBuilder.buildNHINOutCheckPolicyRequest(assertion.getUserInfo().getUserName(), getHomeFacility().getFullHomeCommunityId());
            CheckPolicyRequestType checkPolicyRequest = new CheckPolicyRequestType();
            checkPolicyRequest.setRequest(request);
            CheckPolicyResponseType checkPolicyResponse = adapterPolicyEngine.checkPolicy(checkPolicyRequest);
            if (checkPolicyResponse != null
                && !NullChecker.isNullOrEmpty(checkPolicyResponse.getResponse())
                && !NullChecker.isNullOrEmpty(checkPolicyResponse.getResponse().getResult())) {
                ret = checkPolicyResponse.getResponse().getResult().get(0).getDecision() == DecisionType.PERMIT;
            }
        }

        return ret;
    }
    
    private Facility getHomeFacility()
    {
        return facilityManager.getFacilityByFacilityNumber("VA");
    }
    
    private String createFullName(PersonNameType personName)
    {
        StringBuffer ret = new StringBuffer();
        
        if (NullChecker.isNotNullOrEmpty(personName.getGivenName())) {
            ret.append(personName.getGivenName());
        }
        
        if (NullChecker.isNotNullOrEmpty(personName.getSecondNameOrInitials())) {
            if (ret.length() > 0) {
                ret.append(' ');
            }
            ret.append(personName.getSecondNameOrInitials());
        }
        
        if (NullChecker.isNotNullOrEmpty(personName.getFamilyName())) {
            if (ret.length() > 0) {
                ret.append(' ');
            }
            ret.append(personName.getFamilyName());
        }
        
        return ret.toString();
    }       
}
