/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package ext.domain.nhin.adapter.adaptergateway.docquery;

import java.net.URL;
import java.util.regex.*;
import java.util.*;
import java.util.concurrent.*;
import java.util.logging.*;

import javax.ejb.*;

import gov.hhs.fha.nhinc.adapterpolicyengine.*;
import gov.hhs.fha.nhinc.common.eventcommon.*;
import gov.hhs.fha.nhinc.common.nhinccommon.*;
import gov.hhs.fha.nhinc.common.nhinccommonadapter.*;
import gov.hhs.fha.nhinc.nhinccomponentpatientcorrelation.*;
import gov.hhs.fha.nhinc.nhinclib.NhincConstants;
import gov.hhs.fha.nhinc.transform.policy.*;
import gov.hhs.fha.nhinc.transform.subdisc.*;
import oasis.names.tc.ebxml_regrep.xsd.query._3.*;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.*;
import oasis.names.tc.ebxml_regrep.xsd.rs._3.*;
import oasis.names.tc.xacml._2_0.context.schema.os.*;
import org.hl7.v3.*;

import ext.domain.nhin.adapter.facilitymanager.*;
import ext.domain.nhin.adapter.patientcorrelation.*;
import ext.domain.nhin.adapter.policyengine.*;
import ext.domain.nhin.adapter.propertylookup.*;
import ext.domain.nhin.adapter.utils.*;

/**
 *
 * @author VHAISBVAZQUD
 */
@Stateless(name = "AdapterGatewayDocQueryOrch")
public class AdapterGatewayDocQueryOrchBean implements AdapterGatewayDocQueryPortTypeLocal
{
    private class SendRequestResponse
    {
        public AdhocQueryResponse adhocQueryResponse;
        public II remotePatientId;
        public String remoteHomeCommunityId;
    }
    
    private class SendRequestException extends Exception
    {
        public II remotePatientId;
        public String remoteHomeCommunityId;
    }
    
    private class SendRequestCallable implements Callable<SendRequestResponse>
    {
        private final AdhocQueryRequest adhocQueryRequest;
        private final AssertionType assertion;
        private II remotePatientId;
        private String remoteHomeCommunityId;
        
        public SendRequestCallable(AdhocQueryRequest adhocQueryRequest, AssertionType assertion, II remotePatientId, String remoteHomeCommunityId)
        {
            this.adhocQueryRequest = adhocQueryRequest;
            this.assertion = assertion;
            this.remotePatientId = remotePatientId;
            this.remoteHomeCommunityId = remoteHomeCommunityId;
        }
        
        public SendRequestResponse call() throws Exception
        {
            return sendRequest(adhocQueryRequest, assertion, remotePatientId, remoteHomeCommunityId);
        }
    }
    
    static private final Logger logger = Logger.getLogger(AdapterGatewayDocQueryOrchBean.class.getName());

    static private final String EBXML_DOCENTRY_PATIENT_ID = "$XDSDocumentEntryPatientId";

    private FacilityManager facilityManager;
    private PropertyLookup propertyLookup;
    private PatientCorrelationPortType adapterPatientCorrelation;
    private AdapterPolicyEnginePortType adapterPolicyEngine;
    private NHINDocQueryRequestSender nhinDocQueryRequestSender;
    private ExecutorService executorService;

    @EJB(beanInterface = FacilityManagerLocal.class, beanName = "FacilityManager")
    public void setFacilityManager(FacilityManager facilityManager)
    {
        this.facilityManager = facilityManager;
    }

    @EJB(beanInterface = PropertyLookupLocal.class, beanName = "PropertyLookup")
    public void setPropertyLookup(PropertyLookup propertyLookup)
    {
        this.propertyLookup = propertyLookup;
    }
    
    @EJB(beanInterface = AdapterPolicyEnginePortTypeLocal.class, beanName = "AdapterPolicyEngine")
    public void setAdapterPolicyEngine(AdapterPolicyEnginePortType adapterPolicyEngine)
    {
        this.adapterPolicyEngine = adapterPolicyEngine;
    }
    
    @EJB(beanInterface = PatientCorrelationPortTypeLocal.class, beanName = "AdapterPatientCorrelation")
    public void setAdapterPatientCorrelation(PatientCorrelationPortType adapterPatientCorrelation)
    {
        this.adapterPatientCorrelation = adapterPatientCorrelation;
    }

    @EJB(beanInterface = NHINDocQueryRequestSender.class, beanName = "NhincProxyNHINDocQueryRequestSender")
    public void setNhinDocQueryRequestSender(NHINDocQueryRequestSender nhinDocQueryRequestSender)
    {
        this.nhinDocQueryRequestSender = nhinDocQueryRequestSender;
    }

    @EJB(beanInterface = WorkManagerExecutorServiceLocal.class, beanName = "WorkManagerExecutorService")
    public void setExecutorService(ExecutorService executorService)
    {
        this.executorService = executorService;
    }
    
    public RespondingGatewayCrossGatewayQueryResponseType respondingGatewayCrossGatewayQuery(RespondingGatewayCrossGatewayQueryRequestType respondingGatewayCrossGatewayQueryRequest)
    {
        logger.entering(getClass().getName(), "respondingGatewayCrossGatewayQuery");

        RespondingGatewayCrossGatewayQueryResponseType ret = createRespondingGatewayCrossGatewayQueryResponse();
        
        try {
            ExecutorCompletionService<SendRequestResponse> completionService = new ExecutorCompletionService<SendRequestResponse>(executorService);

            II patientId = getPatientId(respondingGatewayCrossGatewayQueryRequest.getAdhocQueryRequest());
            if (patientId != null) {
                RetrievePatientCorrelationsResponseType patientCorrelations = getPatientCorrelations(patientId);
                if (patientCorrelations != null
                    && patientCorrelations.getPRPAIN201310UV02() != null)
                {
                    int numSubmitted = 0;
                    PRPAMT201304UV02Patient patient = extractPatient(patientCorrelations.getPRPAIN201310UV02());
                    for (II correlatedPatientId : patient.getId()) {
                        List<String> remoteHomeCommunityIds = getRemoteHomeCommunityIds(correlatedPatientId);
                        for (String remoteHomeCommunityId : remoteHomeCommunityIds) {
                            AdhocQueryRequest adhocQueryRequest = createAdhocQueryRequest(respondingGatewayCrossGatewayQueryRequest.getAdhocQueryRequest(), remoteHomeCommunityId, correlatedPatientId);
                            if (checkPolicy(adhocQueryRequest, respondingGatewayCrossGatewayQueryRequest.getAssertion(), remoteHomeCommunityId)) {
                                SendRequestCallable callable = new SendRequestCallable(adhocQueryRequest, respondingGatewayCrossGatewayQueryRequest.getAssertion(), correlatedPatientId, remoteHomeCommunityId);
                                completionService.submit(callable);
                                ++numSubmitted;
                            }
                        }
                    }

                    for (int i = 0;  i < numSubmitted;  ++i) {
                        try {
                            SendRequestResponse response = completionService.take().get();
                            addResultToResponse(ret, response);
                        }
                        catch (ExecutionException ee) {
                            SendRequestException sre = (SendRequestException)ee.getCause();
                            addErrorToResponse(ret, respondingGatewayCrossGatewayQueryRequest.getAdhocQueryRequest(), sre);
                            logger.log(Level.WARNING, "Error sending DocQuery to {0} - {1}", new Object[]{sre.remoteHomeCommunityId, sre.getCause().getMessage()});
                            logger.log(Level.WARNING, "Stack trace", sre.getCause());
                        }
                        catch (InterruptedException ie) {
                            break;
                        }
                    }
                }
            }
        }
        finally {
            logger.exiting(getClass().getName(), "respondingGatewayCrossGatewayQuery");
        }
        
        return ret;
    }

    private RespondingGatewayCrossGatewayQueryResponseType createRespondingGatewayCrossGatewayQueryResponse()
    {
        CommunityAdhocQueryResponsesType communityResponses = new CommunityAdhocQueryResponsesType();

        RespondingGatewayCrossGatewayQueryResponseType ret = new RespondingGatewayCrossGatewayQueryResponseType();
        ret.setCommunityResponses(communityResponses);
        
        return ret;
    }

    private II getPatientId(AdhocQueryRequest adhocQueryRequest)
    {
        II ret = new II();
        Map<String, List<String>> slotMap = getMapFromSlots(adhocQueryRequest.getAdhocQuery().getSlot());
        String patientId = slotMap.get(EBXML_DOCENTRY_PATIENT_ID).get(0);
        Pattern p = Pattern.compile("\\d{10}V\\d{6}");
        Matcher m = p.matcher(patientId);
        if (m.find()) {
            ret = new II();
            ret.setExtension(m.group());
            ret.setRoot(getHomeCommunityId());
        }
        return ret;
    }

    private Map<String, List<String>> getMapFromSlots(List<SlotType1> slots)
    {
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();

        for (SlotType1 slot : slots) {
            if (!NullChecker.isNullOrEmpty(slot.getName())
                && !NullChecker.isNullOrEmpty(slot.getValueList())
                && !NullChecker.isNullOrEmpty(slot.getValueList().getValue())) {
                List<String> values = ret.get(slot.getName());
                if (values == null) {
                    values = new ArrayList<String>();
                    ret.put(slot.getName(), values);
                }
                values.addAll(parseParamFormattedStrings(slot.getValueList().getValue()));
            }
        }

        return ret;
    }

    public List<String> parseParamFormattedStrings(List<String> paramFormattedStrings)
    {
        List<String> ret = new ArrayList<String>();

        for (String paramFormattedString : paramFormattedStrings) {
            parseParamFormattedString(paramFormattedString, ret);
        }

        return ret;
    }

    public void parseParamFormattedString(String paramFormattedString, List<String> resultCollection)
    {
        if ((paramFormattedString != null) && (resultCollection != null)) {
            String working = paramFormattedString;
            if (paramFormattedString.startsWith("(")) {
                working = paramFormattedString.substring(1);
                int endIndex = working.indexOf(")");
                if (endIndex != -1) {
                    working = working.substring(0, endIndex);
                }
            }
            String[] multiValueString = working.split(",");
            if (multiValueString != null) {
                for (int i = 0; i < multiValueString.length; i++) {
                    String singleValue = multiValueString[i];
                    if (singleValue != null) {
                        singleValue = singleValue.trim();
                    }
                    if (singleValue.startsWith("'")) {
                        singleValue = singleValue.substring(1);
                        int endTickIndex = singleValue.indexOf("'");
                        if (endTickIndex != -1) {
                            singleValue = singleValue.substring(0, endTickIndex);
                        }
                    }
                    resultCollection.add(singleValue);
                }
            }
        }
    }

    private RetrievePatientCorrelationsResponseType getPatientCorrelations(II patientId)
    {
        RetrievePatientCorrelationsRequestType request = createRetrievePatientCorrelationsRequest(patientId);
        return adapterPatientCorrelation.retrievePatientCorrelations(request);
    }

    private RetrievePatientCorrelationsRequestType createRetrievePatientCorrelationsRequest(II patientId)
    {
        RetrievePatientCorrelationsRequestType ret = new RetrievePatientCorrelationsRequestType();
        ret.setPRPAIN201309UV02(HL7PRPA201309Transforms.createPRPA201309(patientId.getRoot(), patientId.getExtension()));
        return ret;
    }

    private String getHomeCommunityId()
    {
        String ret = null;
        Facility facility = facilityManager.getFacilityByFacilityNumber("VA");
        if (facility != null) {
            ret = facility.getHomeCommunityId();
        }
        return ret;
    }
    
    private String getFullHomeCommunityId()
    {
        String ret = null;
        Facility facility = facilityManager.getFacilityByFacilityNumber("VA");
        if (facility != null) {
            ret = facility.getFullHomeCommunityId();
        }
        return ret;
    }

    private PRPAMT201304UV02Patient extractPatient(PRPAIN201310UV02 prpain201310UV02)
    {
        PRPAMT201304UV02Patient ret = null;

        if (prpain201310UV02.getControlActProcess() != null
            && !NullChecker.isNullOrEmpty(prpain201310UV02.getControlActProcess().getSubject())
            && prpain201310UV02.getControlActProcess().getSubject().get(0).getRegistrationEvent() != null
            && prpain201310UV02.getControlActProcess().getSubject().get(0).getRegistrationEvent().getSubject1() != null
            && prpain201310UV02.getControlActProcess().getSubject().get(0).getRegistrationEvent().getSubject1().getPatient() != null) {
            ret = prpain201310UV02.getControlActProcess().getSubject().get(0).getRegistrationEvent().getSubject1().getPatient();
        }
        
        return ret;
    }

    private List<String> getRemoteHomeCommunityIds(II remotePatientId)
    {
        List<String> ret = new ArrayList<String>();
        List<Facility> remoteFacilities = facilityManager.getFacilitiesContainingAssigningAuthority(remotePatientId.getRoot());

        if (NullChecker.isNotNullOrEmpty(remoteFacilities)) {
            for (Facility remoteFacility : remoteFacilities) {
                ret.add(remoteFacility.getHomeCommunityId());
            }
        }

        return ret;
    }

    private boolean checkPolicy(AdhocQueryRequest adhocQueryRequest, AssertionType assertion, String homeCommunityId)
    {
        AdhocQueryRequestMessageType adhocQueryRequestMessage = new AdhocQueryRequestMessageType();
        adhocQueryRequestMessage.setAdhocQueryRequest(adhocQueryRequest);
        adhocQueryRequestMessage.setAssertion(assertion);

        HomeCommunityType receivingHomeCommunity = new HomeCommunityType();
        receivingHomeCommunity.setHomeCommunityId(homeCommunityId);
        
        HomeCommunityType sendingHomeCommunity = new HomeCommunityType();
        sendingHomeCommunity.setHomeCommunityId(getHomeCommunityId());
        
        AdhocQueryRequestEventType adhocQueryRequestEvent = new AdhocQueryRequestEventType();
        adhocQueryRequestEvent.setMessage(adhocQueryRequestMessage);
        adhocQueryRequestEvent.setDirection(NhincConstants.POLICYENGINE_OUTBOUND_DIRECTION);
        adhocQueryRequestEvent.setReceivingHomeCommunity(receivingHomeCommunity);
        adhocQueryRequestEvent.setSendingHomeCommunity(sendingHomeCommunity);
        adhocQueryRequestEvent.setInterface(NhincConstants.AUDIT_LOG_ENTITY_INTERFACE);
        
        PolicyEngineTransformer policyEngineTransformer = new PolicyEngineTransformer();
        CheckPolicyRequestType checkPolicyRequest = policyEngineTransformer.transformAdhocQueryToCheckPolicy(adhocQueryRequestEvent);
        /*
        checkPolicyRequest.setRequest(CheckPolicyRequestBuilder.buildDocumentQueryOutCheckPolicyRequest(assertion.getUserInfo().getUserName(),
                                                                          assertion.getUniquePatientId().get(0),
                                                                          assertion.getPurposeOfDisclosureCoded().getCode(),
                                                                          homeCommunityId,
                                                                          assertion.getHomeCommunity().getHomeCommunityId()));
        */
        
        
        CheckPolicyResponseType checkPolicyResponse = adapterPolicyEngine.checkPolicy(checkPolicyRequest);
        
        return checkPolicyResponse != null
               && checkPolicyResponse.getResponse() != null
               && NullChecker.isNotNullOrEmpty(checkPolicyResponse.getResponse().getResult())
               && checkPolicyResponse.getResponse().getResult().get(0).getDecision() == DecisionType.PERMIT;
    }
    
    private SendRequestResponse sendRequest(AdhocQueryRequest adhocQueryRequest,
                                            AssertionType assertion,
                                            II remotePatientId,
                                            String remoteHomeCommunityId)
        throws SendRequestException
    {
        SendRequestResponse ret = new SendRequestResponse();
        
        try {
            ret.adhocQueryResponse = nhinDocQueryRequestSender.sendRequest(adhocQueryRequest, assertion, remoteHomeCommunityId);
            ret.remoteHomeCommunityId = remoteHomeCommunityId;
            ret.remotePatientId = remotePatientId;
            return ret;
        }
        catch (Exception e) {
            SendRequestException sre = new SendRequestException();
            sre.remoteHomeCommunityId = remoteHomeCommunityId;
            sre.remotePatientId = remotePatientId;
            sre.initCause(e);
            throw sre;
        }
    }

    private AdhocQueryRequest createAdhocQueryRequest(AdhocQueryRequest fromAdhocQueryRequest, String homeCommunityId, II remotePatientId)
    {
        AdhocQueryRequest ret = new AdhocQueryRequest();
        ret.setFederation(fromAdhocQueryRequest.getFederation());
        ret.setMaxResults(fromAdhocQueryRequest.getMaxResults());
        ret.setStartIndex(fromAdhocQueryRequest.getStartIndex());
        ret.setId(fromAdhocQueryRequest.getId());
        ret.setComment(fromAdhocQueryRequest.getComment());
        ret.setRequestSlotList(fromAdhocQueryRequest.getRequestSlotList());
        ret.setAdhocQuery(createAdhocQuery(fromAdhocQueryRequest.getAdhocQuery(), homeCommunityId, remotePatientId));
        ret.setResponseOption(fromAdhocQueryRequest.getResponseOption());
        return ret;
    }

    private AdhocQueryType createAdhocQuery(AdhocQueryType fromAdhocQuery, String homeCommunityId, II remotePatientId)
    {
        AdhocQueryType ret = new AdhocQueryType();
        ret.setDescription(fromAdhocQuery.getDescription());
        ret.setHome("urn:oid:" + homeCommunityId);
        ret.setId(fromAdhocQuery.getId());
        ret.setLid(fromAdhocQuery.getLid());
        ret.setName(fromAdhocQuery.getName());
        ret.setObjectType(fromAdhocQuery.getObjectType());
        ret.setQueryExpression(fromAdhocQuery.getQueryExpression());
        ret.setStatus(fromAdhocQuery.getStatus());
        ret.setVersionInfo(fromAdhocQuery.getVersionInfo());
        ret.getExternalIdentifier().addAll(fromAdhocQuery.getExternalIdentifier());
        ret.getSlot().addAll(createSlots(fromAdhocQuery.getSlot(), remotePatientId));
        ret.getClassification().addAll(fromAdhocQuery.getClassification());
        return ret;
    }

    private List<SlotType1> createSlots(List<SlotType1> slots, II remotePatientId)
    {
        ArrayList<SlotType1> ret = new ArrayList<SlotType1>();

        for (SlotType1 slot : slots) {
            SlotType1 newSlot;
            if (slot.getName().equals(EBXML_DOCENTRY_PATIENT_ID)) {
                newSlot = new SlotType1();
                newSlot.setName(EBXML_DOCENTRY_PATIENT_ID);
                newSlot.setValueList(createValueList("'" + remotePatientId.getExtension() + "^^^&" + remotePatientId.getRoot() + "&ISO'"));
            }
            else {
                newSlot = slot;
            }
            ret.add(newSlot);
        }

        return ret;
    }

    private ValueListType createValueList(String value)
    {
        ValueListType ret = new ValueListType();
        ret.getValue().add(value);
        return ret;
    }
    
    private void addResultToResponse(RespondingGatewayCrossGatewayQueryResponseType respondingGatewayCrossGatewayQueryResponse, SendRequestResponse response)
    {
        HomeCommunityType homeCommunity = new HomeCommunityType();
        homeCommunity.setHomeCommunityId(response.remoteHomeCommunityId);
        Facility facility = facilityManager.getFacilityByHomeCommunityId(response.remoteHomeCommunityId);
        homeCommunity.setName(facility.getFacilityName());
        
        NhinTargetCommunityType nhinTargetCommunity = new NhinTargetCommunityType();
        nhinTargetCommunity.setHomeCommunity(homeCommunity);
        
        CommunityAdhocQueryResponseType communityResponse = new CommunityAdhocQueryResponseType();
        communityResponse.setAdhocQueryResponse(response.adhocQueryResponse);
        communityResponse.setNhinTargetCommunity(nhinTargetCommunity);
        
        respondingGatewayCrossGatewayQueryResponse.getCommunityResponses().getCommunityResponse().add(communityResponse);
    }
    
    private void addErrorToResponse(RespondingGatewayCrossGatewayQueryResponseType respondingGatewayCrossGatewayQueryResponse,
                                    AdhocQueryRequest adhocQueryRequest,
                                    SendRequestException sendRequestException)
    {
        AdhocQueryResponse adhocQueryResponse = createAdhocQueryResponseError(adhocQueryRequest);
        adhocQueryResponse.setRegistryErrorList(new RegistryErrorList());
        adhocQueryResponse.getRegistryErrorList().setHighestSeverity("urn:oasis:names:tc:ebxml-regrep:ErrorSeverityType:Error");
        
        RegistryError registryError = new RegistryError();
        registryError.setErrorCode("XDSRegistryError");
        String errorMessage = "Internal Registry/Repository Error - "
                              + "HCID = " + sendRequestException.remoteHomeCommunityId
                              + ", patientID = " + sendRequestException.remotePatientId;
        registryError.setCodeContext(errorMessage);
        registryError.setSeverity("urn:oasis:names:tc:ebxml-regrep:ErrorSeverityType:Error");
        adhocQueryResponse.getRegistryErrorList().getRegistryError().add(registryError);
        
        HomeCommunityType homeCommunity = new HomeCommunityType();
        homeCommunity.setHomeCommunityId(sendRequestException.remoteHomeCommunityId);
        Facility facility = facilityManager.getFacilityByHomeCommunityId(sendRequestException.remoteHomeCommunityId);
        homeCommunity.setName(facility.getFacilityName());
        
        NhinTargetCommunityType nhinTargetCommunity = new NhinTargetCommunityType();
        nhinTargetCommunity.setHomeCommunity(homeCommunity);
        
        CommunityAdhocQueryResponseType communityResponse = new CommunityAdhocQueryResponseType();
        communityResponse.setAdhocQueryResponse(adhocQueryResponse);
        communityResponse.setNhinTargetCommunity(nhinTargetCommunity);
        
        respondingGatewayCrossGatewayQueryResponse.getCommunityResponses().getCommunityResponse().add(communityResponse);
    }
    
    private AdhocQueryResponse createAdhocQueryResponseError(AdhocQueryRequest adhocQueryRequest)
    {
        AdhocQueryResponse ret = new AdhocQueryResponse();
        ret.setRequestId(adhocQueryRequest.getId());
        ret.setStartIndex(adhocQueryRequest.getStartIndex());
        ret.setStatus("urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:Failure");
        return ret;
    }
}

