/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ext.domain.nhin.adapter.terminology;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

/**
 *
 * @author David Vazquez
 */
@Entity
@Table(name = "TRANSLATIONS")
@NamedQueries({
    @NamedQuery(name = "Translation.findAll", query = "SELECT t FROM Translation t"),
    @NamedQuery(name = "Translation.findByTranslationId", query = "SELECT t FROM Translation t WHERE t.translationId = :translationId"),
    @NamedQuery(name = "Translation.findBySourceCodeset", query = "SELECT t FROM Translation t WHERE t.sourceCodeset = :sourceCodeset"),
    @NamedQuery(name = "Translation.findBySourceCode", query = "SELECT t FROM Translation t WHERE t.sourceCode = :sourceCode"),
    @NamedQuery(name = "Translation.findByTargetCodeset", query = "SELECT t FROM Translation t WHERE t.targetCodeset = :targetCodeset"),
    @NamedQuery(name = "Translation.findByTargetCode", query = "SELECT t FROM Translation t WHERE t.targetCode = :targetCode"),
    @NamedQuery(name = "Translation.findTranslation", query = "select t from Translation t where t.sourceCodeset = :sourceCodeset and t.sourceCode = :sourceCode and t.targetCodeset = :targetCodeset")
})
public class Translation implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Basic(optional = false)
    @Column(name = "TRANSLATION_ID")
    private BigDecimal translationId;
    @Basic(optional = false)
    @Column(name = "SOURCE_CODESET")
    private String sourceCodeset;
    @Basic(optional = false)
    @Column(name = "SOURCE_CODE")
    private String sourceCode;
    @Basic(optional = false)
    @Column(name = "TARGET_CODESET")
    private String targetCodeset;
    @Basic(optional = false)
    @Column(name = "TARGET_CODE")
    private String targetCode;

    public Translation()
    {
    }

    public Translation(BigDecimal translationId)
    {
        this.translationId = translationId;
    }

    public Translation(BigDecimal translationId, String sourceCodeset, String sourceCode, String targetCodeset, String targetCode)
    {
        this.translationId = translationId;
        this.sourceCodeset = sourceCodeset;
        this.sourceCode = sourceCode;
        this.targetCodeset = targetCodeset;
        this.targetCode = targetCode;
    }

    public BigDecimal getTranslationId()
    {
        return translationId;
    }

    public void setTranslationId(BigDecimal translationId)
    {
        this.translationId = translationId;
    }

    public String getSourceCodeset()
    {
        return sourceCodeset;
    }

    public void setSourceCodeset(String sourceCodeset)
    {
        this.sourceCodeset = sourceCodeset;
    }

    public String getSourceCode()
    {
        return sourceCode;
    }

    public void setSourceCode(String sourceCode)
    {
        this.sourceCode = sourceCode;
    }

    public String getTargetCodeset()
    {
        return targetCodeset;
    }

    public void setTargetCodeset(String targetCodeset)
    {
        this.targetCodeset = targetCodeset;
    }

    public String getTargetCode()
    {
        return targetCode;
    }

    public void setTargetCode(String targetCode)
    {
        this.targetCode = targetCode;
    }

    @Override
    public int hashCode()
    {
        int hash = 0;
        hash += (translationId != null ? translationId.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object)
    {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof Translation)) {
            return false;
        }
        Translation other = (Translation) object;
        if ((this.translationId == null && other.translationId != null) || (this.translationId != null && !this.translationId.equals(other.translationId))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString()
    {
        return "ext.domain.nhin.adapter.terminology.Translation[translationId=" + translationId + "]";
    }

}
