/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ext.domain.nhin.adapter.terminology;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

/**
 *
 * @author David Vazquez
 */
@Entity
@Table(name = "CODESETS")
@NamedQueries({
    @NamedQuery(name = "Codeset.findAll", query = "SELECT c FROM Codeset c"),
    @NamedQuery(name = "Codeset.findByCodesetId", query = "SELECT c FROM Codeset c WHERE c.codesetId = :codesetId"),
    @NamedQuery(name = "Codeset.findByCodeset", query = "SELECT c FROM Codeset c WHERE c.codeset = :codeset"),
    @NamedQuery(name = "Codeset.findByLookupTable", query = "SELECT c FROM Codeset c WHERE c.lookupTable = :lookupTable"),
    @NamedQuery(name = "Codeset.findByKeyField", query = "SELECT c FROM Codeset c WHERE c.keyField = :keyField")})
public class Codeset implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Basic(optional = false)
    @Column(name = "CODESET_ID")
    private BigDecimal codesetId;
    @Basic(optional = false)
    @Column(name = "CODESET")
    private String codeset;
    @Basic(optional = false)
    @Column(name = "LOOKUP_TABLE")
    private String lookupTable;
    @Basic(optional = false)
    @Column(name = "KEY_FIELD")
    private String keyField;

    public Codeset()
    {
    }

    public Codeset(BigDecimal codesetId)
    {
        this.codesetId = codesetId;
    }

    public Codeset(BigDecimal codesetId, String codeset, String lookupTable, String keyField)
    {
        this.codesetId = codesetId;
        this.codeset = codeset;
        this.lookupTable = lookupTable;
        this.keyField = keyField;
    }

    public BigDecimal getCodesetId()
    {
        return codesetId;
    }

    public void setCodesetId(BigDecimal codesetId)
    {
        this.codesetId = codesetId;
    }

    public String getCodeset()
    {
        return codeset;
    }

    public void setCodeset(String codeset)
    {
        this.codeset = codeset;
    }

    public String getLookupTable()
    {
        return lookupTable;
    }

    public void setLookupTable(String lookupTable)
    {
        this.lookupTable = lookupTable;
    }

    public String getKeyField()
    {
        return keyField;
    }

    public void setKeyField(String keyField)
    {
        this.keyField = keyField;
    }

    @Override
    public int hashCode()
    {
        int hash = 0;
        hash += (codesetId != null ? codesetId.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object)
    {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof Codeset)) {
            return false;
        }
        Codeset other = (Codeset) object;
        if ((this.codesetId == null && other.codesetId != null) || (this.codesetId != null && !this.codesetId.equals(other.codesetId))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString()
    {
        return "ext.domain.nhin.adapter.terminology.Codeset[codesetId=" + codesetId + "]";
    }

}
