/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package ext.domain.nhin.adapter.facilitymanager;

import java.util.*;
import java.util.logging.*;

import javax.annotation.*;
import javax.ejb.*;
import javax.persistence.*;
import javax.transaction.*;

import ext.domain.nhin.adapter.utils.*;

/**
 *
 * @author David Vazquez
 */
@Stateless(name = "FacilityManager", mappedName = "FacilityManager")
public class FacilityManagerBean implements FacilityManagerRemote, FacilityManagerLocal
{
    static private final Logger logger = Logger.getLogger(FacilityManagerBean.class.getName());
    private EntityManager entityManager;

    @PersistenceContext
    public void setEntityManager(EntityManager entityManager)
    {
        this.entityManager = entityManager;
    }

    public List<Facility> getAllFacilities()
    {
        Query query = entityManager.createNamedQuery("Facility.findAll");
        return query.getResultList();
    }

    public List<Facility> getAllFacilities(String[] excludeFacilityNumbers)
    {
        StringBuilder whereClause = new StringBuilder();
        Map<String, Object> setParams = new HashMap<String, Object>();

        if (!NullChecker.isNullOrEmpty(excludeFacilityNumbers)) {
            whereClause.append(" WHERE f.facilityNumber NOT IN (:facility0");
            setParams.put("facility0", excludeFacilityNumbers[0]);

            for (int i = 1; i < excludeFacilityNumbers.length; ++i) {
                whereClause.append(",:facility").append(i);
                setParams.put("facility" + i, excludeFacilityNumbers[i]);
            }

            whereClause.append(")");
        }

        Query query = entityManager.createQuery("SELECT f from Facility f" + whereClause.toString());

        for (Map.Entry<String, Object> e : setParams.entrySet()) {
            query.setParameter(e.getKey(), e.getValue());
        }

        return query.getResultList();
    }

    public Facility getFacilityByFacilityNumber(String facilityNumber)
    {
        Query query = entityManager.createNamedQuery("Facility.findByFacilityNumber");
        query.setParameter("facilityNumber", facilityNumber);
        return getSingleFacilityResult(query);
    }

    public Facility getFacilityByHomeCommunityId(String oid)
    {
        Query query = entityManager.createNamedQuery("Facility.findByHomeCommunityId");
        query.setParameter("homeCommunityId", oid);
        return getSingleFacilityResult(query);
    }

    public Facility getFacilityByFullHomeCommunityId(String fullHomeCommunityId)
    {
        Query query = entityManager.createNamedQuery("Facility.findByFullHomeCommunityId");
        query.setParameter("fullHomeCommunityId", fullHomeCommunityId);
        return getSingleFacilityResult(query);
    }

    public List<Facility> getFacilitiesContainingAssigningAuthority(String assigningAuthorityOID)
    {
        List<Facility> ret = new ArrayList<Facility>();
        Query query = entityManager.createNamedQuery("AssigningAuthority.findByAssigningAuthorityOid");
        query.setParameter("assigningAuthorityOid", assigningAuthorityOID);
        AssigningAuthority result = getSingleAAResult(query);
        if (result != null) {
            for (FacilityToAA f2aa : result.getFacilitiesToAAs()) {
                ret.add(f2aa.getFacility());
            }
        }
        return ret;
    }

    public void addAssigningAuthorityToFacility(String homeCommunityId, String assigningAuthorityOid, String assigningAuthorityName)
    {
        logger.entering(getClass().getName(), "addAssigningAuthorityToFacility");

        Query query = entityManager.createNamedQuery("Facility.findByHomeCommunityId");
        query.setParameter("homeCommunityId", homeCommunityId);
        Facility facility = getSingleFacilityResult(query);

        if (facility != null) {
            FacilityToAA facilityToAA = null;
            if (!NullChecker.isNullOrEmpty(facility.getFacilitiesToAAs())) {
                for (FacilityToAA f2aa : facility.getFacilitiesToAAs()) {
                    if (f2aa.getAssigningAuthority().getAssigningAuthorityOid().equals(assigningAuthorityOid)) {
                        facilityToAA = f2aa;
                        break;
                    }
                }
            }

            if (facilityToAA == null) {
                Query aaQuery = entityManager.createNamedQuery("AssigningAuthority.findByAssigningAuthorityOid");
                aaQuery.setParameter("assigningAuthorityOid", assigningAuthorityOid);
                AssigningAuthority assigningAuthority = getSingleAAResult(aaQuery);

                if (assigningAuthority == null) {
                    assigningAuthority = new AssigningAuthority();
                    assigningAuthority.setAssigningAuthorityOid(assigningAuthorityOid);
                    assigningAuthority.setAssigningAuthorityName(assigningAuthorityName);
                    assigningAuthority.setFacilitiesToAAs(new ArrayList<FacilityToAA>());
                    entityManager.persist(assigningAuthority);
                }

                facilityToAA = new FacilityToAA();
                facilityToAA.setAssigningAuthority(assigningAuthority);
                facilityToAA.setFacility(facility);
                facility.getFacilitiesToAAs().add(facilityToAA);
                assigningAuthority.getFacilitiesToAAs().add(facilityToAA);
                entityManager.persist(facilityToAA);
            }
        }
        
        logger.exiting(getClass().getName(), "addAssigningAuthorityToFacility");
    }

    private Facility getSingleFacilityResult(Query query)
    {
        Facility ret;

        try {
            ret = (Facility)query.getSingleResult();
        }
        catch (NoResultException nre) {
            ret = null;
        }

        return ret;
    }

    private AssigningAuthority getSingleAAResult(Query query)
    {
        AssigningAuthority ret;

        try {
            ret = (AssigningAuthority)query.getSingleResult();
        }
        catch (NoResultException nre) {
            ret = null;
        }

        return ret;
    }
}
