/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ext.domain.nhin.adapter.documentrepositorycleanup;

import java.util.*;

import javax.annotation.*;
import javax.ejb.*;
import javax.ejb.Timer;

import ext.domain.nhin.adapter.documentrepository.*;
import ext.domain.nhin.adapter.propertylookup.*;

/**
 *
 * @author David Vazquez
 */
@Stateless(name = "DocumentRepositoryCleanup", mappedName = "DocumentRepositoryCleanup")
public class DocumentRepositoryCleanupBean implements DocumentRepositoryCleanupRemote, DocumentRepositoryCleanupLocal
{
    private DocumentRepository documentRepository;
    private PropertyLookup propertyLookup;
    private SessionContext ctx;

    @EJB(beanInterface = DocumentRepositoryLocal.class)
    public void setDocumentRepository(DocumentRepository documentRepository)
    {
        this.documentRepository = documentRepository;
    }

    @EJB(beanInterface = PropertyLookupLocal.class)
    public void setPropertyLookup(PropertyLookup propertyLookup)
    {
        this.propertyLookup = propertyLookup;
    }

    @Resource
    public void setSessionContext(SessionContext ctx)
    {
        this.ctx = ctx;
    }

    public void startCleanupService()
    {
        TimerService timerService = ctx.getTimerService();
        String documentCacheCleanupInterval = propertyLookup.getProperty("documentCacheCleanupInterval");
        long dcci = Long.parseLong(documentCacheCleanupInterval);
        String documentCacheRetentionTime = propertyLookup.getProperty("documentCacheRetentionTime");
        Long dcrt = Long.parseLong(documentCacheRetentionTime);

        timerService.createTimer(dcci, dcci, dcrt);
    }

    public void stopCleanupService()
    {
        TimerService timerService = ctx.getTimerService();
        Collection<Timer> timers = timerService.getTimers();
        for (Timer timer : timers) {
            timer.cancel();
        }
    }

    public void cleanup(long documentCacheRetentionTime)
    {
        documentRepository.deleteDocumentsNotAccessed(documentCacheRetentionTime);
    }

    @Timeout
    public void onTimeout(Timer timer)
    {
        Long documentCacheRetentionTime = (Long)timer.getInfo();
        cleanup(documentCacheRetentionTime);
    }
}
