/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package ext.domain.nhin.adapter.documentrepository;

import java.util.*;
import java.util.logging.*;

import javax.ejb.*;
import javax.persistence.*;

/**
 *
 * @author David Vazquez
 */
@Stateless(name = "DocumentRepository", mappedName = "DocumentRepository")
public class DocumentRepositoryBean implements DocumentRepositoryLocal, DocumentRepositoryRemote
{
    static private final Logger logger = Logger.getLogger(DocumentRepositoryBean.class.getName());
    private EntityManager entityManager;

    @PersistenceContext
    public void setEntityManager(EntityManager entityManager)
    {
        this.entityManager = entityManager;
    }

    public void deleteDocument(Document document)
    {
        entityManager.remove(document);
    }

    public Document getDocumentByDocumentId(Long documentId)
    {
        logger.entering(getClass().getName(), "getDocumentByDocumentId");

        Document ret = null;

        try {
            ret = entityManager.find(Document.class, documentId);
        }
        finally {
            logger.exiting(getClass().getName(), "getDocumentByDocumentId", ret);
        }

        return ret;
    }

    public Document getDocumentByDocumentUniqueId(String documentUniqueId)
    {
        logger.entering(getClass().getName(), "getDocumentByDocumentUniqueId");

        Document ret = null;

        try {
            Query query = entityManager.createNamedQuery("Document.findByDocumentUniqueId");
            query.setParameter("documentUniqueId", documentUniqueId);

            ret = getSingleResult(query);
        }
        finally {
            logger.exiting(getClass().getName(), "getDocumentByDocumentUniqueId", ret);
        }

        return ret;
    }

    public List getDocumentsByDocumentUniqueId(List<String> documentUniqueIds)
    {
        logger.entering(getClass().getName(), "getDocumentsByDocumentUniqueId");

        List<Document> ret = null;

        try {
            StringBuffer queryString = new StringBuffer();
            for (String documentUniqueId : documentUniqueIds) {
                if (queryString.length() > 0) {
                    queryString.append(',');
                }
                queryString.append('\'').append(documentUniqueId).append('\'');
            }

            Query query = entityManager.createQuery("select d from Document d where d.documentUniqueId in (" + queryString + ")");
            ret = query.getResultList();
        }
        finally {
            logger.exiting(getClass().getName(), "getDocumentsByDocumentUniqueId", ret);
        }

        return ret;
    }

    public void storeDocument(Document document)
    {
        logger.entering(getClass().getName(), "storeDocument");
        try {
            if (document.getDocumentId() == null) {
                entityManager.persist(document);
            }
            else {
                entityManager.merge(document);
            }
        }
        finally {
            logger.exiting(getClass().getName(), "storeDocument");
        }
    }

    public void deleteDocumentsNotAccessed(long documentRetentionTime)
    {
        logger.entering(getClass().getName(), "deleteDocumentsNotAccessed");

        try {
            Date documentRetentionTimeAgo = new Date(System.currentTimeMillis() - documentRetentionTime);
            Query query = entityManager.createQuery("delete from Document d where d.lastAccessedTime is null and d.creationTime < :documentRetentionTimeAgo");
            query.setParameter("documentRetentionTimeAgo", documentRetentionTimeAgo);
            int deletedDocuments = query.executeUpdate();

            logger.finest("Deleted " + deletedDocuments + " document(s) from repository because they were not accessed within " + documentRetentionTime + "ms of creation.");
        }
        finally {
            logger.exiting(getClass().getName(), "deleteDocumentsNotAccessed");
        }
    }

    private Document getSingleResult(Query query)
    {
        Document ret;

        try {
            ret = (Document)query.getSingleResult();
        }
        catch (NoResultException nre) {
            ret = null;
        }

        return ret;
    }
}
