/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ext.domain.nhin.adapter.datamanager.translators;

import java.util.*;

import javax.naming.*;

import ext.domain.nhin.adapter.datamanager.*;
import ext.domain.nhin.adapter.datamanager.Reference;
import ext.domain.nhin.adapter.terminology.*;
import ext.domain.nhin.adapter.utils.config.*;

/**
 *
 * @author David Vazquez
 */
public class TerminologyLookupEJBDataTranslator implements DataTranslator
{
    private InitialContext context;

    public Object translate(Object input, Object result, Reference translationType, DataQuery dataQuery)
    {
        Object ret;
        try {
            String codeset = translationType.getProperty("codeset");
            String field = translationType.getProperty("field");
            ret = getTerminology(translationType).lookup(codeset, (String)input, field);
        }
        catch (Throwable t) {
            throw new DataManagerException("An error occurred looking up term.", t);
        }

        return ret;
    }

    private Terminology getTerminology(Reference translationType)
        throws Exception
    {
        if (context == null) {
            context = getInitialContext(translationType);
        }

        Terminology ret = (Terminology)context.lookup("Terminology#ext.domain.nhin.adapter.terminology.TerminologyRemote");
        return ret;
    }

    private InitialContext getInitialContext(Reference translationType) throws Exception
    {
        InitialContext ret;

        PropertiesType propertiesType = translationType.getProperties("initialContextProperties");
        if (propertiesType != null) {
            Properties properties = PropertyTypeUtils.toProperties(propertiesType);
            ret = new InitialContext(properties);
        }
        else {
            ret = new InitialContext();
        }

        return ret;
    }
}
