/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ext.domain.nhin.adapter.datamanager.translators;

import java.net.*;

import javax.xml.namespace.QName;

import ext.domain.nhin.adapter.datamanager.*;
import ext.domain.nhin.adapter.terminology.*;


/**
 *
 * @author David Vazquez
 */
public class TerminologyLookupDataTranslator implements DataTranslator
{
    private TerminologyService terminologyService;
    
    public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery)
    {
        Object ret;
        try {
            String codeset = translation.getProperty("codeset");
            String field = translation.getProperty("field");
            TerminologyPortType t = getPort(translation.getProperty("terminologyServiceWSDL"));;
            ret = t.lookup(codeset, (String)input, field);
        }
        catch (Throwable t) {
            throw new DataManagerException("An error occurred looking up term.", t);
        }

        return ret;
    }

    private synchronized TerminologyPortType getPort(String terminologyServiceWSDL)
        throws Exception
    {
        if (terminologyService == null) {
            terminologyService = new TerminologyService(new URL(terminologyServiceWSDL),
            											new QName("urn:gov:va:med:nhin:adapter:terminology", "TerminologyService"));
        }
        return terminologyService.getTerminologyPort();
    }
}