/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ext.domain.nhin.adapter.datamanager.translators;

import java.net.*;

import javax.xml.namespace.*;

import ext.domain.nhin.adapter.datamanager.*;
import ext.domain.nhin.adapter.terminology.*;

/**
 *
 * @author David Vazquez
 */
public class TerminologyDataTranslator implements DataTranslator
{
    private TerminologyService terminologyService;

    public Object translate(Object input, Object result, Reference translationType, DataQuery dataQuery)
    {
        Object ret = input;

        try {
            String sourceCodeset = translationType.getProperty("sourceCodeset");
            String targetCodeset = translationType.getProperty("targetCodeset");
            String field = translationType.getProperty("field");
            TerminologyPortType t = getPort(translationType.getProperty("terminologyServiceWSDL"));
            ret = t.translate(sourceCodeset, (String)input, targetCodeset, field);
        }
        catch (Throwable t) {
            throw new DataManagerException("An error occured when translating.", t);
        }
        
        return ret;
    }

    private synchronized TerminologyPortType getPort(String terminologyServiceWSDL)
        throws Exception
    {
        if (terminologyService == null) {
            terminologyService = new TerminologyService(new URL(terminologyServiceWSDL),
            											new QName("urn:gov:va:med:nhin:adapter:terminology", "TerminologyService"));
        }
        return terminologyService.getTerminologyPort();
    }
}
