/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package ext.domain.nhin.adapter.cache;

import java.io.*;
import java.util.*;
import java.util.logging.*;

import javax.annotation.*;
import javax.ejb.*;
import javax.persistence.*;
import javax.transaction.*;

import ext.domain.nhin.adapter.utils.*;

/**
 *
 * @author David Vazquez
 */
@Stateless(name = "CacheManager", mappedName = "CacheManager")
@TransactionManagement(value=TransactionManagementType.BEAN)
public class CacheManagerBean implements CacheManagerRemote, CacheManagerLocal
{
    static private final Logger logger = Logger.getLogger(CacheManagerBean.class.getName());

    private EntityManager entityManager;
    private SessionContext context;
    
    @PersistenceContext
    public void setEntityManager(EntityManager entityManager)
    {
        this.entityManager = entityManager;
    }
    
    @Resource
    public void setSessionContext(SessionContext context)
    {
        this.context = context;
    }
    
    public Serializable get(String key)
    {
        logger.entering(getClass().getName(), "get");

        Serializable ret = null;
        String hash = SHA1Hash.getHash(key.getBytes());
        Query query = entityManager.createNamedQuery("Cache.findByHash");
        query.setParameter("hash", hash);
        List<Cache> results = query.getResultList();
        if (!NullChecker.isNullOrEmpty(results)) {
            ret = results.get(0).getData();
        }

        logger.exiting(getClass().getName(), "get");

        return ret;
    }

    public void put(String key, Serializable data)
    {
        logger.entering(getClass().getName(), "put");

        UserTransaction ut = context.getUserTransaction();
        
        try {
            ut.begin();
        
            String hash = SHA1Hash.getHash(key.getBytes());
            Cache cache = new Cache();
            cache.setHash(hash);
            cache.setData(data);
            entityManager.persist(cache);

            ut.commit();
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Error occurred. Rolling back transaction.  See nested exception.", t);
            try {
                ut.rollback();
            }
            catch (Throwable t2) {
                logger.log(Level.WARNING, "Error rolling back transaction.", t2);
            }
        }
        finally {
            logger.exiting(getClass().getName(), "put");
        }
    }
}
