/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ext.domain.nhin.adapter.audit;

import java.io.Serializable;
import java.util.Collection;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;

/**
 *
 * @author David Vazquez
 */
@Entity
@Table(name = "OPTOUT_REASONS")
@NamedQueries({@NamedQuery(name = "OptoutReason.findAll", query = "SELECT o FROM OptoutReason o"), @NamedQuery(name = "OptoutReason.findByOptoutReasonId", query = "SELECT o FROM OptoutReason o WHERE o.optoutReasonId = :optoutReasonId"), @NamedQuery(name = "OptoutReason.findByText", query = "SELECT o FROM OptoutReason o WHERE o.text = :text")})
public class OptoutReason implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Basic(optional = false)
    @Column(name = "OPTOUT_REASON_ID")
    private Long optoutReasonId;
    @Basic(optional = false)
    @Column(name = "TEXT")
    private String text;
    @OneToMany(mappedBy = "optoutReason")
    private Collection<Audit> audits;

    public OptoutReason()
    {
    }

    public OptoutReason(Long optoutReasonId)
    {
        this.optoutReasonId = optoutReasonId;
    }

    public OptoutReason(Long optoutReasonId, String text)
    {
        this.optoutReasonId = optoutReasonId;
        this.text = text;
    }

    public Long getOptoutReasonId()
    {
        return optoutReasonId;
    }

    public void setOptoutReasonId(Long optoutReasonId)
    {
        this.optoutReasonId = optoutReasonId;
    }

    public String getText()
    {
        return text;
    }

    public void setText(String text)
    {
        this.text = text;
    }

    public Collection<Audit> getAudits()
    {
        return audits;
    }

    public void setAudits(Collection<Audit> audits)
    {
        this.audits = audits;
    }

    @Override
    public int hashCode()
    {
        int hash = 0;
        hash += (optoutReasonId != null ? optoutReasonId.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object)
    {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof OptoutReason)) {
            return false;
        }
        OptoutReason other = (OptoutReason) object;
        if ((this.optoutReasonId == null && other.optoutReasonId != null) || (this.optoutReasonId != null && !this.optoutReasonId.equals(other.optoutReasonId))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString()
    {
        return "ext.domain.nhin.adapter.permission.data.OptoutReason[optoutReasonId=" + optoutReasonId + "]";
    }

}
