/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package ext.domain.nhin.adapter.audit;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 *
 * @author VHAISBVAZQUD
 */
@Entity
@Table(name = "AUDITS_REPORT")
@NamedQueries({
    @NamedQuery(name = "AuditsReport.findAll", query = "SELECT a FROM AuditsReport a")})
public class AuditsReport implements Serializable
{
    private static final long serialVersionUID = 1L;
    @Id
    @Basic(optional = false)
    @Column(name = "AUDIT_ID")
    private BigInteger auditId;
    @Basic(optional = false)
    @Column(name = "ACTION_NAME")
    private String actionName;
    @Column(name = "USER_ID")
    private String userId;
    @Column(name = "ORGANIZATION_ID")
    private String organizationId;
    @Column(name = "PATIENT_ID")
    private String patientId;
    @Column(name = "PURPOSE_FOR_USE")
    private String purposeForUse;
    @Column(name = "DOCUMENT_ID")
    private String documentId;
    @Basic(optional = false)
    @Column(name = "AUDIT_TIME")
    @Temporal(TemporalType.TIMESTAMP)
    private Date auditTime;
    @Column(name = "OPTOUT_REASON_ID")
    private BigInteger optoutReasonId;
    @Column(name = "REMOTE_ORGANIZATION_ID")
    private String remoteOrganizationId;
    @Column(name = "REMOTE_DOC_REPOSITORY_ID")
    private String remoteDocRepositoryId;
    @Column(name = "REMOTE_DOC_ID")
    private String remoteDocId;
    @Column(name = "DETAILS")
    private String details;
    @Column(name = "PATIENT_LAST_NAME")
    private String patientLastName;
    @Column(name = "PATIENT_GIVEN_NAME")
    private String patientGivenName;
    @Column(name = "USER_NAME")
    private String userName;
    @Column(name = "PATIENT_FACILITY_NUMBER")
    private String patientFacilityNumber;
    @Column(name = "PATIENT_SSN")
    private String patientSSN;
    @Column(name = "PATIENT_FACILITY_NAME")
    private String patientFacilityName;
    @Column(name = "USER_FACILITY_NUMBER")
    private String userFacilityNumber;
    @Column(name = "USER_FACILITY_NAME")
    private String userFacilityName;
    @Column(name = "USER_ROLE")
    private String userRole;
    @Column(name = "ORGANIZATION_NAME")
    private String organizationName;
    @Column(name = "REMOTE_ORGANIZATION_NAME")
    private String remoteOrganizationName;
    @Column(name = "OPTOUT_REASON_TEXT")
    private String optOutReasonText;
    @Column(name = "DOCUMENT_TITLE")
    private String documentTitle;
    @Column(name = "DOCUMENT_SOURCE_PATIENT_ID")
    private String documentSourcePatientId;

    public AuditsReport()
    {
    }

    public AuditsReport(BigInteger optoutReasonId)
    {
        this.optoutReasonId = optoutReasonId;
    }

    public AuditsReport(BigInteger optoutReasonId, String actionName, Date auditTime)
    {
        this.optoutReasonId = optoutReasonId;
        this.actionName = actionName;
        this.auditTime = auditTime;
    }

    public BigInteger getAuditId()
    {
        return auditId;
    }

    public void setAuditId(BigInteger auditId)
    {
        this.auditId = auditId;
    }

    public String getActionName()
    {
        return actionName;
    }

    public void setActionName(String actionName)
    {
        this.actionName = actionName;
    }

    public String getUserId()
    {
        return userId;
    }

    public void setUserId(String userId)
    {
        this.userId = userId;
    }

    public String getOrganizationId()
    {
        return organizationId;
    }

    public void setOrganizationId(String organizationId)
    {
        this.organizationId = organizationId;
    }

    public String getPatientId()
    {
        return patientId;
    }

    public void setPatientId(String patientId)
    {
        this.patientId = patientId;
    }

    public String getPurposeForUse()
    {
        return purposeForUse;
    }

    public void setPurposeForUse(String purposeForUse)
    {
        this.purposeForUse = purposeForUse;
    }

    public String getDocumentId()
    {
        return documentId;
    }

    public void setDocumentId(String documentId)
    {
        this.documentId = documentId;
    }

    public Date getAuditTime()
    {
        return auditTime;
    }

    public void setAuditTime(Date auditTime)
    {
        this.auditTime = auditTime;
    }

    public BigInteger getOptoutReasonId()
    {
        return optoutReasonId;
    }

    public void setOptoutReasonId(BigInteger optoutReasonId)
    {
        this.optoutReasonId = optoutReasonId;
    }

    public String getRemoteOrganizationId()
    {
        return remoteOrganizationId;
    }

    public void setRemoteOrganizationId(String remoteOrganizationId)
    {
        this.remoteOrganizationId = remoteOrganizationId;
    }

    public String getRemoteDocRepositoryId()
    {
        return remoteDocRepositoryId;
    }

    public void setRemoteDocRepositoryId(String remoteDocRepositoryId)
    {
        this.remoteDocRepositoryId = remoteDocRepositoryId;
    }

    public String getRemoteDocId()
    {
        return remoteDocId;
    }

    public void setRemoteDocId(String remoteDocId)
    {
        this.remoteDocId = remoteDocId;
    }

    public String getDetails()
    {
        return details;
    }

    public void setDetails(String details)
    {
        this.details = details;
    }

    public String getPatientLastName()
    {
        return patientLastName;
    }

    public void setPatientLastName(String patientLastName)
    {
        this.patientLastName = patientLastName;
    }

    public String getPatientGivenName()
    {
        return patientGivenName;
    }

    public void setPatientGivenName(String patientGivenName)
    {
        this.patientGivenName = patientGivenName;
    }

    public String getUserName()
    {
        return userName;
    }

    public void setUserName(String userName)
    {
        this.userName = userName;
    }

    public String getPatientFacilityNumber()
    {
        return patientFacilityNumber;
    }

    public void setPatientFacilityNumber(String patientFacilityNumber)
    {
        this.patientFacilityNumber = patientFacilityNumber;
    }

    public String getPatientSSN()
    {
        return patientSSN;
    }

    public void setPatientSSN(String patientSSN)
    {
        this.patientSSN = patientSSN;
    }

    public String getPatientFacilityName()
    {
        return patientFacilityName;
    }

    public void setPatientFacilityName(String patientFacilityName)
    {
        this.patientFacilityName = patientFacilityName;
    }

    public String getUserFacilityNumber()
    {
        return userFacilityNumber;
    }

    public void setUserFacilityNumber(String userFacilityNumber)
    {
        this.userFacilityNumber = userFacilityNumber;
    }

    public String getUserFacilityName()
    {
        return userFacilityName;
    }

    public void setUserFacilityName(String userFacilityName)
    {
        this.userFacilityName = userFacilityName;
    }

    public String getUserRole()
    {
        return userRole;
    }

    public void setUserRole(String userRole)
    {
        this.userRole = userRole;
    }

    
    public String getOrganizationName()
    {
        return organizationName;
    }

    public void setOrganizationName(String organizationName)
    {
        this.organizationName = organizationName;
    }

    public String getRemoteOrganizationName()
    {
        return remoteOrganizationName;
    }

    public void setRemoteOrganizationName(String remoteOrganizationName)
    {
        this.remoteOrganizationName = remoteOrganizationName;
    }

    public String getOptOutReasonText()
    {
        return optOutReasonText;
    }

    public void setOptOutReasonText(String text)
    {
        this.optOutReasonText = text;
    }

    public String getDocumentTitle()
    {
        return documentTitle;
    }

    public void setDocumentTitle(String title)
    {
        this.documentTitle = title;
    }

    public String getDocumentSourcePatientId()
    {
        return documentSourcePatientId;
    }

    public void setDocumentSourcePatientId(String sourcePatientId)
    {
        this.documentSourcePatientId = sourcePatientId;
    }

    @Override
    public int hashCode()
    {
        int hash = 0;
        hash += (optoutReasonId != null ? optoutReasonId.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object)
    {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof AuditsReport)) {
            return false;
        }
        AuditsReport other = (AuditsReport)object;
        if ((this.optoutReasonId == null && other.optoutReasonId != null) || (this.optoutReasonId != null && !this.optoutReasonId.equals(other.optoutReasonId))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString()
    {
        return "ext.domain.nhin.adapter.audit.AuditsReport[ optoutReasonId=" + optoutReasonId + " ]";
    }
    
}
