/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package ext.domain.nhin.adapter.vistalinksetup;

import java.io.*;
import java.util.*;
import java.util.regex.*;

import javax.xml.parsers.*;
import javax.xml.xpath.*;

import org.w3c.dom.*;

/**
 *
 * @author VHAISBVAZQUD
 */
public class VistALinkSetup
{
    /**
     * @param args the command line arguments
     */
    static public void main(String[] args)
    {
        try {
            Properties properties = new Properties();
            properties.load(new FileReader("config/VistALinkSetup.properties"));

            String vistALinkConnectorConfigFileName = properties.getProperty("vistALinkConnectorConfigFileName");
            String raTemplateDir = properties.getProperty("raTemplateDir");
            String raStageDir = properties.getProperty("raStageDir");

            String[] connectorJNDINames = getConnectorJNDINames(vistALinkConnectorConfigFileName);

            for (String connectorJNDIName : connectorJNDINames) {
                String connectorName = makeConnectorName(connectorJNDIName);
                copyTemplateToStage(raTemplateDir, raStageDir, connectorName);
                fixConfiguration(raStageDir, connectorName, connectorJNDIName);
            }
        }
        catch (Throwable t) {
            System.out.println("Unrecoverable Error!");
            t.printStackTrace();
        }
    }

    static private String[] getConnectorJNDINames(String connectorConfigFileName)
            throws Exception
    {
        List<String> ret = new ArrayList<String>();

        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(connectorConfigFileName);

        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        NodeList nodeList = (NodeList)xpath.evaluate("connectors/connector/@jndiName", doc, XPathConstants.NODESET);

        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            ret.add(node.getNodeValue());
        }

        return ret.toArray(new String[]{});
    }

    static private String makeConnectorName(String connectorJNDIName)
    {
        return connectorJNDIName.replace("/", "");
    }

    static private void copyTemplateToStage(String templateDir, String stageDir, String connectorName)
            throws Exception
    {
        File source = new File(templateDir);
        File dest = new File(stageDir + File.separator + connectorName);
        File stage = new File(stageDir);
        
        if (!stage.exists()) {
            stage.mkdir();
        }
        
        copyDirectory(source, dest);
    }

    static private void copyDirectory(File sourceLocation, File targetLocation)
            throws IOException
    {

        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists()) {
                targetLocation.mkdir();
            }

            String[] children = sourceLocation.list();
            for (int i = 0; i < children.length; i++) {
                copyDirectory(new File(sourceLocation, children[i]),
                              new File(targetLocation, children[i]));
            }
        }
        else {
            InputStream in = new FileInputStream(sourceLocation);
            OutputStream out = new FileOutputStream(targetLocation);

            // Copy the bits from instream to outstream
            byte[] buf = new byte[1024];
            int len;
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            in.close();
            out.close();
        }
    }
    
    static private void fixConfiguration(String stageDir, String connectorName, String jndiName)
            throws Exception
    {
        File configDir = new File(stageDir + File.separator + connectorName + File.separator + "META-INF");
        File configFile = new File(configDir, "weblogic-ra.xml");
        File tempFile = File.createTempFile("out", ".xml", configDir);
        
        BufferedReader in = new BufferedReader(new FileReader(configFile));
        BufferedWriter out = new BufferedWriter(new FileWriter(tempFile));
        
        while (in.ready()) {
            String line = in.readLine();
            String replacement = line.replaceAll("\\$\\{vlj\\.jndi\\.name\\}", jndiName);
            out.write(replacement);
            out.write("\n");
        }
        
        in.close();
        out.close();
        
        configFile.delete();
        tempFile.renameTo(configFile);
    }
}
