/*
   This script creates the Open Infobutton database for Oracle
   Pre-requisites:
   - Create or identify the tablespaces you will use
   - login to SQL tool as DBA or privileged user
 */

CREATE ROLE "OIB_ROLE" NOT IDENTIFIED;
GRANT CREATE TABLE TO "OIB_ROLE";
GRANT CREATE VIEW TO "OIB_ROLE";
GRANT UNLIMITED TABLESPACE TO "OIB_ROLE";
 
create user oib identified by "your_password"
default tablespace your_tablespace
temporary tablespace your_temp_tablespace
quota unlimited on your_tablespace
account unlock;

grant connect to OIB;
grant OIB_ROLE to OIB;

CREATE TABLE "OIB"."OIB_APP_PROPERTY" 
(	"APP_PROPERTY_ID" NUMBER, 
	"PROP_GROUP_CD" VARCHAR2(50 BYTE), 
	"PROP_NAME" VARCHAR2(100 BYTE), 
	"PROP_VALUE" VARCHAR2(1000 BYTE), 
	 PRIMARY KEY ("APP_PROPERTY_ID")
);

CREATE TABLE "OIB"."OIB_ASSET" 
(	"ASSET_ID" NUMBER, 
	"NAMESPACE_CD" VARCHAR2(100 BYTE), 
	"DISPLAY_NAME" VARCHAR2(255 BYTE), 
	"LAST_UPDATE_DTS" DATE, 
	"ASSET_URL" VARCHAR2(1000 BYTE), 
	"ASSET_MIME_TYPE" VARCHAR2(50 BYTE), 
	 PRIMARY KEY ("ASSET_ID")
);

CREATE TABLE "OIB"."OIB_ASSET_PROPERTY" 
(	"ASSET_PROPERTY_ID" NUMBER(*,0) NOT NULL ENABLE, 
	"ASSET_ID" NUMBER NOT NULL ENABLE, 
	"PROP_GROUP_NUM" NUMBER, 
	"PROP_NAME" VARCHAR2(100 BYTE) NOT NULL ENABLE, 
	"PROP_TYPE_CD" VARCHAR2(20 BYTE) NOT NULL ENABLE, 
	"CODE" VARCHAR2(100 BYTE), 
	"CODE_SYSTEM" VARCHAR2(100 BYTE), 
	"DISPLAY_NAME" VARCHAR2(1000 BYTE), 
	"PROP_VALUE" VARCHAR2(1000 BYTE), 
	"GENERATED_BY_CD" VARCHAR2(50 BYTE) NOT NULL ENABLE, 
	 CONSTRAINT "OIB_ASSET_PROPERTY_PK" PRIMARY KEY ("ASSET_PROPERTY_ID")
);

ALTER TABLE OIB_ASSET_PROPERTY
ADD CONSTRAINT OIB_ASSET_PROPERTY_UK1 UNIQUE (
  ASSET_ID 
, PROP_GROUP_NUM 
, PROP_NAME 
) ENABLE;

ALTER TABLE OIB_ASSET_PROPERTY
ADD CONSTRAINT OIB_ASSET_PROPERTY_OIB_AS_FK1 FOREIGN KEY
(ASSET_ID) REFERENCES OIB_ASSET (ASSET_ID) ENABLE;


CREATE TABLE "OIB"."OIB_REQUEST_PARAMETER" 
(	"REQUEST_PARAMETER_ID" NUMBER(*,0) NOT NULL ENABLE, 
	"PARAMETER_NAME" VARCHAR2(100 BYTE), 
	"PARAMETER_DSC" VARCHAR2(1000 BYTE), 
	"CARDINALITY_MIN" NUMBER, 
	"CARDINALITY_MAX" NUMBER, 
	"PARAMETER_ROOT" VARCHAR2(50 BYTE), 
	"TYPE_CD" VARCHAR2(20 BYTE), 
	"PARAMETER_SUFFIX" VARCHAR2(50 BYTE), 
	"VALUE_SET_ID" NUMBER, 
	 CONSTRAINT "OIB_REQUEST_PARAMETER_PK" PRIMARY KEY ("REQUEST_PARAMETER_ID")
);

CREATE TABLE "OIB"."OIB_VALUE_SET" 
(	"VALUE_SET_ID" NUMBER, 
	"VALUE_SET_TYPE_CD" VARCHAR2(50 BYTE), 
	"VALUE_SET_OID" VARCHAR2(100 BYTE), 
	"VALUE_SET_DISPLAY_NAME" VARCHAR2(255 BYTE), 
	"VALUE_SET_URI" VARCHAR2(255 BYTE), 
	 PRIMARY KEY ("VALUE_SET_ID")
);

CREATE TABLE "OIB"."OIB_VALUE_SET_CODE" 
(	"VALUE_SET_CODE_ID" NUMBER, 
	"VALUE_SET_ID" NUMBER, 
	"CODE" VARCHAR2(50 BYTE), 
	"CODE_SYSTEM_OID" VARCHAR2(100 BYTE), 
	"CODE_DISPLAY_NAME" VARCHAR2(255 BYTE), 
	"LIST_ORDER" NUMBER, 
	"PARENT_VALUE_SET_CODE_ID" NUMBER, 
	"CODE_URI" VARCHAR2(255 BYTE), 
	 PRIMARY KEY ("VALUE_SET_CODE_ID")
);

ALTER TABLE OIB_VALUE_SET_CODE ADD CONSTRAINT OIB_VALUE_SET_CODE_FK1 
  FOREIGN KEY (VALUE_SET_ID) REFERENCES OIB_VALUE_SET (VALUE_SET_ID) ENABLE;

ALTER TABLE OIB_VALUE_SET_CODE ADD CONSTRAINT OIB_VALUE_SET_CODE_OIB_VA_FK1 
  FOREIGN KEY (PARENT_VALUE_SET_CODE_ID) REFERENCES OIB_VALUE_SET_CODE (VALUE_SET_CODE_ID) ENABLE;
