//---------------------------------------------------------------------------
// Copyright 2013 PwC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//---------------------------------------------------------------------------

package com.pwc.us.rgi.util.filevisitor;

import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;

import com.pwc.us.rgi.struct.Filter;

public class NameFilteredFileVisitor extends SimpleFileVisitor<Path> {
	private List<Path> store = new ArrayList<Path>();
	private Filter<String> nameFilter;
	
	public NameFilteredFileVisitor(Filter<String> nameFilter) {
		this.nameFilter = nameFilter;
	}
	
	@Override
	public FileVisitResult visitFile(Path path, BasicFileAttributes attr) {
		if (attr.isRegularFile()) {
			Path leaf = path.getFileName();
			if (leaf != null) {
				String name = leaf.toString();
				if (this.nameFilter.isValid(name)) {
					this.store.add(path);
				}
			}
		}	
		return FileVisitResult.CONTINUE;
	}
	
    public List<Path> getFiles() {
		return this.store;
	}
}
