//---------------------------------------------------------------------------
// Copyright 2013 PwC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//---------------------------------------------------------------------------

package com.pwc.us.rgi.parsergen.rulebased;

import java.lang.reflect.Constructor;

import com.pwc.us.rgi.parser.Adapter;
import com.pwc.us.rgi.parser.TFCopy;
import com.pwc.us.rgi.parser.Token;
import com.pwc.us.rgi.parser.TokenFactory;
import com.pwc.us.rgi.parsergen.AdapterSpecification;
import com.pwc.us.rgi.parsergen.ruledef.RuleSupplyFlag;

public class FSRCopy<T extends Token> extends FSRContainer<T> {
	private FactorySupplyRule<T> master;
	private TFCopy<T> factory;
	
	public FSRCopy(String name) {
		this.factory = new TFCopy<T>(name);
	}
	
	@Override
	public String getName() {
		return this.factory.getName();
	}
	
	@Override
	public FactorySupplyRule<T> getLeading(int level) {
		return this.master;
	}
	
	@Override
	public TokenFactory<T> getShellFactory() {
		return this.factory;
	}
	
	@Override
	public boolean update() {
		TokenFactory<T> f = this.master.getShellFactory();
		this.factory.setMaster(f);
		return true;
	}

	@Override
	public void setAdapter(AdapterSpecification<T> spec) {
		 Constructor<? extends T> constructor = spec.getTokenAdapter();
		 if (constructor != null) this.factory.setTargetType(constructor);
	}
	
	@Override
	public Adapter<T> getAdapter() {
		return this.factory;
	}

	@Override
	public void set(int index, RuleSupplyFlag flag, FactorySupplyRule<T> r) {
		if (index == 0) {
			this.master = r;
		} else {
			throw new IndexOutOfBoundsException();
		}
	}
}