XTECGLO ;FO-OAK/JLI - Global Utilities for Eclipse ;08/10/12  06:20
 ;;7.3;TOOLKIT;**101**;Apr 25, 1995;Build 30
 ;;Per VHA Directive 2004-038, this routine should not be modified
 I $T(EN^XTMUNIT)'="" D EN^XTMUNIT("ZZUTXTE1")
 Q
 ;
LIST(TMPGLOB,LINES,FROM,TO) ;This will list all the globals for a UCI/Namespace
 ; TMPGLOB = The closed global reference that will contain the globals
 ; LINES = The max number of lines to send.
 ; FROM = The Starting range
 ; TO = The ending range
 N GLOBAL,CNT,FST,FLG
 S @TMPGLOB@(0)="-1^"
 S:LINES'>0 LINES=1000
 I ^%ZOSF("OS")'["GT.M" D NONGTM(.TMPGLOB,FROM,TO)
 I ^%ZOSF("OS")["GT.M" D GTM(.TMPGLOB,FROM)
 Q
 ;
NONGTM(TMPGLOB,FROM,TO) ;
 N CNT,FLG,FST,GLOBAL
 ; if user entered name* remove *
 S:TO["*" TO=$P(TO,"*") S:FROM["*" FROM=$P(FROM,"*")
 S:$E(FROM)="^" FROM=$E(FROM,2,$L(FROM))
 S:$E(TO)="^" TO=$E(TO,2,$L(TO))
 ;
 S FROM="^"_FROM
 S:TO]"" TO="^"_TO
 S CNT=0,FST=""
 S GLOBAL=$O(^$GLOBAL(FROM),-1)
 F  S GLOBAL=$O(^$GLOBAL(GLOBAL)) Q:GLOBAL=""  Q:TO]""&(GLOBAL]TO)  Q:$E(GLOBAL,1,$L(FROM))'=FROM  D  Q:CNT=LINES
 . S CNT=CNT+1
 . I FST="" S FST=GLOBAL
 . S @TMPGLOB@(CNT)=GLOBAL
 . Q
 I CNT>0 S @TMPGLOB@(0)=CNT_FST_@TMPGLOB@(CNT)
 Q
 ;
GTM(TMPGLOB,FROM) ;
 N XTMCNT1,XTMCNT,GLOBAL,%ZG,XTMGLOB
 S GLOBAL=FROM
 S %ZG=FROM S:%ZG'["*" %ZG=%ZG_"*" D CALL^%GSEL
 S XTMGLOB="",XTMCNT=0 F  S XTMGLOB=$O(%ZG(XTMGLOB)) Q:XTMGLOB=""  S:XTMCNT=0 GLOBAL=XTMGLOB S XTMCNT=XTMCNT+1,@TMPGLOB@(XTMCNT)=XTMGLOB
 I XTMCNT>0 S @TMPGLOB@(0)=XTMCNT_GLOBAL_@TMPGLOB@(XTMCNT)
 Q
 ;
 ; JLI 101027 Previously, the List Global Nodes functionality
 ; scanned and entered in a global location in ^TMP all of the
 ; nodes that matched the request.  The first 10000 nodes of
 ; data would be sent down, and on subsequent requests the
 ; rest would be returned in 10000 node chunks until all of it
 ; was returned.
 ; Changes were added to handle only those global nodes
 ; to be returned at the current time.  This prevents the user
 ; from selecting a global such as ^TMP which would fill up all
 ; available space (and if ^TMP was chosen, this would be even
 ; worse since the nodes being recorded would add to the amount
 ; to be stored again and again).
LNODE(TMPGLOB,LINES,GLOBAL,SERCHVAL,OPTS) ;This will list a global
 ; TMPGLOB input - specifies root in which data will be returned
 ; LINES input - maximum number of global nodes to be returned
 ; GLOBAL input - text of global node to be listed
 ; SERCHVAL input - optional - specification of search data
 ;   FORMAT  NEWSTYLE^DATA_ONLY^CASE_SENSITIVE^VALUE_FOR_SEARCH
 ; OPTS input - optional - contains the last count from a previous call if this
 ;      is a continuation
 N GLOBTOT,CNT,CNTVAL,INDX,SEPRATR,MORE,DATAONLY,CASESENS,NEWSTYLE
 N GLOBLAST,NEWVERSN
 D INFO^XTMLOG("ENTERED LNODE","LINES,GLOBAL,SERCHVAL,OPTS")
 S GLOBTOT=$NA(^TMP("XTECGLO_LNODE",$J))
 S GLOBLAST=$NA(^TMP("XTECGLO_LAST",$J))
 I (GLOBAL="")!(GLOBAL="^") D  Q
 . K @TMPGLOB S @TMPGLOB@(0)="-1^NO GLOBAL NAME PASSED"
 . K @GLOBTOT,@GLOBLAST
 . Q
 S SEPRATR="~^~"
 S:LINES'>0 LINES=10000 ; Actually return twice as many lines to give LINES nodes worth
 ; new version client sends OPTS as 0^1, old client sent number of next line to start with if returning for more data
 S OPTS=$G(OPTS),NEWVERSN=+$P(OPTS,U,2) ; indicates client side is aware of new version handling
 S CNT=+OPTS
 D INFO^XTMLOG("LNODE 1","LINES,OPTS,CNT")
 S SERCHVAL=$G(SERCHVAL) S NEWSTYLE=$P(SERCHVAL,"^"),DATAONLY=$P(SERCHVAL,"^",2),CASESENS=$P(SERCHVAL,"^",3),SERCHVAL=$P(SERCHVAL,"^",4,99) I 'CASESENS S SERCHVAL=$$UP^XLFSTR(SERCHVAL)
 I 'NEWVERSN,OPTS'>0 K @GLOBTOT S CNT=$$GETDATA(GLOBTOT,GLOBAL,SERCHVAL,DATAONLY,CASESENS,SEPRATR,NEWSTYLE) D INFO^XTMLOG("BACK FROM GETDATA","CNT")
 I NEWVERSN K @GLOBTOT S CNT=$$GETDATA(GLOBTOT,GLOBAL,SERCHVAL,DATAONLY,CASESENS,SEPRATR,NEWSTYLE,LINES,NEWVERSN) D INFO^XTMLOG("BACK FROM GETDATA","CNT")
 D DEBUG^XTMLOG("LNODE 2","OPTS,GLOBTOT,GLOBAL,SERCHVAL,DATAONLY,CASESENS,SEPRATR,NEWSTYLE")
 I 'NEWVERSN,OPTS>0 S CNT=$P(@GLOBTOT@(0),SEPRATR,1,3) D INFO^XTMLOG("NO GETDATA","CNT")
 ; EACH GLOBAL NODE IS TWO ENTRIES, FIRST THE GLOBAL NODE STRING IN THE FIRST NODE, AND THEN THE VALUE OF THE GLOBAL IN THE SECOND NODE
 ; OPTS HAS NUMBER OF GLOBAL VALUES RETURNED ON PREVIOUS CALL, SO START AT NEXT ONE
 S CNTVAL=2*OPTS
 I CNT>0 D
 . I 'NEWVERSN F INDX=((2*OPTS)+1):1:(2*(LINES+OPTS)) Q:'$D(@GLOBTOT@(INDX))  S @TMPGLOB@(INDX)=@GLOBTOT@(INDX),CNTVAL=CNTVAL+1
 . I NEWVERSN F INDX=1:1 Q:'$D(@GLOBTOT@(INDX))  S @TMPGLOB@(INDX)=@GLOBTOT@(INDX),CNTVAL=CNTVAL+1
 . Q
 D INFO^XTMLOG("AFTER LOOP","INDX,CNTVAL")
 ; INDICATOR FOR WHETHER MORE DATA IS AVAILABLE
 S MORE=$S(NEWVERSN:$D(@GLOBLAST@("GLOBAL")),1:(+CNT>(CNTVAL/2)))
 S @TMPGLOB@(0)="-1"
 I CNT>0 S @GLOBTOT@(0)=CNT_SEPRATR_(CNTVAL/2)_SEPRATR_MORE,@TMPGLOB@(0)=@GLOBTOT@(0)
 D INFO^XTMLOG("LNODE - ON EXIT",$NA(@GLOBTOT@(0)))
 I NEWVERSN K @GLOBTOT
 I 'MORE!'NEWVERSN K @GLOBLAST
 Q
 ;
GETDATA(GLOBTOT,GLOBAL,SERCHVAL,DATAONLY,CASESENS,SEPRATR,NEWSTYLE,LINES,NEWVERSN) ; extracted to here from LNODE
 ; LINES input - maximum number of global lines to return
 ; ZEXCEPT: GLOBLAST ; NEWED and defined in LNODE
 N CNT,FST,LST,GLOFIN1,GLOFINAL,GLOSTART,GLOSTR,NCOMMA,DONE,I,J
 N ARRAY,PARTS,LAST,GLOBAL1,LAST1,LAST2,GLOBALA
 S LINES=$G(LINES),NEWVERSN=$G(NEWVERSN)
 S:$E(GLOBAL,1)'="^" GLOBAL="^"_GLOBAL S:$E(GLOBAL,$L(GLOBAL))="(" GLOBAL=$E(GLOBAL,1,$L(GLOBAL)-1)
 N START,FINAL,NCOMMAS,VAL1,MAXCOMMA
 S GLOSTART=$$GETLIMIT(GLOBAL,.MAXCOMMA,.ARRAY),GLOFINAL=GLOSTART
 D DEBUG^XTMLOG("GETLIMIT ARRAY:","ARRAY",1)
 S DONE=0 F I=1:1 Q:DONE  Q:'$D(ARRAY(I))  Q:ARRAY(I,1)=""  D
 . S GLOSTART=GLOSTART_$S(I>1:",",1:"")_ARRAY(I,1)
 . S J=$O(ARRAY(I,""),-1) S GLOFINAL=GLOFINAL_$S(I>1:",",1:"")_$S($D(ARRAY(I,J,1)):ARRAY(I,J,1),1:ARRAY(I,J))
 . I (J'=1)!$D(ARRAY(I,1,1)) S DONE=1
 . D DEBUG^XTMLOG("GLOSTART","I,J,GLOSTART,GLOFINAL,DONE")
 . Q
 I GLOSTART["(" S GLOSTART=GLOSTART_")" I GLOSTART["()" S GLOSTART=$P(GLOSTART,"(")
 S (FST,LAST)=""
 S CNT=0
 D DEBUG^XTMLOG("$D(@GLOSTART)","GLOSTART,GLOFINAL")
 S GLOBAL=GLOSTART
 I '$D(@GLOBLAST),$D(@GLOSTART)#2,$$CHEKGLOB(GLOBAL,MAXCOMMA,.ARRAY) D STORE(GLOSTART,GLOBTOT,.CNT,.FST,SERCHVAL,DATAONLY,CASESENS,NEWSTYLE) S GLOSTR=GLOBAL I GLOBAL["(" S NCOMMA=$L(GLOBAL,","),GLOSTR=$Q(@GLOBAL),GLOSTR=$P(GLOSTR,",",1,NCOMMA)
 S LAST1="",LAST2=""
 I NEWVERSN,$D(@GLOBLAST@("GLOBAL")) S GLOBAL=@GLOBLAST@("GLOBAL") ; on restart use last global value from previous
 F  Q:(NEWVERSN&((CNT/2)=LINES))  S GLOBAL=$Q(@GLOBAL) Q:GLOBAL=""  Q:$$CHEKTERM(GLOSTART,GLOBAL,MAXCOMMA,.ARRAY)  D DEBUG^XTMLOG("LOOP2","GLOBAL") D  Q:(LAST2'="")&(LAST2=LAST1)  Q:$G(GLOBAL)=""
 . S GLOBAL=$$CHKRANGE(GLOBAL,MAXCOMMA,.ARRAY) I $$CHEKGLOB(GLOBAL,MAXCOMMA,.ARRAY) D DEBUG^XTMLOG("LOOP3","GLOBAL") D STORE(GLOBAL,GLOBTOT,.CNT,.FST,SERCHVAL,DATAONLY,CASESENS,NEWSTYLE)
 . Q
 K @GLOBLAST
 I CNT>0 S LAST=@GLOBTOT@(CNT-1) I (CNT/2)=LINES S GLOBALA=$Q(@GLOBAL),GLOBALA=$$CHKRANGE(GLOBALA,MAXCOMMA,.ARRAY) I $$CHEKGLOB(GLOBALA,MAXCOMMA,.ARRAY) S @GLOBLAST@("GLOBAL")=GLOBAL
 Q (CNT/2)_SEPRATR_FST_SEPRATR_LAST
 ;
STORE(GLOBAL,TMPGLOB,CNT,FST,SERCHVAL,DATAONLY,CASESENS,NEWSTYLE) ;
 N GLOBX,GLOBV
 I '($D(@GLOBAL)#2) Q
 D INFO^XTMLOG("ENTRY:","GLOBAL,TMPGLOB,CNT,FST,SERCHVAL,DATAONLY,CASESENS")
 I $G(SERCHVAL)'="" D   I '((GLOBV[SERCHVAL)!('DATAONLY&(GLOBX[SERCHVAL))) Q
 . S GLOBX=GLOBAL,GLOBV=@GLOBAL
 . I 'CASESENS S GLOBX=$$UP^XLFSTR(GLOBX),GLOBV=$$UP^XLFSTR(GLOBV)
 . Q
 S CNT=CNT+1
 I FST="" S FST=GLOBAL
 S @TMPGLOB@(CNT)=GLOBAL
 S CNT=CNT+1,@TMPGLOB@(CNT)=$S(NEWSTYLE:"JUNK",1:"")_@GLOBAL
 Q
 ;
SETNAMES(FROM,TO) ; check validity of globals (OR ROUTINES) specified and return names for searching
 N FLG S FLG=0
 I FROM'="",FROM'?1(1"%",1A).AN S FLG="-1^INVALID 'FROM' NAME"
 I TO'="",TO'?1A.AN S FLG="-1^"_$S(FLG=0:"INVALID 'TO' NAME",1:"INVALID 'FROM' AND 'TO' NAMES")
 I TO'="",FLG=0,FROM]TO S FLG="-1^INVALID RANGE"
 I FLG=0 D
 . I TO="" S TO=FROM
 . ; 120810 JLI following modified to handle longer names as suggested by Lloyd Milligan
 . S FROM=$E(FROM,1,$L(FROM)-1)_$C($A($E(FROM,$L(FROM)))-1)_"~"
 . S TO=TO_"~"
 . Q
 Q FLG
 ;
PARSGLOB(GLOBAL,PARTS) ; PARTS PASSED BY REFERENCE - RETURNS MAXCOMMA
 ; GLOBAL - STRING CONTAINING GLOBAL REFERENCE TO BE PARSED
 ; PARTS  - PASSED BY REFERENCE - CONTAINS PARSED DATA
 ;          NODE 0 - GLOBAL NAME
 ;          NODE 1.. - COMMA PIECE NUMBER
 ;          NODE 1,1 - VALUE^TERMINATOR  (E.G., ,^TEXT or :^TEXT2)
 ;          NODE 1,2 - VALUE^TERMINATOR
 ;          NODE 2...
 ;     FOR GLOBAL "^TMP($J,""A"",1,""B"":""C"""
 ;        would return
 ;          PARTS
 ;
 ;
 N COMMAS,LAST,TERM,TOKEN,NUM1,MAXCOMMA,GLOBAL1
 S COMMAS=0,LAST="",NUM1=0,MAXCOMMA=0
 K PARTS
 S GLOBAL1=GLOBAL
 FOR  QUIT:GLOBAL=""  S GLOBAL=$$NEXTTOKN^XTMRPAR2(GLOBAL,.TOKEN,.TERM," ,:()!") D
 . I TERM="(" S PARTS(COMMAS,1)=TOKEN_TERM,COMMAS=1,NUM1=0 Q
 . I TERM="" S TERM=","
 . I TERM=")" S MAXCOMMA=COMMAS,TERM=","
 . I LAST="" S NUM1=NUM1+1,PARTS(COMMAS,NUM1)=TOKEN
 . I LAST=":" S PARTS(COMMAS,NUM1,1)=TOKEN
 . I (LAST="!")!(LAST=" ") S NUM1=NUM1+1,PARTS(COMMAS,NUM1)=TOKEN
 . I TERM="," S COMMAS=COMMAS+1,NUM1=0
 . S LAST=$S(((TERM=":")!(TERM="!")!(TERM=" ")):TERM,1:"")
 D DEBUG^XTMLOG("GLOBAL1","GLOBAL1,PARTS",1)
 Q MAXCOMMA
 ;
CHEKGLOB(GLOBAL,MAXCOMMA,NODES) ; RETURNS 1 IF VALID, OTHERWISE 0
 ; GLOBAL   - THE FULL GLOBAL REFERENCE
 ; MAXCOMMA - number of comma-pieces required, or zero if no limit
 ;            e.g., ^DD(8992,,0) would require 3 comma pieces
 ; START    - START array - passed by reference
 ; FINAL    - FINAL array - passed by reference
 ;
 ; GET GLOBAL NODE STRING
 N COMMAS,DONE,FINAL,J,NCOMMA,TERM,TOKEN,VALID
 S GLOBAL=$P(GLOBAL,"(",2,99)
 S GLOBAL=$E(GLOBAL,1,$L(GLOBAL)-1)
 D DEBUG^XTMLOG("CHEKGLOB","GLOBAL,MAXCOMMA")
 ;
 N XARRAY
 S DONE=0,VALID=1
 S COMMAS=0 F  Q:GLOBAL=""  S COMMAS=COMMAS+1,GLOBAL=$$NEXTTOKN^XTMRPAR2(GLOBAL,.TOKEN,.TERM,",") S XARRAY(COMMAS)=TOKEN I MAXCOMMA>0,COMMAS>MAXCOMMA K XARRAY S DONE=1,VALID=0 Q
 I MAXCOMMA>0,COMMAS<MAXCOMMA S DONE=1,VALID=0 K XARRAY
 D DEBUG^XTMLOG("CHEKGLOB1","VALID,NODES,XARRAY",1)
 ; if missing a defined node, it is invalid
 S NCOMMA=0 F  S NCOMMA=$O(NODES(NCOMMA)) Q:NCOMMA'>0  I '$D(XARRAY(NCOMMA)) S VALID=0,DONE=1
 ;
 I $D(XARRAY) S VALID=1 F NCOMMA=1:1:COMMAS Q:'VALID  I $D(NODES(NCOMMA)) S VALID=0,DONE=1 F J=1:1 Q:'$D(NODES(NCOMMA,J))  D  Q:VALID
 . I NODES(NCOMMA,J)="" S VALID=1 Q
 . S FINAL=NODES(NCOMMA,J) I $D(NODES(NCOMMA,J,1)) S FINAL=NODES(NCOMMA,J,1)
 . D DEBUG^XTMLOG("CHEKGLOB A","NCOMMA,J,XARRAY(NCOMMA),NODES(NCOMMA,J),NODES(NCOMMA,J,1)")
 . I $$FOLLOWS(NODES(NCOMMA,J),XARRAY(NCOMMA)) Q
 . I $$FOLLOWS(XARRAY(NCOMMA),FINAL) Q
 . S VALID=1
 . D DEBUG^XTMLOG("EXITING CHEKGLOB","VALID")
 . Q
 D DEBUG^XTMLOG("EXIT CHEKGLOB","VALID")
 Q VALID
 ;
 ; GETLIMIT - returns as its value the leading part of the input global
 ;               specification which is fixed.
 ;            It returns the maximum number of comma pieces for the global
 ;               in an argument passed by reference (MAXCOMMA) or a value
 ;               of zero if there is no limit on comma pieces in the global
 ;               (maximum comma pieces are indicated when the global
 ;               specification is terminated by a closing parenthesis).
 ;            It also returns data in an array argument passed
 ;               by reference (OUTARRAY) which on return contains
 ;               information on those nodes which follow the fixed part
 ;               the global specification.
 ;
GETLIMIT(GLOBAL,MAXCOMMA,PARTS) ;
 ; GLOBAL    - INPUT  - the global specification input by the user
 ; MAXCOMMA  - OUTPUT - PASSED BY REFERENCE - the maximum number of commas, if paren terminated
 ; PARTS     - OUTPUT - PASSED BY REFERENCE - an array containing
 ;             information on the nodes following the fixed part of the
 ;             global specification.
 N BASE,DONE,I,J,TEST1,TEST2,X
 S MAXCOMMA=$$PARSGLOB(GLOBAL,.PARTS)
 D DEBUG^XTMLOG("IN GETLIMIT","PARTS",1)
 S I=0 F  S I=$O(PARTS(I)) Q:I'>0  F J=1:1 Q:'$D(PARTS(I,J))  I $G(PARTS(I,J))'="" D
 . D DEBUG^XTMLOG("IN LOOP","I,J,PARTS(I,J),PARTS(I,J,1)")
 . S TEST1="^TMP("_PARTS(I,J)_")"
 . S TEST1=$NA(@TEST1)
 . S TEST1=$P(TEST1,"^TMP(",2)
 . S PARTS(I,J)=$E(TEST1,1,$L(TEST1)-1)
 . S TEST2=TEST1
 . S TEST1=I_"  "_J
 . I $D(PARTS(I,J,1)) D
 . . S TEST2="^TMP("_PARTS(I,J,1)_")"
 . . S TEST2=$NA(@TEST2)
 . . S TEST2=$P(TEST2,"^TMP(",2)
 . . S TEST2(1)=I_"  "_J
 . . S PARTS(I,J,1)=$E(TEST2,1,$L(TEST2)-1)
 . . Q
 . D DEBUG^XTMLOG("","TEST1,TEST2,PARTS",1)
 . Q
 D DEBUG^XTMLOG("AFTER LOOP","PARTS",1)
 Q PARTS(0,1)
 ;
 N BASE,DONE,I,J,TEST1,TEST2,X,PARTS
 S MAXCOMMA=$$PARSGLOB(GLOBAL,.PARTS)
 D DEBUG^XTMLOG("IN GETLIMIT","PARTS",1)
 K OUTARRAY
 S I=0 F  S I=$O(PARTS(I)) Q:I'>0  F J=1:1 Q:'$D(PARTS(I,J))  I $G(PARTS(I,J))'="" D
 . D DEBUG^XTMLOG("IN LOOP","I,J,PARTS(I,J),PARTS(I,J,1)")
 . S TEST1="^TMP("_PARTS(I,J)_")"
 . S TEST1=$NA(@TEST1)
 . S TEST1=$P(TEST1,"^TMP(",2)
 . S OUTARRAY(I,J)=$E(TEST1,1,$L(TEST1)-1)
 . S TEST2=TEST1
 . S TEST1=I_"  "_J
 . I $D(PARTS(I,J,1)) D
 . . S TEST2="^TMP("_PARTS(I,J,1)_")"
 . . S TEST2=$NA(@TEST2)
 . . S TEST2=$P(TEST2,"^TMP(",2)
 . . S TEST2(1)=I_"  "_J
 . . S OUTARRAY(I,J,1)=$E(TEST2,1,$L(TEST2)-1)
 . . Q
 . D DEBUG^XTMLOG("","TEST1,TEST2,OUTARRAY",1)
 . Q
 D DEBUG^XTMLOG("AFTER LOOP","OUTARRAY",1)
 D DEBUG^XTMLOG("EXIT GETLIMIT","OUTARRAY,BASE",1)
 Q BASE
 ;
CHEKTERM(BASEGLO,CURRGLO,MAXCOMMA,ARRAY) ; returns TRUE if CURRGLO follows a specified fixed range
 N BASE1,BTERM,BTOKEN,CTERM,CTOKEN,CURR1,I,TERM,VALUE,GLOBAL,VARRAY
 N COMMAS,DONE,ENDRANGE,FRSTNODE,LASTVALU,TERMVAL,TOKEN,VALID,XARRAY
 ;
 D INFO^XTMLOG("ENTRY","BASEGLO,CURRGLO,MAXCOMMA,ARRAY",1)
 ; if ONLY GLOBAL NAME SPECIFIED
 S TERM=0
 I $L(BASEGLO,"(")=1 S VALUE=$P(CURRGLO,"(") Q VALUE]BASEGLO
 ; find last specified value or range prior to unspecified values
 ; get sequence of nodes for current global value into XARRAY
 S GLOBAL=$P(CURRGLO,"(",2,99),GLOBAL=$E(GLOBAL,1,$L(GLOBAL)-1)
 S COMMAS=0 F  Q:GLOBAL=""  S COMMAS=COMMAS+1,GLOBAL=$$NEXTTOKN^XTMRPAR2(GLOBAL,.TOKEN,.TERMVAL,",") S XARRAY(COMMAS)=TOKEN
 D DEBUG^XTMLOG("","XARRAY",1)
 D DEBUG^XTMLOG("V1","ARRAY",1)
 ; determine first undefined or null node for input
 F I=1:1 Q:'$D(ARRAY(I))  Q:ARRAY(I,1)=""  Q:$D(ARRAY(I,1))>1  Q:$O(ARRAY(I,1))>0
 ; get last node that is required to match something, prior to any null values
 D DEBUG^XTMLOG("","I",1)
 ; now check for whether the current global follows the last specified node or range
 S TERM=0,FRSTNODE=I-1 I FRSTNODE>0  D  I TERM Q TERM
 . S LASTVALU=$O(ARRAY(FRSTNODE,""),-1) D DEBUG^XTMLOG("CHECK FIXED","FRSTNODE,LASTVALU",1)
 . I $D(ARRAY(FRSTNODE,LASTVALU))=1,$D(XARRAY(FRSTNODE)),$$FOLLOWS(XARRAY(FRSTNODE),ARRAY(FRSTNODE,LASTVALU)) D DEBUG^XTMLOG("FIXED","XARRAY(FRSTNODE),ARRAY(FRSTNODE,LASTVALU)") S TERM=1
 . I $D(ARRAY(FRSTNODE,LASTVALU))>1 D DEBUG^XTMLOG("CHECK RANGE") S TERM=$$FOLLOWS(XARRAY(FRSTNODE),ARRAY(FRSTNODE,LASTVALU,1)) I TERM D DEBUG^XTMLOG("RANGE","XARRAY(FRSTNODE),ARRAY(FRSTNODE,LASTVALU,1)")
 . D DEBUG^XTMLOG("FROM FIRSTNODE","TERM")
 . Q
 Q TERM
 ;
FOLLOWS(TEST,BASE) ; returns TRUE (1) if TEST follows BASE
 D INFO^XTMLOG("ENTRY","TEST,BASE")
 N TERM,TYPE S TERM=0,TYPE=0
 ; BOTH NUMERIC
 I +BASE=BASE,+TEST=TEST S TYPE=1 I TEST>BASE D DEBUG^XTMLOG("2 NUMERICS TRUE") S TERM=1
 ; BASE NUMERIC, TEST ALPHA
 I TERM=0,TYPE=0,+BASE=BASE,+TEST'=TEST S TYPE=2 D DEBUG^XTMLOG("1 NUMERIC,1ALPHA") S TERM=1
 I TERM=0,TYPE=0,+TEST=TEST,+BASE'=BASE S TYPE=2
 ; BOTH ALPHA
 ; 120203 next two lines of code added to prevent infinite loop if TEST contains
 ;        space or exclamation mark at same location as closing quote in BASE
 I TERM=0,TYPE=0,$E(TEST)="""",$E(TEST,$L(TEST))="""" S TEST=$E(TEST,2,$L(TEST)-1)
 I TERM=0,TYPE=0,$E(BASE)="""",$E(BASE,$L(BASE))="""" S BASE=$E(BASE,2,$L(BASE)-1)
 I TERM=0,TYPE=0,TEST]BASE S TYPE=3 D DEBUG^XTMLOG("BOTH ALPHA") S TERM=1
 Q TERM
 ;
CHKRANGE(GLOBAL,MAXCOMMA,ARRAY) ; RETURNS GLOBAL WITHIN DESIRED RANGE
 ; GLOBAL - INPUT GLOBAL VALUE
 ; ARRAY  - PASSED BY REFERENCE - ARRAY OF NODE VALUES OR RANGES
 N GLOBNODE,GLOBREF,I,J,MAXNODE,RESULT,VALUE,GLOBALV,IMAX,JMAX
 N GLOSTR,NCOMMA,TERM,TOKEN
 D INFO^XTMLOG("ENTRY")
 S RESULT=""
 S MAXNODE=$O(ARRAY(""),-1)
 D DEBUG^XTMLOG("ENTRY","MAXNODE,MAXCOMMA,GLOBAL,ARRAY",1)
 S NCOMMA=$$COMMACNT(GLOBAL)
 I MAXCOMMA>0 I NCOMMA>MAXCOMMA S GLOBAL=$$MOVEUP(GLOBAL,MAXCOMMA)
 I GLOBAL="" D INFO^XTMLOG("EXIT NULL") Q ""
 K VALUE
 S GLOBREF=$P(GLOBAL,"(")_"(",GLOBAL=$P(GLOBAL,"(",2,99),GLOBAL=$E(GLOBAL,1,$L(GLOBAL)-1)
 D DEBUG^XTMLOG("3","GLOBREF,GLOB1")
 S GLOSTR=GLOBAL,GLOBAL="",NCOMMA=$$COMMACNT(GLOSTR) ;$L(GLOSTR,",")
 D DEBUG^XTMLOG("41","GLOSTR,NCOMMA")
 F I=1:1:NCOMMA S GLOSTR=$$NEXTTOKN^XTMRPAR2(GLOSTR,.TOKEN,.TERM,",") S VALUE(I)=TOKEN
 D DEBUG^XTMLOG("4A","VALUE",1)
 F I=1:1 S IMAX=I,GLOBNODE=$G(VALUE(I)) Q:GLOBNODE=""  S VALUE(I)="",JMAX=$O(ARRAY(I,""),-1) S:+JMAX=0 VALUE(I)=GLOBNODE F J=1:1:JMAX D  Q:VALUE(I)'=""
 . I '$D(ARRAY(I,1)) S VALUE(I)=GLOBNODE Q
 . ; no value specified, use anything
 . I $G(ARRAY(I,1))="" S VALUE(I)=GLOBNODE D DEBUG^XTMLOG("5A","I,VALUE(I)") Q
 . ; fixed or lower bound value for node
 . I $$FOLOWEQ(ARRAY(I,J),GLOBNODE) S VALUE(I)=ARRAY(I,J) D DEBUG^XTMLOG("5B","I,J,VALUE(I),ARRAY(I,J),GLOBNODE") Q
 . I $D(ARRAY(I,J,1)),$$FOLOWEQ(GLOBNODE,ARRAY(I,J))&$$FOLOWEQ(ARRAY(I,J,1),GLOBNODE) S VALUE(I)=GLOBNODE D DEBUG^XTMLOG("5C","I,J,VALUE(I)") Q
 . Q
 S GLOBAL=GLOBREF
 D DEBUG^XTMLOG("6","VALUE,IMAX",1)
 F I=1:1:IMAX Q:$G(VALUE(I))=""  S GLOBAL=GLOBAL_$S(I>1:",",1:"")_VALUE(I)
 D DEBUG^XTMLOG("61","I,NCOMMA,IMAX,GLOBAL")
 ; following replaced => with not < since GT.M does not allow >= 120116 JLI
 ;I (NCOMMA>=I),($G(VALUE(I))="") S GLOBAL=$$MOVEUP(GLOBAL,$L(GLOBAL,","))
 I '(NCOMMA<I),($G(VALUE(I))="") S GLOBAL=$$MOVEUP(GLOBAL,$L(GLOBAL,","))
 I GLOBAL'="",$E(GLOBAL,$L(GLOBAL))'=")" S GLOBAL=GLOBAL_")"
 D INFO^XTMLOG("EXIT","GLOBAL")
 Q GLOBAL
 ;
FOLOWEQ(TEST,BASE) ;
 N RESULT S RESULT=0
 I $$FOLLOWS(TEST,BASE) S RESULT=11
 I TEST=BASE S RESULT=1
 Q RESULT
 ;
MOVEUP(GLOBAL,MAXCOMMA) ;
 D INFO^XTMLOG("MOVEUP ENTRY","GLOBAL,MAXCOMMA")
 N GLOB1,GLOSTR,I,NCOMMA,TERM,TOKEN
 S NCOMMA=MAXCOMMA
LOOP S GLOSTR=GLOBAL,GLOBAL=""
 N LOOP1
 D DEBUG^XTMLOG("LOOP ENTRY","GLOSTR")
 F I=1:1:NCOMMA S GLOSTR=$$NEXTTOKN^XTMRPAR2(GLOSTR,.TOKEN,.TERM,",") S GLOBAL=GLOBAL_$S(I>1:",",1:"")_TOKEN
 D DEBUG^XTMLOG("MOVEUP PASS","GLOBAL")
 S:$E(GLOBAL,$L(GLOBAL))="(" GLOBAL=""
 S:GLOBAL="" GLOB1=""
 D DEBUG^XTMLOG("MOVEUP PASS1","GLOBAL")
 I GLOBAL'="" S LOOP1=0 D  I $G(LOOP1)=1 G LOOP
 . S GLOBAL=GLOBAL_$S($E(GLOBAL,$L(GLOBAL))'=")":")",1:"")
 . S GLOB1=$O(@GLOBAL)
 . I GLOB1="" S NCOMMA=NCOMMA-1 S:NCOMMA=0 GLOBAL="" I NCOMMA>0 S LOOP1=1 ;G LOOP
 . Q
 I GLOB1'="",GLOB1'=+GLOB1 S GLOB1=""""_GLOB1_""""
 D DEBUG^XTMLOG("LOOPA","GLOB1,NCOMMA")
 I GLOB1'="",NCOMMA>1 S GLOBAL=$P(GLOBAL,",",1,NCOMMA-1)_","_GLOB1_")"
 I GLOB1'="",NCOMMA=1 S GLOBAL=$P(GLOBAL,"(")_"("_GLOB1_")"
 D INFO^XTMLOG("EXIT MOVEUP","GLOBAL")
 Q GLOBAL
 ;
COMMACNT(GLOBAL) ;returns comma length for GLOBAL
 N COUNT,TOKEN,TERM
 S COUNT=0
 F  Q:GLOBAL=""  S GLOBAL=$$NEXTTOKN^XTMRPAR2(GLOBAL,.TOKEN,.TERM,","),COUNT=COUNT+1
 Q COUNT
