/*=========================================================================
 *
 *  Copyright OSEHRA
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *=========================================================================*/

#include "GTM.h"
#include "GTMException.h"

#include <cstdlib>
#include <iostream>

//
//  Test the Query method
//

int main( int argc, char * argv [] )
{
  GTM gtm;

  try
    {

    //
    //   Exercise the std::string API
    //

    std::string textOfCode = "write $ZVERSION,!";

    gtm.Execute( textOfCode );

    //
    //   Exercise the same pattern with direct strings
    //

    gtm.Execute( "write $ZVERSION,!");

    }
  catch( GTMException & excp )
    {
    std::cerr << excp.what() << std::endl;
    }

  return EXIT_SUCCESS;
}
