Ext.define("COMS.view.NewPlan.PatientTemplates" ,{
	extend: "Ext.panel.Panel",
	alias : "widget.PatientTemplates",
	name : "Patient Templates Table",
	title : "Treatment Regimens & Summaries",

	autoEl : { tag : "section" },
//	cls : "PI_PatientInformationTable",
	cls : "xPandablePanel",
	width: 950,
	collapsible : true,
	collapsed : true,


	tpl : [
		"<table border=\"1\" style=\"margin: 10px auto;\" class=\"PatHistResults InformationTable\">",
			"<tr>",
				"<th>&nbsp;</th>",
				"<th>Template Name</th>",
				"<th>Start Date</th>",
				"<th>End Date</th>",
				"<th>&nbsp;</th><th>&nbsp;</th>",
			"</tr>",

			"<tpl if=\"''!== TemplateName\">",
				"{[this.Check(values)]}",
				"<tr>",
					"<th>Current Template:</th>",
					"<td>{TemplateName}</td>",
						"<td>{DateStarted}</td>",
						"<td>{ScheduledEndDate}</td>",
						"<td><button class=\"anchor\" name=\"ShowTemplateDetails\" templateName=\"{TemplateName}\" templateID=\"{TemplateID}\">Show Details</button></td>",
					"<td>",
						"<button class=\"anchor\" name=\"GenerateEoTS\" templateName=\"{TemplateName}\" templateID=\"{TemplateID}\">Stop Treatment</button>",
						"<button style=\"display:none;\" class=\"anchor\" name=\"ShowEoTS\" templateName=\"{TemplateName}\" templateID=\"{TemplateID}\">Show End of Treatment Summary</button>",
					"</td>",
				"</tr>",
			"</tpl>",

			"<tpl for=\"Historical\">",
				"<tpl if=\"''!== TemplateName\">",
					"<tr>",
						"<th>Historical Template:</th>",
						"<td>{TemplateName}</td>",
						"<td>{DateStarted}</td>",
						"<td>{DateEndedActual}</td>",
						"<td><button class=\"anchor\" name=\"ShowTemplateDetails\" templateName=\"{TemplateName}\" templateID=\"{TemplateID}\">Show Details</button></td>",
						"<td>{[this.EoTSBtn( values )]}</td>",
					"</tr>",
				"</tpl>",
			"</tpl>",
		"</table>",
		{
				// XTemplate Configuration
			disableFormats: true,
			Check : function( v ) {
				// debugger;
			},
			EoTSBtn : function ( current ) {
				var retBuf, btnBuf = "<button class=\"anchor\" templateName=\"" + current.TemplateName + "\" templateID=\"" + current.TemplateID + "\"";
				if ("" === current.EotsID){
					retBuf = btnBuf + "name=\"GenerateEoTS\">Generate End of Treatment Summary</button>";
				}
				else {
					retBuf = btnBuf + "name=\"ShowEoTS\" EotsID=\"" + current.EotsID + "\">Show End of Treatment Summary</button>";
				}
				return retBuf;
			}
		}
	]
});