Ext.define("COMS.view.NewPlan.CTOS.KnowledgeBase" ,{
	extend: "Ext.panel.Panel",
	alias : "widget.KnowledgeBase",

	name : "Knowledge Base Tab",
	margin : "0 0 20 0",

	autoEl : { tag : "section" },
	title: "Knowledge Base",
	html:	[
		"<h2>Knowlege Base Article on Gleevec</h2>",
		"<p><span class=\"style2\"><strong>Gleevec &tm;</strong></span><br />",
		"<span class=\"style2\">Generic name:</span> Imatinib Mesylate<br /><span class=\"style2\">Other names:</span> STI-571<br /><br />",
		"Gleevec is the trade name for the generic drug name Imatinib Mesylate. STI-571 is another name for Imatinib Mesylate. ",
		"In some cases, health care professionals may use the trade name Gleevec or other name STI-571 when referring to the generic drug name Imatinib Mesylate.<br />",
		"<br />",
		"<span class=\"style2\">Drug type:</span> Gleevec is a targeted therapy. Gleevec is classified as a signal transduction inhibitor - ",
		"proteintyrosine kinase inhibitor. (For more detail, see &quot;How this drug works&quot; below).<br /><br />",
		"<span class=\"style2\">What Gleevec is used for:</span><br />",
		"<ul>",
		"<li>Newly diagnosed adult and pediatric patients with Philadelphia chromosome positive chronic myeloid<br />leukemia (Ph+ CML) in chronic phase.</li>",
		"<li>Ph+ CML in blast crisis, accelerated phase, or chronic phase after failure of interferon-alpha therapy.</li>",
		"<li>Adult patients with relapsed or refractory Philadelphia chromosome + acute lymphoblastic leukemia (Ph+ALL)</li>",
		"<li>Adult patients with myelodysplastic/myeloproliferative diseases (MDS/MPD) associated with PDGFR gene rearrangements.</li>",
		"<li>Gastrointestinal stromal tumors that are C-kit positive.</li>",
		"</ul>",
		"<span class=\"style2\">Note:</span> If a drug has been approved for one use, physicians may elect to use this same drug for other problems if they ",
		"believe it may be helpful.<br /><br />",
		"<ul><span class=\"style2\">How Gleevec is given:</span>",
		"<li>Gleevec is a pill, taken by mouth, once or twice daily.</li>",
		"<li>Gleevec should be taken with a large glass of water, after a meal.</li>",
		"<li>The amount of Gleevec that you will receive depends on many factors, including your general health or other health problems, and the type of ",
		"cancer or condition being treated. Your doctor will determine your dose and schedule.</li>",
		"</ul>",
		"<br />",
		"<ul><span class=\"style2\">Side effects of Gleevec:</span><br />",
		"Important things to remember about the side effects of Gleevec:",
		"<li>Most people do not experience all of the side effects listed.</li>",
		"<li>Side effects are often predictable in terms of their onset and duration.</li>",
		"<li>Side effects are almost always reversible and will go away after treatment is complete.</li>",
		"<li>There are many options to help minimize or prevent side effects.</li>",
		"<li>There is no relationship between the presence or severity of side effects and the effectiveness of the medication.</li>",
		"<li>The side effects of Gleevec and their severity depend on how much of the drug is given. In other words, high doses may produce more severe side effects.</li>",
		"</ul><br />",
		"<ul><span class=\"style2\">The following side effects are common (occurring in greater than 30%) for patients taking Gleevec: </span> ",
		"<li>Low blood counts. Your white and red blood cells and platelets may temporarily decrease. ",
		"This can put you at increased risk for infection, anemia and/or bleeding.</li>",
		"<li>Nausea and vomiting</li><li>Edema (swelling of the face, feet, hands)</li>",
		"<li>Muscle cramps and bone pain</li><li>Diarrhea</li>",
		"<li>Hemorrhage (see bleeding problems)</li>",
		"<li>Skin rash (see skin reactions)</li>",
		"<li>Fever</li></ul><br />",
		"<ul><span class=\"style2\">These side effects are less common side effects (occurring in about 10-29%) of patients receiving Gleevec:</span>",
		"<li>Headache</li>",
		"<li>Fatigue</li>",
		"<li>Joint pain</li>",
		"<li>Indigestion (see heartburn)</li>",
		"<li>Abdominal pain</li>",
		"<li>Cough</li>",
		"<li>Shortness of breath</li>",
		"<li>Poor appetite</li>",
		"<li>Constipation</li>",
		"<li>Night sweats (see skin reactions)</li>",
		"<li>Nose bleeds (see bleeding problems)</li>",
		"<li>Weakness</li>",
		"<li>Your fertility, meaning your ability to conceive or father a child, may be affected by Gleevec.",
		" Please discuss this issue with your health care provider.</li>",
		"</ul>A <em>rare, but potentially serious</em> side effect of Gleevec is liver toxicity. ",
		"There may be elevations in transaminase, bilirubin, and lactate dehydrogenase.<br /><br />",
		"Not all side effects are listed above. Some that are rare (occurring in less than 10% of patients) are not listed here. ",
		"However, you should always inform your health care provider if you experience any unusual symptoms.<br /><br />",
		"<span class=\"style2\">When to contact your doctor or health care provider:</span><br /><br />",
		"<ul><span class=\"style2\">Contact your health care provider immediately, day or night, if you should experience any of the<br />",
		"following symptoms:</span>",
		"<li>Fever of 100.5 F (38 C) or higher, chills (possible signs of infection)</li>",
		"<li>Shortness of breath, difficulty breathing</li>",
		"<li>Significant bleeding from nose, mouth, vagina, rectum that will does not stop within 15 minutes.</li>",
		"</ul><br />",
		"<ul><span class=\"style2\">The following symptoms require medical attention, but are not an emergency. ",
		"Contact your health care provider within 24 hours of noticing any of the following:</span>",
		"<li>Nausea (interferes with ability to eat and unrelieved with prescribed medication).</li>",
		"<li>Vomiting (vomiting more than 4-5 times in a 24 hour period).Diarrhea (4-6 episodes in a 24-hour period).</li>",
		"<li>Unusual bleeding or bruising</li><li>Black or tarry stools, or blood in your stools</li><li>Blood in the urine</li>",
		"<li>Extreme fatigue (unable to carry on self-care activities)</li>",
		"<li>Swelling, redness and/or pain in one leg or arm and not the other</li>",
		"<li>Yellowing of the skin or eyes</li>",
		"<li>Swelling of the feet or ankles. Sudden weight gain.</li>",
		"</ul>",
		"<em>Always inform your health care provider if you experience any unusual symptoms.</em><br /><br />",
		"<ul><span class=\"style2\">Precautions:</span>",
		"<li>Before starting Gleevec treatment, make sure you tell your doctor about any other medications you are taking ",
		"(including prescription, over-the-counter, vitamins, herbal remedies, etc.). ",
		"Do not take aspirin, products containing aspirin unless your doctor specifically permits this. ",
		"St. John\'s Wort may decrease the effectiveness of this medication.</li>",

		"<li>Discuss pain remedies with your doctor before taking. Acetominophen (Tylenol) may not be recommended.",
		" Be sure to discuss this with your doctor.</li><li>Do not receive any kind of immunization or vaccination without your doctor\'s approval while taking Gleevec.</li>",
		"<li>Inform your health care professional if you are pregnant or may be pregnant prior to starting this treatment. ",
		"Pregnancy category D (Gleevec may be hazardous to the fetus. Women who are pregnant or become pregnant must be advised of the potential hazard to the fetus).</li>",
		"<li>For both men and women: Do not conceive a child (get pregnant) while taking Gleevec. ",
		"Barrier methods of contraception, such as condoms, are recommended. ",
		"Discuss with your doctor when you may safely become pregnant or conceive a child after therapy.</li>",
		"<li>Do not breast feed while taking this medication.</li>",
		"</ul><br />",
		"<ul><span class=\"style2\">Self-care tips:</span>",
		"<li>Take this medication after a meal with a large glass of water to reduce upset stomach. ",
		"Take this medication at about the same time each day.</li>",
		"<li>If you miss a dose of this medication, do not take the missed dose at all and do not double the next one. ",
		"Instead, go back to your regular dosing schedule and check with your health care provider.</li>",
		"<li>You may be at risk of infection so try to avoid crowds or people with colds and those not feeling well, and report fever or any other signs of ",
		"infection immediately to your health care provider.</li>",
		"<li>Wash your hands often.</li>",
		"<li>Drink at least two to three quarts of fluid every 24 hours, unless you are instructed otherwise.</li>",
		"<li>Use an electric razor and a soft toothbrush to minimize bleeding.</li>",
		"<li>Avoid contact sports or activities that could cause injury.</li>",
		"<li>In general, drinking alcoholic beverages should be kept to a minimum or avoided completely. You should discuss this with your doctor.</li>",
		"<li>Get plenty of rest.</li>",
		"<li>Maintain good nutrition.</li>",
		"<li>If you experience symptoms or side effects, be sure to discuss them with your health care team. ",
		"They can prescribe medications and/or offer other suggestions that are effective in managing such problems.</li>",
		"</ul><br />",
		"<span class=\"style2\">Monitoring and testing:</span><br />",
		"You will be checked regularly by your health care professional while you are taking Gleevec, to monitor side effects and check your response to therapy. ",
		"Periodic blood work to monitor your complete blood count (CBC) as well as the function of other organs (such as your kidneys and liver) will also be ordered by your doctor.<br /><br />",
		"<span class=\"style2\">How Gleevec works:</span><br />",
		"Targeted therapy is the result of about 100 years of research dedicated to understanding the differences between cancer cells and normal cells. ",
		"To date, cancer treatment has focused primarily on killing rapidly dividing cells because one feature of cancer cells is that divide rapidly. ",
		"Unfortunately, some of our normal cells divide rapidly too, causing multiple side effects.<br /><br />",
		"Targeted therapy is about identifying other features of cancer cells. Scientists look for specific differences in the cancer cells and the normal cells. ",
		"This information is used to create a targeted therapy to attack the cancer cells without damaging the normal cells, thus leading to fewer side effects. ",
		"Each type of targeted therapy works a little bit differently but all interfere with the ability of the cancer cell to grow, divide, repair and/or communicate with other cells.<br /><br />",
		"There are different types of targeted therapies, defined in three broad categories. ",
		"Some targeted therapies focus on the internal components and function of the cancer cell. ",
		"The targeted therapies use small molecules that can get into the cell and disrupt the function of the cells, causing them to die. ",
		"There are several types of targeted therapy that focus on the inner parts of the cells. ",
		"Other targeted therapies target receptors that are on the outside of the cell. ",
		"Therapies that target receptors are also known as monoclonal antibodies. ",
		"Antiangiogenesis inhibitors target the blood vessels that supply oxygen to the cells, ultimately causing the cells to starve.<br /><br />",
		"Researchers agree that targeted therapies are not a replacement for traditional therapies. ",
		"They may best be used in combination with traditional therapies. ",
		"More research is needed to identify which cancers may be best treated with targeted therapies and to identify additional targets for more types of cancer.<br /><br />",
		"Imatinib mesylate belongs to the signal transduction inhibitor category of targeted therapies. It is particularly a protein-tyrosine kinase inhibitor.<br /><br />",
		"Note: We strongly encourage you to talk with your health care professional about your specific medical condition and treatments. ",
		"The information contained in this website is meant to be helpful and educational, but is not a substitute for medical advice.<br /><br />",
		"<p><br />Drug information Provided by:<br />",
		"Chemocare.com - a program of the Scott Hamilton CARES initiative<br />",
		"Copyright 2005 by The Cleveland Clinic Foundation. All Rights Reserved.<br />",
		"Content provided by Cleveland Clinic Cancer Center<br /></p>"

	],

	initComponent: function() {
		wccConsoleLog("Knowledge Base Tab View - Initialization");
		this.callParent(arguments);
	}
});