	


For many cancer patients, having blood drawn is routine. Many patients and their families become sophisticated about these "labs," and request copies of their reports. Others rely on their physicians and nurses to explain results. A general knowledge of the purpose of commonly ordered laboratory tests may be helpful to patients and their families, but the significance of laboratory test results should always be discussed with your physician.

Oncology Services acknowledges with thanks the assistance of UCLAs department of Pathology and Laboratory Medicine, Elizabeth Wagar, MD, director of Clinical Laboratories, in the preparation of this information

NORMAL VALUES OR REFERENCE RANGES
Reports of laboratory test results compare individual results with a Reference Range or Normal Laboratory Values. Reference Ranges are developed by clinical laboratories based upon the statistical data for 95% of each laboratorys patient population. Thus, no two laboratories will have identical reference ranges.
In comparing laboratory test results with reference Ranges, remember that in reviewing test results, your physician is aware of the effect of any medications that you might be taking on test results. Also, in comparing results with Reference Ranges, particularly in instances of a borderline or marginal variation from the range, patients should know that subtle factors such as position or condition of the patient (sitting v. lying down; fasting v. after a meal) the time of day, even weather and climate can affect results.

OTHER CONSIDERATIONS
In reviewing laboratory test results, patients should bear in mind:

    No single test is 100% accurate for specificity, sensitivity or predictive value.
    Any particular laboratory result may be inaccurate, for a variety of reasons.
    The degree of abnormality and the significance of the abnormality are proportional. That is, marginal variations likely have less significance than wide variations.
    Multiple test abnormalities are more likely significant that single test abnormalities.
    Test results, when possible, should be compared over time, preferably with results from the same laboratory. When possible, comparison with the patients test results prior to illness may be helpful.

(Adapted by permission from J. Wallach, MD: Interpretation of Diagnostic Tests (6th ed.) Little, Brown and company, 1996.)

A B C D E F G H I J K L M N O P Q R S T U V W X Y Z A

ALBUMIN
(Included in COMPREHENSIVE METABOLIC GROUP, hereinafter CMG.) A type of simple protein found in tissues and fluids of plants and animals. Decreased level found in instances of multiple myeloma, Hodgkins disease and some metastatic cancers.

ALKALINE PHOSPHATASE
One of a group of enzymes that liberate inorganic phosphate from phosphoric esters. Increased level found in instances of metastatic or osteogenic sarcoma, healing fracture, liver disease such as biliary obstruction. Also, increased level present during pregnancy.

ALPHA-FETOPROTEIN
A fetal protein that is also found in adults. Increased levels found in instances of hepatocellular carcinoma, testicular tumor, some instances of benign hepatic disease.

ANALINE AMINOTRANSFERASE (ALT or SGPT)
Enzymes that transfer amino groups between an alpha amino acid and, usually, a 2-keto acid. Increased level found in instances of liver disease, liver metastatsis, biliary obstruction, pancreatitis.

AMMONIA
A volatile gas, soluble in water, which then combine with acids to form ammonium compounds. Increased levels found in instances of liver failure.

AMYLASE
One of a group of starch splitting enzymes. Increased levels found in instances of acute pancreatitis, pancreatic duct obstruction, intestinal obstruction, renal disease. Decreased level found in instances of pancreatic destruction.

ASPARTATE AMINOTRANSFERASE (AST or SGOT). (CMG.)
An enzyme catalyzing transfer of an amine group from glutamic acid to osaloacetic acid. Changes in this test generally parallel those in the ALT or SGPT test above. Increased levels found in instances of liver disease, pancreatitis, brain damage, renal infarction.

Back to top

B

BASOPHILS (Included in Differential.)
Form of granulytic white blood cell that usually fills the cytoplasm. Uniquely, these do not occur in increased numbers when acute infection is present. Increased in chronic myeloid leukemia. Decreased in patients receiving steroid therapy.

BILIRUBIN, Total. (CMG.)
A red bile pigment formed from hemoglobin during normal and abnormal destruction of red blood cells in the reticuloendothelium. Increased in instances of hepatic damage, biliary obstruction.

BILIRUBIN, Conjugated (Direct)
Usually not necessary with Total Bilirubin <1.2. The fraction of serum bilirubin conjugated with glucuronic acid in the liver cell to form bilirubin diglucuronide. Increased level is an indicator of biliary obstruction/ cholestasis.

BILIRUBIN, Unconjugated (Indirect)
Calculated as Total minus Conjugated Bilirubin. The fraction bilirubin that has not been conjugated with glucuronic acid in the liver cell. Increased level caused by any type of hemolytic anemia, including transfusion reaction and sickle cell.
BLOOD UREA NITROGEN (BUN). (CMG.) The most prevalent of non-protein nitrogenous compounds in blood. Increased in instances of renal failure and gastro-intestinal bleeding.

Back to top

C

CA 15-3
Tumor marker. Increased in instances of progressive breast cancer.

CA 19- 9
Tumor marker. Increased in instances of gastro-intestinal cancers, including colon, liver, pancreas and stomach; and in some instances, lung and prostate cancers.

CA 27-29
Tumor marker. Used in management of breast cancer patients. It is not a screening test for breast cancer.

CA 125
Tumor marker. Increased level present in instances of colon, endometrial and ovarian cancers. Also, increased in instances of benign abdominal lesions (teratomas) and breast lesions.

CALCIUM (CMG.)
Metallic dyad element, used in formation of teeth and bone. Increased levels found in instances of metastatic bone tumors. Decreased levels note in instances of acute pancreatitis.

CARBON DIOXIDE (CMG.)
A gas produced by the combustion of carbon with an excess of air. Increased in instances of respiratory acidosis (emphysema) and severe vomiting. Decreased in instances of respiratoryalkalosis and metabloic acidosis, severe diarrhea, renal failure, dehydration.

CARCINOEMBRYONIC ANTIGEN (CEA).
Tumor marker. Used in monitoring treatment response and recurrence of disease in gastro-intestinal cancers.

CHLORIDE (CMG.)
Compound containing the element chlorine. Increased levels in instances of diarrhea, mineralcorticoid deficiency, and some medications. Decreased in instances of vomiting, certain diabetes millitus, mineralcorticoid excess, renal disease with sodium loss.

COMPLETE BLOOD COUNT (CBC).

    Includes Hematocrit (Hct)Hemoglobin (Hgb)
    Mean Corpuscular Hemoglobin (MCH)
    Mean Corpuscular Hemoglobin Concentration (MCHC)
    Mean Corpuscular Volume (MCV)
    Red Blood Cell Count (RBC)
    Red Blood Cell Distribution Width (RDW)
    White Blood Cell Count (WBC).
    COMPLETE BLOOD COUNT, PLATELET and DIFFERENTIAL (CBC, Platelet, Diff). Includes all CBC tests above, plus
    Platelets
    Mean Platelet Volume (MPV)
    Basophil Absolute Count, Percentage
    Eosinophil Absolute Count, Percentage
    Lymphocyte Absolute Count, Percentage
    Monocyte Absolute Count, Percentage
    Neutrophil Absolute Count, Percentage

COMPREHENSIVE METABOLIC GROUP (CMG). Formerly, "Chemistry Panel.."

    Includes Albumin
    Alkaline Phosphatase
    Analine Aminotransferase (ALT)
    Aspartate Aminotransferase (AST)
    Bilirubin, Total
    Blood Urea Nitrogen (BUN)
    Calcium, Total (Ca)
    Carbon Dioxide (CO2)
    Chloride (Cl)
    Creatinine
    Glucose
    Potassium (K)
    Protein
    Sodium (Na) 

COOMBS TEST, Direct (Direct Antiglobulin Test).
Uses patients RBCs; tests for presence of antibody on RBCs. Used in screening for autoimmune hemolytic anemia.

CREATNINE (CMG.)
Component of urine and final product of creatine catabloism. Increased levels may indicate renal failure. Decreased levels noted in instances of liver disease and during pregnancy.
Back to top


D

DIFFERENTIAL (Differential Count, Manual).
Microscopic examination of blood smear to evaluate qualitative and quantitative variations in WBC numbers, shape and structure; the shape and structure of RBCs and Platelet evaluation. Used in evaluation of anemia, leukemia, infection, inflammation and inherited blood disorders. See entries for individual tests listed above under CBC, Platelet, Diff.

Back to top

E

ELECTROLYTES
Compounds that in solution conduct electric current and are decomposed by it. A measure of the equilibrium within the body of the chemical composition of fluids and tissues (homeostasis).

ESONOPHILS (Differential.)
Form of granulytic WBC. Increased in instances of malignancy and instances of allergy, parasitism, skin disease. Decreased levels noted with steroid therapy, and after trauma and infection.

ERYTHROPOIETIN (EPO).
A renal hormone that stimulates RBC production. Increased levels noted in iron deficiency and aplastic anemias, chronic obstructive pulmonary disease, pregnancy. Decreased levels noted in instances of renal failure, polycythemia vera, anemia of chronic disease, inflammatory states.

Back to top

F

FERRITIN.
An iron protein complex formed by union of ferric iron with apoferritin; found in the intestinal mucosa, liver and spleen. Decreased levels in instances of iron deficiency and of severe liver disease.

FOLLICLE STIMULATING HORMONE (FSH)
Gonadotropic hormone. Decreased levels noted in cases of ovarian tumors.

Back to top

G

GLUCOSE (CMG). Product of hydrolysis of cellulose, glycogen and starch. Syn: blood sugar, dextrose. Increased in instances of diabetes mellitus, acute pancreatitis, may also be the result of glucocorticoids and some diuretics. Decreased levels noted in instances of pancreatic disorders, cancer of the adrenal glands, gastric cancer, hepatic disease, endocrine disorders, sepsis.

Back to top

H

HEMATOCRIT (Hct) (CBC).
Percentage of volume of blood occupied by cells, as determined by centrifuge separation of blood cells from plasma. Used in evaluation of anemias, blood loss, polycythemia.

HEMOGLOBIN (Hgb) (CBC).
The red respiratory protein of RBCs that transport oxygen from lungs to tissues. The 2 types of adult hemoglobin are Hb A and Hb A2. Used in diagnosis of anemias.

HUMAN LEUKOCYTE ANTIGENS (HLA Typing).
Group of antigens on cell surface that are determinants of histocompatibility and used in assessing transplant compatibility. These include HLA-B27, HLA-DR4/HLA-DR2, HLA-DRw2, HLA-B8.

Back to top

I

IMMUNOGLOBULINS
A class of structurally related proteins used in evaluation of immunodeficiency diseases during replacement therapy. The class includes IgD, IgE, IgG, IgM. Increased levels of IgD and IgG and decreased levels of the other Igs are noted in cases of multiple myeloma. IgG levels are also elevated in cases of lymphoma. IgM levels are elevated in instances of Waldenstroms disease.

IRON
A metallic element, it occurs in the constituent of hemoglobin that carries oxygen and produces color (heme) and also in myoglobin, transferrin, ferritin and iron containing porphyrins. Increased levels found in instances of excessive destruction or decreased production of mature red blood cells (erythrocytes) and liver necrosis. Decreased levels noted in cases of iron deficiency anemia, loss of iron binding proteins, anemia of chronic disease, and infection.

IRON BINDING CAPACITY, Total (TIBC).
Amount of absorbed iron bound to transferrin and transported to bone marrow, the liver, spleen and other cells. Increased levels in instances of acute and chronic blood loss, iron deficiency anemia, hepatitis and women using oral contraceptives. Decreased levels noted in anemia of chronic disease.

Back to top

L

LACTATE DEHYDROGENASE (LDH).
Four enzymes involved in catalyzing the oxidation of a salt or ester of lactic acid to pyruvate, which is a salt or ester of pyruvic acid, an intermediate compound in the metabolism of carbohydrates. Increased levels noted in pernicious anemia, malignant tumors, pulmonary embolism, hemolysis, megaloblastic anemia and liver disease. Also increased in cases of cardiac disease.

LYMPHOCYTES. (Differential.)
A WBC formed in lymphoid tissue. In normal adults lymphocytes form apx. 25% of total WBC in circulating blood. Increased levels found in instances of viral infection and of acute and chronic lymphocytic leukemias. Decreased levels in instances of bone marrow suppression after chemotherapy and after trauma.

Back to top

M

MAGNESIUM.
A mineral element that oxidizes to the mineral earth, magnesia. Increased levels found in instances of severe dehydration, and in persons taking magnesium based antacids. Decreased levels in instances of acute pancreatitis, in persons taking diuretics, and those receiving treatment with amphotericin B, cisplatin or aminoglycosides.

MEAN CORPUSCULAR HEMOGLOBIN (MCH) (CBC).
Weight of hemoglobin in the average RBC. Increased volumes associated with megaloblastic anemias. Decreased volumes associated with iron deficiency anemia, sideroblastic anemia and thalassemia.

MEAN CORPUSCULAR HEMOGLOBIN CONCENTRATION (MCHC) (CBC.)
Average concentration of hemoglobin in a given volume of RBCs. Increased concentration noted in severe, prolonged dehydration. Decreased concentration noted in iron deficiency anemia, excess hydration, sideroblastic anemia and thalassemia.

MEAN CORPUSCULAR VOLUME (MCV) (CBC.)
Average volume of RBCs. Increased volumes found in instances of megaloblastic anemia, chronic liver disease. Decreased in instances of iron deficiency anemia, thassalemia.

MONOCYTES (Differential.)
Relatively large mononuclear WBCs, usually comprising apx. 5% of circulating blood. Normally found in bone marrow, loose connective tissue, lymph nodes and spleen. Increased levels associated with bacterial infection, leukemia and Hodgkins disease.

Back to top

N

NEUTROPHILS (Differential).
Granulytic WBCs formed in the bone marrow and released into circulating blood. Increased levels of neutrophils with multiple shaped nuclei are found after extensive exercise and in persons taking steroids and in instances of leukemia. Decreased levels are noted in instances of neutropenia, bone marrow damage, and as a side effect of apx. 70 drug therapies.

Back to top

P

PARTIAL THROMBOPLASTIN TIME (PTT) or
Activated Partial Thromboplastin Time (APTT)
Evaluates intrinsic coagulation system. Commonly used to monitor heparin therapy.

PLATELET COUNT (Including Mean Platelet Volume (MPV.)
Platelets are one of the 3 principal components of blood. Platelets play a major role in clotting process. Used in evaluation of bleeding disorders, thrombocytopenia, leukemia and chemotherapeutic management of malignancies.

POTASSIUM
Alkaline metallic element, largely intracellular, with lesser amounts present in bone and blood serum. Levels of potassium rise in inverse proportion to blood pH levels. Increased levels found in instances of dehydration and acidosis. Decreased levels associated with diarrhea and vomiting.

PROSTATE SPECIFIC ANTIGEN (PSA)
Antigen used in screening for prostate cancer and in monitoring therapeutic response in treatment of prostate cancer. Increased levels also may be found in instances of acute prostatitis and benign prostatic hypertrophy (BPH).

PROTEIN ELECTROPHORESIS (PEP).
Qualitative analysis of serum proteins used in diagnostic workup of liver disease and myeloma. Serum electrophoresis yields 5 bands or protein fractions: Albumin, Alpha-1 globulin, Alpha-2 globulin, Beta globulin, Gamma globulin. Immunoglobulin (Ig) series may be ordered in instances of monoclonal gammopathy (a disturbance in immunoglobulin synthesis) or a low globulin fraction.

PROTEIN (CMG.)
Macromolecules consisting of alpha amino acids in peptide linkage. Protein is _ of the dry weight of most cellular matter, and is involved in enzymes, hormones and essential life functions such as immunologic response and muscle contraction. Increased levels in instances of multiple myeloma, Waldenstroms disease, benign monoclonal gammopathy, lymphoma and chronic inflammatory disease. Decreased levels in instances of Hodgkins disease, leukemia, decreased albumin levels from any cause, and inflammatory bowel disease.

PROTHROMBIN TIME (PT)
Evaluates the extrinsic coagulation system. May be increased due to certain drugs, including Coumadin.

Back to top

R

RED BLOOD CELL COUNT (RBC)
Red blood cell are one of the 3 principal components of blood. The chief function of RBCs is the transporting of oxygen to all parts of the body. Increased levels are found in instances of megaloblastic anemias, myelodysplastic syndrome, liver disease and some aplastic anemias. Decreased levels are noted in instances of iron deficiency anemia, anemia of chronic disease and thalassemia. Syn: Erythrocyte.

RED BLOOD CELL DISTRIBUTION WIDTH (RDW). (CBC.)
Measure of the degree of variation in RBC size (anisocytosis). Increased width noted in many types of anemias.

RETICULOCYTE COUNT.
Reticulocytes are juvenile RBCs with remnants of RNA. Normal bone marrow responds to a decrease in RBCs with an increase in reticulocytes. This count is used in the workup of anemia, monitoring engraftment following transplant and recovery following myelosuppression. The reticulocyte percentage must be converted to a Corrected Reticulocyte Count, calculated as Reticulocyte count x Hematocrit level &Mac218; normal Hematocrit.

Back to top

S

SEDIMENTATION RATE (Erythrocyte Sedimentation Rate, ESR).
A non-specific screening test that measures the rate at which RBCs fall when blood is collected in an anti-coagulant medium. The test is most useful in serial measurement to follow the course of disease. Increased levels found in instances of infection, inflammation, endocarditis and neoplasm. Results may be measured on a Westergren, Wintrobe or ZETA scale.

SODIUM (CMG.)
A caustic, alkaline metallic element. It regulates the bodys extra-cellular fluid (ECF) content. Disorders of sodium balance are observed in ECF changes associated with multiple myeloma, also with vomiting, diarrhea, and pancreatitis.

Back to top

U

URIC ACID
An acid contained in solution in urine. Increased levels associated with anemia, chemotherapy, gout, leukemia and certain diuretics. Decreased levels associated with certain drugs, including allopurinol, probenecid, and salicylates.

W

WHITE BLOOD CELL COUNT (WBC). (CBC.)
White blood cells are one of 3 principal types of blood cells. The principal function of WBCs is to fight infection. Increased levels are often an indication that the body is fighting infection. Decreased levels are common during chemotherapy, and may be an indication of neutropenia. Syn: Leucocyte.
Back to top


Material contained in this publication is for information and educational purposes only.
It is not intended as medical advice, nor is it a substitute for professional health care.
This material should not be used to diagnose or treat any health care problem or disease.
If you have, or suspect you may have, a health problem, you should consult a physician.