﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Http;
using System.Web.Mvc;
using System.Web.Optimization;
using System.Web.Routing;
using log4net;
using log4net.Config;

using OSEHRAuth.Core.Models;

namespace OSEHRAuth.Website
{
    // Note: For instructions on enabling IIS6 or IIS7 classic mode, 
    // visit http://go.microsoft.com/?LinkId=9394801

    public class VABBAuthMVC4Application : System.Web.HttpApplication
    {
        public const string SESSIONDATA_KEY = "__SESSIONDATA";

        private static readonly ILog log = LogManager.GetLogger(typeof(VABBAuthMVC4Application));

        protected void Application_Start()
        {
            //AssemblyInfo.cs file has the log4net config file extension attribute.
            //configure log4net, which uses OSEHRAuth.Website.dll.log4net xml configuration file.
            XmlConfigurator.Configure();
            log.Info("OSEHRAuth.Website started....");

            AreaRegistration.RegisterAllAreas();

            WebApiConfig.Register(GlobalConfiguration.Configuration);
            FilterConfig.RegisterGlobalFilters(GlobalFilters.Filters);
            RouteConfig.RegisterRoutes(RouteTable.Routes);
            BundleConfig.RegisterBundles(BundleTable.Bundles);
        }

        protected void Session_Start()
        {
            HttpContext.Current.Session[SESSIONDATA_KEY] = new SessionData();
            log.Info(string.Format("New Session started with session Id: {0} with URL: {1}", HttpContext.Current.Session.SessionID, HttpContext.Current.Request.Url.AbsoluteUri));
        }        
    }
}