﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using log4net;

namespace OSEHRAuth.Website
{
    public class CustomHandleErrorAttribute : HandleErrorAttribute
    {
        private static readonly ILog log = LogManager.GetLogger(typeof(VABBAuthMVC4Application));
        
        public override void OnException(ExceptionContext filterContext)
        {
            LogException(filterContext.Exception);

            if (filterContext.HttpContext.IsCustomErrorEnabled)
            {
                filterContext.ExceptionHandled = true;
                base.OnException(filterContext);
            }
        }

        private void LogException(Exception ex)
        {
            log.Error(string.Format("Message: {0} Stacktrace: {1}", ex.Message, ex.StackTrace));
        }
    }
}