﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using OSEHRAuth.Core.Models.Post;

namespace OSEHRAuth.MdwsTests
{
    class TestSubjects : IEnumerable<PersonDTO>
    {
        public TestSubjects() { populateInitialTestSubjects(); }

        public PersonDTO this[string key]
        {
            get
            {
                return subjects[key];
            }
        }

        System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
        {
            return subjects.GetEnumerator();
        }

        IEnumerator<PersonDTO> IEnumerable<PersonDTO>.GetEnumerator()
        {
            return subjects.Values.GetEnumerator();
        }

        private Dictionary<string, PersonDTO> subjects = new Dictionary<string, PersonDTO>();
        public const string SUBJECT_NOT_FOUND = "SUBJECT_NOT_FOUND", STAR = "STAR", VICENTE = "VICENTE", MARK = "MARK", SALLY = "SALLY", MARY = "MARY",
            JENNIFER = "JENNIFER", PADMA = "PADMA", GOLDBERG = "GOLDBERG", LORRAIN = "LORRAIN", MARTHA = "MARTHA",
            ROSADO = "ROSADO", ALEXANDER = "ALEXANDER", GILBERT = "GILBERT", DENNYS = "DENNYS", C = "C", 
            ELLANA = "ELLANA", MARGARET = "MARGARET", STEVEN = "STEVEN", BENJAMIN = "BENJAMIN", CAROLE = "CAROLE", 
            DOUGLAS = "DOUGLAS", RONALD = "RONALD", TADEO = "TADEO", SERENA = "SERENA", JEAN = "JEAN", 
            NAIM = "NAIM", ERICH = "ERICH", RICHARD = "RICHARD", ANNA = "ANNA", LORI = "LORI", CAROL = "CAROL", 
            TERRY = "TERRY", HARRIETTE = "HARRIETTE", PATRICIA = "PATRICIA", NANCY = "NANCY", PAUL = "PAUL", 
            CONNIE = "CONNIE", MICHAEL = "MICHAEL", JEROME = "JEROME", SONDRA = "SONDRA", PAULINE = "PAULINE", 
            TALI = "TALI", HARRIET = "HARRIET", GEORGE = "GEORGE", LESHAWN = "LESHAWN", ERNESTO = "ERNESTO", 
            MATHEW = "MATHEW", JAMES = "JAMES", VIRGINIA = "VIRGINIA", REGINA = "REGINA", FRANK = "FRANK",
            JOHN = "JOHN", EDITH = "EDITH", TIMOTHY = "TIMOTHY", PEGGY = "PEGGY", FLORENCE = "FLORENCE", 
            ERWIN = "ERWIN";
            

        private void populateInitialTestSubjects()
        {
            subjects.Add(SUBJECT_NOT_FOUND, new PersonDTO()
            {
                FirstName = "xx", LastName = "xxxxxxxxx", DateOfBirth = new DateTime(1910, 1, 31),
                StreetAddress = "1001 xxxx xx", City = "YUxx", StateCode = "AZ", ZipCode = "85365",
                Ssn = "258888888", SsnRepeat = "123456789"
            });
            subjects.Add(STAR, new PersonDTO()
            {
                FirstName = "STcv", LastName = "AAertN", DateOfBirth = new DateTime(1910, 1, 31),
                StreetAddress = "1001 Jttt ST", City = "YttA", StateCode = "AZ", ZipCode = "85365",
                Ssn = "5144ttyy1", SsnRepeat = "514447785"
            });
            subjects.Add(VICENTE, new PersonDTO()
            {
                FirstName = "ViiiiTE", LastName = "ABAMooTE", DateOfBirth = new DateTime(1959, 11, 23),
                StreetAddress = "14145 PEooooNG CR", City = "MiooNA", StateCode = "CA", ZipCode = "93933",
                Ssn = "444444432", SsnRepeat = "544444632"
            });
            subjects.Add(ELLANA, new PersonDTO()
            {
                FirstName = "ELL44A",
                LastName = "4uu",
                DateOfBirth = new DateTime(1910, 1, 31),
                StreetAddress = "36-15 30 uuE",
                City = "LOre 444CH",
                StateCode = "Cw",
                ZipCode = "44414",
                Ssn = "534446256",
                SsnRepeat = "539644456"
            });
            
         }

    }
}
