﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System.Threading.Tasks;

using OSEHRAuth.Core;
using OSEHRAuth.Core.Models.Post;

namespace OSEHRAuth.UnitTests
{
    [TestClass]
    public class MdwsEmrServiceTests
    {
        string vistaAccessCode = "04VEHU", vistaVerifyCode = "VEHU04";
        string vistaSiteCode = "901";
        MdwsEmrService mdwsEmrService = new MdwsEmrService();

        [TestMethod]
        public void TestConnect()
        {
            mdwsEmrService.VistaAccessCode = vistaAccessCode;
            mdwsEmrService.VistaVerifyCode = vistaVerifyCode;
            
        }
        [TestMethod]
        public void TestMatchSsnKnownNotExistent()
        {
            string testSsn = "123456789";
            mdwsEmrService.VistaAccessCode = vistaAccessCode;
            mdwsEmrService.VistaVerifyCode = vistaVerifyCode;
            mdwsEmrService.VistaSiteCode = vistaSiteCode; 

            PersonDTO person = new PersonDTO();
            person.Ssn = testSsn;
            Task<bool> resultTask = mdwsEmrService.IsPatientInVistaAsync(person);
            MdwsServiceException mse = null;
            try
            {
                resultTask.Wait();
            }
            catch (AggregateException ae)
            {
                if (ae.InnerException is MdwsServiceException)
                    mse = (MdwsServiceException)ae.InnerException;
            }
            Assert.IsNotNull(mse);
            Assert.IsTrue("No patients returned for that search...".Equals(mse.Message));
        }
        [TestMethod]
        public void TestMatchSsnKnownUnique()
        {
            string testSsn = "666330008";
            mdwsEmrService.VistaAccessCode = vistaAccessCode;
            mdwsEmrService.VistaVerifyCode = vistaVerifyCode;
            mdwsEmrService.VistaSiteCode = vistaSiteCode; 

            PersonDTO person = new PersonDTO();
            person.Ssn = testSsn;
            Task<bool> resultTask = mdwsEmrService.IsPatientInVistaAsync(person);
            bool patientExistsInVista = false;
            MdwsServiceException mse = null;
            try
            {
                resultTask.Wait();
                patientExistsInVista = resultTask.Result;
            }
            catch (AggregateException ae)
            {
                if (ae.InnerException is MdwsServiceException)
                    mse = (MdwsServiceException)ae.InnerException;
            }
            Assert.IsTrue(patientExistsInVista);
        }
    }
}
