﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System.Threading.Tasks;

using OSEHRAuth.Core;
using OSEHRAuth.Core.Models;
using OSEHRAuth.Core.Models.Post;

namespace OSEHRAuth.MdwsTests
{
    [TestClass]
    public class IdentityServiceTests
    {
        private IdentityService identityService = new IdentityService();
        private TestSubjects testSubjects = new TestSubjects();

        //TestMethods do not use await async because that requires async key word to be added to TestMethod.
        //If async key word is added to test method, then these test methods are not listed in TestExplorer View.
        [TestMethod]
        public void TestSubjectNotFound()
        {
            PersonDTO personDTO = testSubjects[TestSubjects.SUBJECT_NOT_FOUND];
            try
            {
                Quiz authenticationQuiz = identityService.Verify();
            }
            catch (AggregateException ae)
            {
                string expectedMessage = "Failed to retrive identity";
                Assert.IsTrue(expectedMessage.Equals(ae.InnerExceptions[0].Message));
            }
        }

        [TestMethod]
        public void TestNotEnoughQuestions()
        {
            PersonDTO personDTO = testSubjects[TestSubjects.VICENTE];
            try
            {
                Quiz authenticationQuiz = identityService.Verify();
            }
            catch (AggregateException ae)
            {
                string expectedMessage = "Not enough questions";
                Assert.IsTrue(expectedMessage.Equals(ae.InnerExceptions[0].Message));
            }
        }

        [TestMethod]
        public void TestVelocityFailed()
        {
            PersonDTO personDTO = testSubjects[TestSubjects.VICENTE];
            try
            {
                Quiz authenticationQuizTask = identityService.Verify();
            }
            catch (AggregateException ae)
            {
                string expectedMessage = "Velocity failed";
                Assert.IsTrue(expectedMessage.Equals(ae.InnerExceptions[0].Message));
            }
        }

        [TestMethod]
        public void TestVerify()
        {
            PersonDTO personDTO = testSubjects[TestSubjects.VICENTE];
            Quiz authenticationQuiz = identityService.Verify();
            Assert.IsTrue(authenticationQuiz.Questions.Length == 3);
        }

        [TestMethod]
        public void TestAuthenticate()
        {
            PersonDTO personDTO = testSubjects[TestSubjects.ELLANA];
            Quiz authenticationQuiz = identityService.Verify();
            Assert.IsTrue(authenticationQuiz.Questions.Length == 3);
            Quiz quizResponse = new Quiz() 
            {
                QuizId = authenticationQuiz.QuizId,
                TxnId = authenticationQuiz.TxnId,
                Questions = new QuizQuestion[] 
                {
                    new QuizQuestion(){QuestionId ="Q1", ChoiceId = "Ch1"}, 
                    new QuizQuestion(){QuestionId ="Q2", ChoiceId = "Ch2"},
                    new QuizQuestion(){QuestionId ="Q3", ChoiceId = "Ch3"}
                }
            };

            SessionData sessionData = new SessionData();
            sessionData.Person = personDTO;

            QuizScoreDTO score = identityService.Authenticate(quizResponse, sessionData);
            Assert.IsTrue("1".Equals(score.QuizScore.Score));
        }
    }
}
