﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.ServiceModel.Configuration;
using System.ServiceModel.Description;

namespace OSEHRAuth.Extensions
{
    public class SOAPMessageInspectionBehavior : BehaviorExtensionElement, IEndpointBehavior
    {
        void IEndpointBehavior.AddBindingParameters(ServiceEndpoint endpoint, System.ServiceModel.Channels.BindingParameterCollection bindingParameters)
        {
            //not used
        }

        void IEndpointBehavior.ApplyClientBehavior(ServiceEndpoint endpoint, System.ServiceModel.Dispatcher.ClientRuntime clientRuntime)
        {
            //this is where our custom message inspector is added to the pipeline
            clientRuntime.MessageInspectors.Add(new ClientRequestInspector());
        }

        void IEndpointBehavior.ApplyDispatchBehavior(ServiceEndpoint endpoint, System.ServiceModel.Dispatcher.EndpointDispatcher endpointDispatcher)
        {
            //not used
        }

        void IEndpointBehavior.Validate(ServiceEndpoint endpoint)
        {
            //not used
        }

        //implement abstract class BehaviorExtensionElement
        public override Type BehaviorType
        {
            get { return typeof(SOAPMessageInspectionBehavior); }
        }

        protected override object CreateBehavior()
        {
            return new SOAPMessageInspectionBehavior();
        }
    }
}
