﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Xml;
using System.ServiceModel.Channels;


namespace OSEHRAuth.Extensions
{
    class CustomSecurityHeader : MessageHeader
    {
        /*        ** STAGING**      */ 
        private const string identityServiceUserName = "8000rrB_cd_EF";
        private const string identityServicePassword = "ABCD1234";
        
        /*        **PRODUCTION**   
        private const string identityServiceUserName = "120ty560oxx_xx";
        private const string identityServicePassword = "12!@34#$6@";
        */

        private const string userNameTokenElement = 
            "<UsernameToken wsu:Id=\"UsernameToken-49\" xmlns:wsu=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\">" +
            "<Username>{0}</Username> <Password Type=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText\">{1}" +
            "</Password> <Nonce EncodingType=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary\">d+hyuiioolpoxxxKEr/ofA==</Nonce>" +
            "<wsu:Created>{2}</wsu:Created> </UsernameToken>";
           
        const string WS_SECURITY_HEADER_NAMESPACE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
        
        private string timeStamp;

        public CustomSecurityHeader(string timeStamp)
        {
            this.timeStamp = timeStamp;
        }

        protected override void OnWriteHeaderContents(System.Xml.XmlDictionaryWriter writer, MessageVersion messageVersion)
        {
            writer.WriteRaw(string.Format(userNameTokenElement, identityServiceUserName, identityServicePassword, timeStamp));
        }

        public override bool MustUnderstand
        {
            get
            {
                return true;
            }
        }

        public override string Name
        {
            get { return "Security"; }
        }

        public override string Namespace
        {
            get { return WS_SECURITY_HEADER_NAMESPACE; }
        }
    }
}
