﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.ServiceModel.Dispatcher;
using System.ServiceModel.Channels;

using System.ServiceModel.Description;
using System.ServiceModel.Security;


using log4net;

namespace OSEHRAuth.Extensions
{
    public class ClientRequestInspector: IClientMessageInspector
    {


        private static readonly ILog log = LogManager.GetLogger(typeof(ClientRequestInspector));

        void IClientMessageInspector.AfterReceiveReply(ref System.ServiceModel.Channels.Message reply, object correlationState)
        {
            log.Debug("AfterReceiveReply method called..");
            log.Debug("Response received: " + reply.ToString());
          //not used
        }

        object IClientMessageInspector.BeforeSendRequest(ref System.ServiceModel.Channels.Message request, System.ServiceModel.IClientChannel channel)
        {
            log.Debug("BeforeSendRequest method called..");
            AddSecurityHeader(ref request);
            log.Debug("Request sent: " + request.ToString());
            return null;
        }

        void AddSecurityHeader(ref System.ServiceModel.Channels.Message request)
        {
            request.Headers.Add(new CustomSecurityHeader(DateTime.Now.ToString("u")));
        }
    }

}
