﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.ComponentModel.DataAnnotations;

namespace OSEHRAuth.Core.Models
{
    public class Quiz
    {
        public string LexId { get; set; }
        [Required]
        public string QuizId { get; set; }
        [Required]
        public string TxnId { get; set; }
        public QuizQuestion[] Questions { get; set; }
    }

    public class QuizQuestion
    {
        [Required]
        public string QuestionId { get; set; }
        public string QuestionType { get; set; }
        public int SequenceId { get; set; }
        public string QuestionText { get; set; }
        [Required(ErrorMessage = "Answer not selected for the question.")]
        public string ChoiceId { get; set; }
        public AnswerChoice[] AnswerChoices { get; set; }
    }
    public class AnswerChoice
    {
        public string ChoiceId { get; set; }
        public int SequenceId { get; set; }
        public string ChoiceText { get; set; }
    }


}
