﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.ComponentModel;

using System.ComponentModel.DataAnnotations;


namespace OSEHRAuth.Core.Models.Post
{
    public class PersonDTO
    {
        private string firstName, lastName, streetAddress, city;
        [Required]
        [DisplayName("Your First Name")]
        [DisplayFormat(NullDisplayText="First Name")]
        public string FirstName { get { return (firstName == null)? firstName : firstName.ToUpper(); } set { firstName = value; } }

        [Required]
        [DisplayName("Your Last Name")]
        public string LastName { get {return (lastName == null)? lastName:lastName.ToUpper() ;} set {lastName = value ;} }

        [Required]
        [DisplayName("Street Address")]
        public string StreetAddress { get {return (streetAddress == null)? streetAddress : streetAddress.ToUpper() ;} set {streetAddress = value ;} }

        [Required]
        [DisplayName("City")]
        public string City { get { return (city == null)? city : city.ToUpper();} set {city = value ;} }

        [Required(AllowEmptyStrings=false, ErrorMessage="State Code Required.")]
        [DisplayName("State")]
        public string StateCode { get; set; }

        [Required]
        [RegularExpression("[0-9]{5}", ErrorMessage = "Enter all 5 - digits only - for Zip / Postal Code")]
        [DisplayName("Zip / Postal Code")]
        public string ZipCode { get; set; }

        [Required]
        [DataType(DataType.Password)]
        [RegularExpression("[0-9]{9}", ErrorMessage = "Enter all 9 - digits only - for SSN")]
        [DisplayName("Social Security Number")]
        public string Ssn { get; set; }

        [Required]
        [DataType(DataType.Password)]
        [RegularExpression("[0-9]{9}", ErrorMessage = "Enter all 9 - digits only - for re-enter SSN")]
        [DisplayName("Re-Enter Your Social Security Number")]
        [Compare("Ssn", ErrorMessage = "Social Security does not match above entry")]
        public string SsnRepeat { get; set; }

        [Required]
        /*[DataType(DataType.Date)]*/
        [DataType(DataType.Password)]
        [RegularExpression("(0[1-9]|1[012])[- /.](0[1-9]|[12][0-9]|3[01])[- /.](19|20)\\d\\d", ErrorMessage = "Date should be in [MM/DD/YYYY] format")]
        [DisplayName("Date of Birth [MM/DD/YYYY]")]
        [DisplayFormat(DataFormatString="Date")]
        public DateTime? DateOfBirth { get; set; }

        public override string ToString()
        {
            return string.Format("Person - FirstName: {0} LastName: {1} Address: {2} Zip: {3} ",
                firstName, lastName, streetAddress, ZipCode);
        } 
    }
}
