﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Diagnostics;


using OSEHRAuth.Core.mdwsMhv;
using OSEHRAuth.Core.Models.Post;

namespace OSEHRAuth.Core
{
    public class MdwsMhvService
    {
        public async Task<bool> IsPatientInCdwAsync(PersonDTO cdwPerson)
        {
            bool isPatientInCdw = false;
            MhvServiceSoapClient mhvServiceSoapClient = null;
            const int ONLYONE_PATIENT = 1;
            try
            {
                string password = "";//per Joel Mewton, this parameter value is not used for now.
                mhvServiceSoapClient = new MhvServiceSoapClient();
                PatientArray result = await mhvServiceSoapClient.cdwLookupSlimAsync(password, cdwPerson.Ssn);
                Debug.Assert(result != null);
                if (result.count == ONLYONE_PATIENT) //NOT IF ZERO OR MORE THAN ONE
                    isPatientInCdw = true;
            }
            catch (Exception )
            {
                //Exception means SSN does not exist or some other error
                //isPatientInCdw remains false
            }
            finally
            {
                if (mhvServiceSoapClient != null)
                    mhvServiceSoapClient.disconnect();
            }
            return isPatientInCdw;
        }

    }
}
