﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Diagnostics;

using OSEHRAuth.Core.mdws;

using log4net;

using OSEHRAuth.Core.Models.Post;

namespace OSEHRAuth.Core
{
    public class MdwsEmrService
    {
        private static readonly ILog log = LogManager.GetLogger(typeof(MdwsEmrService));

        public string VistaAccessCode { get; set; }
        public string VistaVerifyCode { get; set; }
        public string VistaSiteCode { get; set; }

        public async Task<bool> IsPatientInVistaAsync(PersonDTO vistaPerson)
        {
            VistaDao vistaDao = null;
            bool isPatientInVista = false;
            try
            {
                vistaDao = new VistaDao();
                string connectedWelcomeMessage = await vistaDao.connectAsync(VistaSiteCode);
                UserTO user = await vistaDao.loginAsync(VistaAccessCode, VistaVerifyCode);
                IList<PatientTO> result = await vistaDao.matchAsync(vistaPerson.Ssn);
                Debug.Assert(result != null);
                if (result.Count > 0)
                    isPatientInVista = true;
            }
            finally
            {
                if (vistaDao != null)
                    vistaDao.disconnect();
            }
            return isPatientInVista;
        }

    }
}
