﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.ServiceModel;
using System.ServiceModel.Channels;
using System.ServiceModel.Security;

using System.Diagnostics;

using log4net;

using OSEHRAuth.Core;
using OSEHRAuth.Core.Models;
using OSEHRAuth.Core.Models.Post;

namespace OSEHRAuth.Core
{
    public class IdentityService
    {
        private static readonly ILog log = LogManager.GetLogger(typeof(IdentityService));
        private const int MAX_VELOCITY = 2;

        private SessionData sessionData;

        public IdentityService()
        {
        }

        public IdentityService(SessionData sessionData)
        {
            this.sessionData = sessionData;
        }

        //verify person details and return quiz
        public Quiz Verify()
        {
            try
            {
                Quiz authenticationQuiz = null;
                if (true)
                {
                    return authenticationQuiz;
                }
                else if (false)
                {
                    StringBuilder exceptionMessage = new StringBuilder("Identity Proofing Exceptions for Request TxnId ");
                    AuthenticationServiceException ex = new AuthenticationServiceException(exceptionMessage.ToString().TrimEnd());
                    throw ex;
                }

            }
            finally
            {
                //cleanup
            }
        }

        /// <summary>
        /// Sends quiz response submitted by Person for scoring and returns QuizScoreDTO, if Person passes the quiz.
        /// If fails the quiz, then 
        ///     gets the VelocityExceeded (or not) value.
        ///     Throws QuizExpiredException or AuthenticationFailedException, setting the VelocityExceeded value,
        ///      so that the controller can either offer another attempt if velocity is not exceeded.
        /// </summary>
        /// <param name="quizResponse"></param>
        /// <param name="sessionData"></param>
        /// <returns></returns>
        public QuizScoreDTO Authenticate(Quiz quizResponse, SessionData sessionData)
        {
            bool velocityNotExceeded = (sessionData.AuthenticateCount < MAX_VELOCITY);
            try
            {
                QuizScoreDTO quizScoreDTO = Converters.IdentityProofingResponseToQuizScoreDTO();
                if (quizScoreDTO != null)
                {
                    if (quizScoreDTO.QuizPassed())
                        return quizScoreDTO;
                    else
                        if (quizScoreDTO.QuizExpired())
                        {
                            QuizExpiredException qee = new QuizExpiredException();
                            throw qee;
                        }
                        else //quiz failed
                        {
                            if (velocityNotExceeded)
                            { //check if exceeded on the Authentication service.
                                AuthenticationFailedException afe = new AuthenticationFailedException();
                                throw afe;
                            }
                            else
                                return null;
                        }
                }
                else
                    return null;
            }
            finally
            {
                //cleanup
            }
        }

        /// <summary>
        /// Gets the velocity count from IdentityService
        /// </summary>
        /// <param name="personToVerify"></param>
        /// <returns></returns>
        public bool GetVelocityNotExceededAsync(SessionData sessionData)
        {
            bool velocityNotExceeded = true;
            return velocityNotExceeded;
        }

        /// <summary>
        /// If identityProofingResponse.productResponse[] has DiscoveryResponse object and its status is FAIL
        /// then return true, else false.
        /// </summary>
        /// <param name="identityProofingResponse"></param>
        /// <returns></returns>
        private bool SubjectNotFound()
        {
            bool subjectNotFound = false;
            return subjectNotFound;
        }

        private bool NotEnoughQuestions()
        {
            bool notEnoughQuestions = false;

            return notEnoughQuestions;
        }

        private bool VelocityFailed()
        {
            bool velocityFailed = false;

            return velocityFailed;
        }

        /// <summary>
        /// Returns true if InstantVerifyResponse.Status == FAIL and its verificationSubProductResponse has Identityverification checkgroup.
        /// </summary>
        /// <param name="identityProofingResponse"></param>
        /// <returns></returns>
        private bool IdentityVerificationFailed()
        {
            bool verificationFailed = false;
            return verificationFailed;
        }


        private bool QuizFailed()
        {
            bool quizFailed = false;
            return quizFailed;
        }

        private bool QuizExpired()
        {
            bool quizExpired = false;
            return quizExpired;
        }

        private Guid GetNewTransactionId()
        {
            return Guid.NewGuid();
        }

    }
}
