﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Configuration;

namespace OSEHRAuth.Core
{

    public static class Global
    {
        #region constants
        public const string PASS = "PASS";
        public const string FAIL = "FAIL";
        public const string PENDING = "PENDING";
        public const string VELOCITY_GROUPNAME = "Velocity";
        public const string IDENTITY_VERIFICATION_GROUPNAME = "Identity Verification";
        public const string QUIZ_VELOCITY = "QuizVelocity";
        public const string VERIFICATION_FAILED_RESPONSECODE = "ID:1";
        public const string QUIZ_EXPIRED_CODE = "IA:21";
        public const string VELOCITY_EXCEEDED_CODE = "IA:33";
        public const string UNABLE_TO_GENERATE = "UNABLE_TO_GENERATE";
        public const string SUBJECT_NOT_FOUND_ERROR_MESSAGE = "Sorry, but we've not been able to verify your identity " +
            "based on the information you've entered. Please try again.\r\n You are given {0}({1}) opportunity(ies) to complete " +
            "this step. If we are not able to verify your identity on your {2} attempt, you'll need to visit your " +
            "local VA office to verify your identity in person.";
        public const string TIMEOUT_WARNING = "For your security, this session will be closed in one minute. " +
            "If you do not submit your responses before that time this will count as an incomplete submission. " +
            "You are only allowed 2 failed attempts before you must verify your identity in person with the VA.";
        
        public static string[] StateCodes = new string[] {"", "AK", "AL", "AR","AS", "AZ", "CA", "CO","CT", "DC", "DE", "FL",
        "GA","GU","HI","IA","ID","IL","IN","KS","KY","LA","MA","MD","ME","MI","MN","MO","MP","MS","MT","NC","ND","NE","NH","NJ",
        "NM","NV", "NY","OH","OK","OR","PA","PR","RI","SC","SD","TN","TX","UM","UT","VA","VI","VT","WA","WI","WV","WY"};

        public static string VISTA_SITECODE = ConfigurationManager.AppSettings.Get("VistaSiteCode");
        public static string VISTA_ACCESSCODE = ConfigurationManager.AppSettings.Get("VistaAccessCode");
        public static string VISTA_VERIFYCODE = ConfigurationManager.AppSettings.Get("VistaVerifyCode");
        #endregion constants
    }

    public enum ExpectResponseTxn
    {
        PASS_VERIFY = 0,
        PASS_AUTHENTICATE = 1,
        FAIL_SUBJECT_NOT_FOUND = -1,
        FAIL_NOT_ENOUGH_QUESTIONS = -2,
        FAIL_VELOCITY = -3,
        FAIL_QUIZ = -4,
        FAIL_QUIZ_EXPIRED = -5
    }

}
