{
Copyright  DSS, Inc.
All Rights Reserved.

PURPOSE:  This form will reveal the the 1000 line "recent database traffic" log stored by the TDSSRPCBroker.
 AUTHOR:  Brian Smith
  DATES:  MM/DD/YY BS 1.0 1st version.

  NOTES:  Since it has been designed to be shown non-modally (using the "Stay on Top"
          checkbox, the user can watch database traffic as they use the program), it
          should not be created, shown and freed (though you *can* do that if you want).
          it should instead by in the autocreate list. Please see any of my projects for
          this has been implemented.

          It's simply to use: here's the code under the "show broker history" menu command in ROI

          if frmBrokerCallHistory = nil then
            frmBrokerCallHistory := TfrmBrokerCallHistory.Create(application);

          frmBrokerCallHistory.ShowHistoryOfABroker(Broker);
          frmBrokerCallHistory.show;

          If it hasn't already been created, we create it. Then we pass in the
          broker whose history we want to see, and then we .Show the form.
}
unit fBrokerCallHistory;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, dssrpc, ExtCtrls, Trpcb;

type
  TfrmBrokerCallHistory = class(TForm)
    memCallHistory: TMemo;
    btnClose: TButton;
    btnSaveToFile: TButton;
    dlgSave: TSaveDialog;
    btnClipboard: TButton;
    Button1: TButton;
    btnFindAgain: TButton;
    chkMonitor: TCheckBox;
    tmrUpdate: TTimer;
    procedure btnCloseClick(Sender: TObject);
    procedure btnSaveToFileClick(Sender: TObject);
    procedure btnClipboardClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure btnFindAgainClick(Sender: TObject);
    procedure chkMonitorClick(Sender: TObject);
    procedure tmrUpdateTimer(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
  private                                        { Private declarations }
    FBroker: TRPCBroker;
    FSearchTerm: string;
    FSearchPos: integer;
    procedure DoFind;
  public                                         { Public declarations }
    procedure ShowHistoryOfABroker(thisBroker: TRPCBroker);
  end;

  PStringList = ^TStringList;

var
  frmBrokerCallHistory: TfrmBrokerCallHistory;
  thisItem: PStringList;

implementation

uses
  dsslibrary, clipbrd, fSearchCriteria;

{$R *.DFM}

{ TfrmBrokerCallHistory }

procedure TfrmBrokerCallHistory.ShowHistoryOfABroker(thisBroker: TRPCBroker);
var
  i: integer;
begin
  if FBroker = nil then
    FBroker := thisBroker
  else //if FBroker <> dssBroker then
    FBroker := thisBroker;

  //memCallHistory.Lines.Assign(FCallHistoryList);

end;

procedure TfrmBrokerCallHistory.btnCloseClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmBrokerCallHistory.btnSaveToFileClick(Sender: TObject);
begin
  dlgSave.InitialDir := appdir;
  if dlgSave.Execute then
    memCallHistory.Lines.SaveToFile(dlgSave.filename);
end;

procedure TfrmBrokerCallHistory.btnClipboardClick(Sender: TObject);
begin
  if memCallHistory.SelLength > 0 then
    //something is highlighted - just copy that.
    clipboard.SetTextBuf(pchar(memCallHistory.seltext))
  else
    clipboard.SetTextBuf(pchar(memCallHistory.Text));
end;

procedure TfrmBrokerCallHistory.Button1Click(Sender: TObject);
var
  sFind: string;
begin
  sFind := inputbox('Find (not case sensitive)', 'Find what ?', '');

  if sFind > '' then
    begin
      FSearchPos  := 0;
      FSearchTerm := sFind;
      btnFindAgain.hint := 'Find "' + sFind + '" again';
      DoFind;
    end;
end;

procedure TfrmBrokerCallHistory.DoFind;
var
  sSearchArea: string;
  iPos: integer;
begin
  sSearchArea := copy(memCallHistory.Text, FSearchPos, length(
      memCallHistory.Text) - FSearchPos);
  iPos := pos(ansilowercase(FSearchTerm), ansilowercase(sSearchArea));
  if iPos > 0 then
    begin
      memCallHistory.selstart  := FSearchPos - 1 + iPos;
      memCallHistory.sellength := length(FSearchTerm);

      Inc(FSearchPos, iPos + 1);
      btnFindAgain.Enabled := true;
    end
  else
    FSearchPos := 0;
end;

procedure TfrmBrokerCallHistory.btnFindAgainClick(Sender: TObject);
begin
  DoFind;
end;

procedure TfrmBrokerCallHistory.chkMonitorClick(Sender: TObject);
begin
  if chkMonitor.Checked then
    self.formstyle := fsStayOnTop
  else
    self.formstyle := fsNormal;
  tmrUpdate.Enabled := chkMonitor.Checked;
end;

procedure TfrmBrokerCallHistory.tmrUpdateTimer(Sender: TObject);
begin
{
  if FBroker <> nil then
    if copy(FBroker.CallHistoryList.Text, 1, 255) <> copy(memCallHistory.Text, 1, 255) then
}      ShowHistoryOfABroker(FBroker);

end;

procedure TfrmBrokerCallHistory.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  tmrUpdate.Enabled := FALSE;
end;

procedure TfrmBrokerCallHistory.FormShow(Sender: TObject);
var
  i: integer;
begin
  tmrUpdate.Enabled := chkMonitor.Checked;
end;

end.
