{
Copyright  DSS, Inc.
All Rights Reserved.

PURPOSE:  Unit with various DSS 'utility' routines.
 AUTHOR:  J. Clarke
  DATES:  12/27/06 JAC 1.0 1st version.

  NOTES:
}
unit DSSVistaUtils;

interface

uses
  Windows,SysUtils;

function ConvertDate(DelphiDate:TDateTime):String;
function ConvertFileManDate(FMDateTime:String):TDateTime;
function ConvertFileManTime(FMDateTime:String):TDateTime;
function ConvertTime(DelphiTime:TDateTime):String;
function NTGetUserName:String;
function Piece(x: string; del: string; piece: integer) : string;

implementation


function ConvertDate(DelphiDate:TDateTime):String;
var
  Year, Month, Day: Word;
  FirstTwoYear,LastTwoYear,MonthSubString,DaySubString,CenturySubString:String;
begin
  DecodeDate(DelphiDate, Year, Month, Day);
  if length(IntToStr(Month)) =1 then MonthSubString :='0'+IntToStr(Month)
  else MonthSubString := IntToStr(Month);
  if length(IntToStr(Day)) = 1 then DaySubString:='0'+IntToStr(Day)
  else DaySubString := IntToStr(Day);
  FirstTwoYear := Copy(IntToStr(Year),0,2);
  LastTwoYear := Copy(IntToStr(Year),3,2);
  CenturySubString := IntToStr(StrToInt(FirstTwoYear)-17);
  Result := CenturySubString+LastTwoYear+MonthSubString+DaySubString;
end;

function ConvertFileManDate(FMDateTime:String):TDateTime;
{ Converts a FileMan date to a Delphi Date. }
var
  FirstYearString,YearString,MonthString,DayString:String;
begin
  try
    FirstYearString := IntToStr(StrToInt(Copy(FMDateTime, 1, 1)) + 17);
    YearString := Copy(FMDateTime, 2, 2);
    MonthString := Copy(FMDateTime, 4, 2);
    if (MonthString='0') or (MonthString='00') or (MonthString='') then MonthString:='01';
    DayString := Copy(FMDateTime, 6, 2);
    if (DayString='0')or(DayString='00') or (DayString='') then DayString:='01';
    Result := EncodeDate(StrToInt(FirstYearString+YearString),StrToInt(MonthString),StrToInt(DayString));
  except on exception do Result := Now;
  end;
end;

function ConvertFileManTime(FMDateTime:String):TDateTime;
var
  sHour,sMin,sSec:String;
  Hour, Min, Sec: Word;
begin
  if Piece(FMDateTime,'.',2)<> '' then
    begin
      if Piece(FMDateTime,'.',2)='24' then
        begin
          Hour:=0;
          Min:=0;
          Sec:=0;
        end
      else
        begin
          sHour:=Copy(Piece(FMDateTime,'.',2), 1, 2);
          if Length(sHour)<2 then sHour:=sHour+'0';
          sMin:=Copy(Piece(FMDateTime,'.',2), 3, 2);
          if Length(sMin)<2 then sMin:=sMin+'0';
          sSec:=Copy(Piece(FMDateTime,'.',2), 5, 2);
          if Length(sSec)<2 then sSec:=sSec+'0';
          if sHour<>'' then Hour:=StrToIntDef(sHour,0) else Hour:=0;
          if sMin<>'' then Min:=StrToIntDef(sMin,0) else Min:=0;
          if sSec<>'' then Sec:=StrToIntDef(sSec,0) else Sec:=0;
        end;
    end
  else
    begin
      if FMDateTime='24' then
        begin
          Hour:=0;
          Min:=0;
          Sec:=0;
        end
      else
        begin
          sHour:=Copy(FMDateTime, 1, 2);
          if Length(sHour)<2 then sHour:=sHour+'0';
          sMin:=Copy(FMDateTime, 3, 2);
          if Length(sMin)<2 then sMin:=sMin+'0';
          sSec:=Copy(FMDateTime, 5, 2);
          if Length(sSec)<2 then sSec:=sSec+'0';
          if sHour<>'' then Hour:=StrToIntDef(sHour,0) else Hour:=0;
          if sMin<>'' then Min:=StrToIntDef(sMin,0) else Min:=0;
          if sSec<>'' then Sec:=StrToIntDef(sSec,0) else Sec:=0;
        end;
    end;
  try
    Result := EncodeTime(Hour, Min, Sec, 0);
  except on exception do Result := Now;
  end;
end;

function ConvertTime(DelphiTime:TDateTime):String;
var
  Hour, Min, Sec, MSec: Word;
  HourSubString,MinSubString,SecSubString:String;
begin
  DecodeTime(DelphiTime, Hour, Min, Sec, MSec);
  if length(IntToStr(Hour))=1 then HourSubString:='0'+IntToStr(Hour)
  else HourSubString:=IntToStr(Hour);
  if length(IntToStr(Min))=1 then MinSubString:='0'+IntToStr(Min)
  else MinSubString:=IntToStr(Min);
  if length(IntToStr(Sec))=1 then SecSubString:='0'+IntToStr(Sec)
  else SecSubString:=IntToStr(Sec);
  if (HourSubString='00')and(SecSubString='00')and(MinSubString='00') then
    Result:='000001'
  else if (SecSubString='00')and(MinSubString='00') then
    Result:=HourSubString
  else if SecSubString='00' then
    Result:=HourSubString+MinSubString
  else Result:=HourSubString+MinSubString+SecSubString;
end;

function NTGetUserName:String;
var
  lpBuffer: lpstr;
  success: Boolean;
  nSize: DWord;
begin
  nSize := 255;
  Result := '';
  GetMem(lpBuffer, 255);
  try
    try
      success := GetUserNameA(lpBuffer, nSize);
      if not success then Result := 'Unknown NT User'
      else Result := StrPas(lpBuffer);
    except on exception do
      begin
        Result := 'Unknown NT User';
      end;
    end;
  finally
    FreeMem(lpBuffer);
  end;
end;

function Piece(x: string; del: string; piece: integer) : string;
var
  delIndex,pieceNumber,startScanIndex,firstCharIndex: integer;
begin
  startScanIndex:=1;
  pieceNumber :=0;
  delIndex :=1;
  repeat
  delIndex := Pos(del,Copy(x+del,startScanIndex,length(x)));
  if delIndex > 0 then
    begin
      inc(pieceNumber);
      firstCharIndex := startScanIndex;
      startScanIndex := startScanIndex + delIndex + Length(del) - 1;
     end;
  until (pieceNumber = piece) or (delIndex = 0);
  if delIndex > 0 then Result := Copy(x, firstCharIndex, delIndex-1)
  else if (pieceNumber > 0) or (piece > 1) then Result := ''
  else Result := x;
end;

end.
 