{
Copyright  DSS, Inc.
All Rights Reserved.

PURPOSE:  A collection of routines that go between bool and strings.  originally lived in sausage.pas
          This is useful for storing boolean values in a database or ini file in whatever
          format is appropriate (ie T/F, Yes/No, 1/0, True/False).
 AUTHOR:  Brian Smith
  DATES:  MM/DD/YY BS <= 1.0 1st version.
          11/06/08 JAC 1.1 Formatted/Documented code.

  NOTES:
}
unit dssbool;

interface

function BoolToTF(bBoolean: boolean): string;
function BoolToTrueFalse(bBoolean: boolean): string;
function BoolToYN(bBoolean: boolean): string;
function BoolToYesNo(bBoolean: boolean): string;
function BoolToOneZero(bBoolean: boolean): integer;
function BoolToOneZeroString(bBoolean: boolean): string;
function IsTrue(sTemp: string): boolean; //True if sTemp = 'yes|true|1'
function PickTrue(bBoolean:boolean;sTrueVal,sFalseVal:string):string;

implementation

uses SysUtils;

function BoolToOneZero(bBoolean: boolean): integer;
// Returns a numberic 1 or 0
begin
  if bBoolean then
    Result := 1
  else
    Result := 0;
end;

function BoolToOneZeroString(bBoolean: boolean): string;
// Returns a string '1' or '0'
begin
  Result := IntToStr(BoolToOneZero(bBoolean));
end;

function IsTrue(sTemp: string): boolean;
// Returns boolean based on content of sTemp.
begin
  Result := false;
  if (SameText(sTemp, 'yes')) or (SameText(sTemp, 'true')) or (SameText(sTemp, 'y')) or
     (SameText(sTemp, 't')) or (SameText(sTemp, '1') or (SameText(sTemp,'-1'))) then
    Result := true;
end;

function BoolToYN(bBoolean: boolean): string;
// Returns a string 'Y' or 'N'
begin
  if bBoolean then
    Result := 'Y'
  else
    Result := 'N';
end;

function BoolToYesNo(bBoolean: boolean): string;
// Returns a string 'Yes' or 'No'
begin
  if bBoolean then
    Result := 'Yes'
  else
    Result := 'No';
end;

function BoolToTF(bBoolean: boolean): string;
// Returns a string 'T' or 'F'
begin
  if bBoolean then
    Result := 'T'
  else
    Result := 'F';
end;

function BoolToTrueFalse(bBoolean: boolean): string;
// Returns a string 'True' or 'False'
begin
  if bBoolean then
    Result := 'True'
  else
    Result := 'False';
end;

function PickTrue(bBoolean:boolean;sTrueVal,sFalseVal:string):string;
// If true, return sTrueVal, else return sFalseVal
begin
  if bBoolean then
    result := sTrueVal
  else
    result := sFalseVal;
end;

end.
