unit UDssAbout;
{
Copyright 2012 Document Storage Systems, Inc. 

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
}
interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls, ExtCtrls, Dialogs;

//procedure GetExeVersionAndName(var FileVersion: string; var FileName: string);

type
  PVerTranslation = ^TVerTranslation;
  TVerTranslation = record
    Language : Word;
    CharSet  : Word;
  end;

type
  TDSSAboutDlg = class(TForm)
    Panel1: TPanel;
    ProgramIcon: TImage;
    lblAppName: TLabel;
    lblCopyright: TLabel;
    lblCompany: TLabel;
    btnOk: TButton;
    Bevel1: TBevel;
    labelMemory: TLabel;
    labelOS: TLabel;
    Memo1: TMemo;
    lblWebAddress: TLabel;
    lblBuilder: TLabel;
    lblInternalName: TLabel;
    lblCNTVersion: TLabel;
    Image3: TImage;
    procedure FormShow(Sender: TObject);
    procedure lblWebAddressClick(Sender: TObject);
  private                                        { Private declarations }
  public                                         { Public declarations }
  end;

var
  DSSAboutDlg: TDSSAboutDlg;

function FileVersionGet(const sgFileName: string) : string; 

implementation

{$R *.DFM}

uses shellAPI, DateUtils;
{
procedure GetExeVersionAndName(var FileVersion: string; var FileName: string);
var
  Buf : array[0..1023] of char;
  ThisFileName : string;
  iVerInfoSize : integer;
  LocalHandle : DWORD;
  pVerInfoData : Pointer;
  pBuf : Pointer;
  NumOfBytes : Cardinal;
  LangSet : PVerTranslation;
  StartOfSubblock : string;
  TmpCStr : array[0..256] of char;
begin
  if GetModuleFileName(0,Buf,SizeOf(Buf)) = 0 then
    ThisFileName := ''
  else
    ThisFileName := StrPas(Buf);

  if (ThisFileName <> '') then
    begin
      iVerInfoSize := GetFileVersionInfoSize(Buf,LocalHandle);
      if iVerInfoSize <> 0 then
        begin
          GetMem(pVerInfoData,iVerInfoSize);
          if (GetFileversionInfo(Buf, LocalHandle,iVerInfoSize,pVerInfoData)) then
            begin
              if (VerQueryValue(pVerInfoData,'\VarFileInfo\Translation',pBuf,NumOfBytes)) then
                begin
                  GetMem(Langset,NumOfBytes);
                  Move(pBuf^,LangSet^,NumOfBytes);
                  StartOfSubBlock := Format('StringFileInfo\%.4x%.4x\',[LangSet^.Language, LangSet^.CharSet]);
                  if ((VerQueryValue(pVerInfoData,StrPCopy(TmpCStr,StartOfSubBlock + 'FileVersion'),pBuf,NumOfBytes)) and
                     (NumOfBytes > 0)) then
                    begin
                      FileVersion := StrPas(pBuf);
                    end;
                  if ((VerQueryValue(pVerInfoData,StrPCopy(TmpCStr,StartOfSubBlock + 'InternalName'),pBuf,NumOfBytes)) and
                      (NumOfBytes > 0)) then
                    begin
                      FileName := StrPas(pBuf);
                    end;
                end;
            end;
        end
      else //iVerInfoSize = 0
        begin
        end;
    end;
end;
}
function FileVersionGet(const sgFileName: string) : string; 
var
  infoSize: DWORD;
  verBuf: pointer;
  verSize: UINT;
  wnd: UINT;
  FixedFileInfo : PVSFixedFileInfo;
begin 
  infoSize := GetFileVersioninfoSize(PChar(sgFileName), wnd);

  result := '';
  if infoSize <> 0 then
  begin
  GetMem(verBuf, infoSize);
    try
      if GetFileVersionInfo(PChar(sgFileName), wnd, infoSize, verBuf) then
        begin
        VerQueryValue(verBuf, '\', Pointer(FixedFileInfo), verSize);

        result := IntToStr(FixedFileInfo.dwFileVersionMS div $10000) + '.' +
        IntToStr(FixedFileInfo.dwFileVersionMS and $0FFFF) + '.' +
        IntToStr(FixedFileInfo.dwFileVersionLS div $10000) + '.' +
        IntToStr(FixedFileInfo.dwFileVersionLS and $0FFFF);
        end;
    finally
      FreeMem(verBuf);
    end;
  end;
end; 

procedure TDSSAboutDlg.FormShow(Sender: TObject);
var
  Memstat: TMemoryStatus;
  MyVerInfo: TOSVersionInfo;
  OSystem: string;
  sInternalName : string;
  ret: string;
begin
  ProgramIcon.Picture.Assign(Application.Icon);
  // Version info
  MyVerInfo.dwOSVersionInfoSize :=SizeOf(TOSVersionInfo);
  GetVersionEx(MyVerInfo);

  // Memory Info
  Memstat.dwLength := SizeOf(TMemoryStatus);
  GlobalMemoryStatus(MemStat);

  // Version and Internal Name
  //GetExeVersionAndName(sCNTVersion, sInternalName);

  // Text
  lblCompany.Caption := 'DSS Patient Search Tool';//'Document Storage Systems, Inc.';
  lblAppName.Caption := '';//'CPRS Search Tool';
  //lblInternalName.Caption := 'Internal File Name: ' +  sInternalName;
  ret := FileVersionGet('DSSPatientRecordSearch.dll');
  lblCNTVersion.Caption := 'Version: ' + ret;
  lblCopyright.Caption := 'Copyright ' + chr(169) + ' ' + IntToStr(YearOf(Now));
{
  case MyVerInfo.dwPlatformID of
    VER_PLATFORM_WIN32s: OSystem := 'Win32s';
    VER_PLATFORM_WIN32_WINDOWS: OSystem := 'Windows 95';
    VER_PLATFORM_WIN32_NT: OSystem := 'Windows NT';
  end;
}
  OSystem := OSystem + ' ' + InttoStr(MyVerInfo.dwmajorVersion) + '.' + InttoStr(MyVerInfo.dwminorVersion) + ' build(' + InttoStr(MyVerInfo.dwBuildNumber) + ')';
  labelOS.Caption := OSystem;
  labelMemory.Caption := 'Memory Available: ' + IntToStr(Round(MemStat.dwTotalPhys/1024)) + ' KB';
end;

procedure TDSSAboutDlg.lblWebAddressClick(Sender: TObject);
  var TempString : array[0..79] of char;
begin
  StrPCopy(TempString,lblWebAddress.Caption);
  ShellExecute(0, Nil, TempString, Nil, Nil, SW_NORMAL);
end;

end.

