//---------------------------------------------------------------------------
// Copyright 2012 Ray Group International
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//---------------------------------------------------------------------------

package com.raygroupintl.vista.repository.visitor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.raygroupintl.m.parsetree.data.EntryId;
import com.raygroupintl.m.parsetree.data.EntryIdWithSource;
import com.raygroupintl.output.FileWrapper;
import com.raygroupintl.vista.repository.RepositoryInfo;
import com.raygroupintl.vista.repository.VistaPackage;
import com.raygroupintl.vista.repository.VistaPackages;

public class OptionWriter {
	private RepositoryInfo repositoryInfo;
	private FileWrapper fileWrapper;
	
	public OptionWriter(RepositoryInfo repositoryInfo, FileWrapper fileWrapper) {
		this.repositoryInfo = repositoryInfo;
		this.fileWrapper = fileWrapper;
	}
		
	public void write(VistaPackages vps) {
		List<VistaPackage> packages = this.repositoryInfo.getAllPackages();
		List<EntryIdWithSource> options = this.repositoryInfo.getOptionEntryPoints();				
		Map<String, List<EntryIdWithSource>> optionsByPackage = new HashMap<String, List<EntryIdWithSource>>();
		for (VistaPackage p : packages) {
			String name = p.getPackageName();
			optionsByPackage.put(name, new ArrayList<EntryIdWithSource>());
		}
		for (EntryIdWithSource option : options) {
			EntryId eid = option.getEntryId();
			String routineName = eid.getRoutineName();
			if ((routineName != null) && (! routineName.isEmpty())) {
				VistaPackage vp = this.repositoryInfo.getPackageFromRoutineName(routineName);
				String name = vp.getPackageName();
				List<EntryIdWithSource> pkgOptions = optionsByPackage.get(name);
				pkgOptions.add(option);
			}
		}		
		if (this.fileWrapper.start()) {
			int index = 0;
			List<VistaPackage> reportPackages = vps.getPackages();
			boolean multi = reportPackages.size() > 1;
			for (VistaPackage p : reportPackages) {
				++index;
				String name = p.getPackageName();
				String prefix = multi ? String.valueOf(index) + ". " : "";
				this.fileWrapper.writeEOL(prefix + name);
				this.fileWrapper.writeEOL();
				List<EntryIdWithSource> reportOptions = optionsByPackage.get(name);
				if ((reportOptions != null) && (reportOptions.size() > 0)) {
					Collections.sort(reportOptions);
					for (EntryIdWithSource reportOption : reportOptions) {
						this.fileWrapper.writeEOL(" NAME: " + reportOption.getSource());
						this.fileWrapper.writeEOL("  TAG: " + reportOption.getEntryId().toString());
						this.fileWrapper.writeEOL();
					}
				} else {
					this.fileWrapper.writeEOL("  No entries");
					this.fileWrapper.writeEOL();					
				}
			}
			this.fileWrapper.stop();
		}
	}
}