//---------------------------------------------------------------------------
// Copyright 2012 Ray Group International
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//---------------------------------------------------------------------------

package com.raygroupintl.vista.repository;

import com.raygroupintl.m.parsetree.Routine;

public abstract class RepositoryVisitor {
	protected abstract void visitRoutine(Routine routine);

	protected void visitError() {		
	}

	protected void visitVistaPackage(VistaPackage routinePackage) {
		routinePackage.acceptSubNodes(this);
	}

	protected void visitRoutinePackages(VistaPackages routinePackages) {
		routinePackages.acceptSubNodes(this);
	}
}
