/*
 * Copyright (c) Mirth Corporation. All rights reserved.
 * http://www.mirthcorp.com
 *
 * The software in this package is published under the terms of the MPL
 * license a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */

package com.mirth.connect.server.mule.transformers;

import org.apache.log4j.Logger;

import com.mirth.connect.model.Channel;
import com.mirth.connect.model.MessageObject;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.util.JavaScriptUtil;

public class JavaScriptPostprocessor {
    private Logger logger = Logger.getLogger(this.getClass());

    public void doPostProcess(MessageObject messageObject) {
        JavaScriptUtil.getInstance().executePostprocessorScripts(messageObject);
        String channelId = messageObject.getChannelId();

        Channel channel = ControllerFactory.getFactory().createChannelController().getDeployedChannelById(channelId);

        if (channel != null && channel.getProperties().containsKey("store_messages")) {
            if (channel.getProperties().get("store_messages").equals("false") || (channel.getProperties().get("store_messages").equals("true") && channel.getProperties().get("error_messages_only").equals("true") && !messageObject.getStatus().equals(MessageObject.Status.ERROR)) || (channel.getProperties().get("store_messages").equals("true") && channel.getProperties().get("dont_store_filtered").equals("true") && messageObject.getStatus().equals(MessageObject.Status.FILTERED))) {
                // message is not stored, remove attachment if there is one
                if (messageObject.isAttachment()) {
                    ControllerFactory.getFactory().createMessageObjectController().deleteAttachments(messageObject);
                }
            }
        }
    }

    public void doPostProcess(Object object) throws IllegalArgumentException {
        if (object instanceof MessageObject) {
            doPostProcess((MessageObject) object);
        } else {
            logger.error("Could not postprocess, object is not of type MessageObject. Cannot wait for response on Channel Writer: None.");
            throw new IllegalArgumentException("Object is not of type MessageObject");
        }
    }
}
